/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.sql.Blob;
import java.util.UUID;

@Entity
public class POSSubReport
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="mainReport_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSReportDefinition mainReport;
    private String subreportId;
    private String reportFileName;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSReportDefinition subreportDefinition;
    private Blob subreportFile;
    private Blob arabicVersion;
    private Blob englishVersion;

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public POSReportDefinition getMainReport() {
        this.mainReport = POSPersister.materialize(POSReportDefinition.class, this.mainReport);
        return this.mainReport;
    }

    public void setMainReport(POSReportDefinition mainReport) {
        this.mainReport = mainReport;
    }

    public String getSubreportId() {
        return this.subreportId;
    }

    public void setSubreportId(String subreportId) {
        this.subreportId = subreportId;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    public POSReportDefinition getSubreportDefinition() {
        this.subreportDefinition = POSPersister.materialize(POSReportDefinition.class, this.subreportDefinition);
        return this.subreportDefinition;
    }

    public void setSubreportDefinition(POSReportDefinition subreportDefinition) {
        this.subreportDefinition = subreportDefinition;
    }

    public Blob getSubreportFile() {
        return this.subreportFile;
    }

    public void setSubreportFile(Blob subreportFile) {
        this.subreportFile = subreportFile;
    }

    public Blob getArabicVersion() {
        return this.arabicVersion;
    }

    public void setArabicVersion(Blob arabicVersion) {
        this.arabicVersion = arabicVersion;
    }

    public Blob getEnglishVersion() {
        return this.englishVersion;
    }

    public void setEnglishVersion(Blob englishVersion) {
        this.englishVersion = englishVersion;
    }
}

