/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSTranslationOverrider;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class POSTranslationLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    private String entityType;
    private String lineID;
    private String arabic;
    private String english;
    @JoinColumn(name="posTranslation_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSTranslationOverrider posTranslation;

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void initializeLists() {
    }

    public String getLineID() {
        return this.lineID;
    }

    public void setLineID(String lineID) {
        this.lineID = lineID;
    }

    public String getArabic() {
        return this.arabic;
    }

    public void setArabic(String arabic) {
        this.arabic = arabic;
    }

    public String getEnglish() {
        return this.english;
    }

    public void setEnglish(String english) {
        this.english = english;
    }

    public POSTranslationOverrider getPosTranslation() {
        this.posTranslation = POSPersister.materialize(POSTranslationOverrider.class, this.posTranslation);
        return this.posTranslation;
    }

    public void setPosTranslation(POSTranslationOverrider posTranslation) {
        this.posTranslation = posTranslation;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String calcLineId() {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getEntityType())) {
            return this.getEntityType() + "." + this.getLineID();
        }
        return this.getLineID();
    }
}

