/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.details.DTONamaPosAdditionalItemsLine;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.PosItemAdditionalItems;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class PosAdditionalItemsLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="addItems_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private PosItemAdditionalItems addItems;
    private String additionalItemsType;
    private String titleInPOS;
    private Boolean canMultiSelect;
    private Boolean makeAddItemsRequired;
    private Boolean addSearchButton;
    private Boolean addPagingButton;

    public PosAdditionalItemsLine() {
    }

    public PosAdditionalItemsLine(DTONamaPosAdditionalItemsLine l) {
        this.assignIds();
        this.setAdditionalItemsType(l.getAdditionalItemsType());
        this.setTitleInPOS(l.getTitleInPOS());
        this.setCanMultiSelect(l.getCanMultiSelect());
        this.setMakeAddItemsRequired(l.getMakeAddItemsRequired());
        this.setAddSearchButton(l.getAddSearchButton());
        this.setAddPagingButton(l.getAddPagingButton());
    }

    public PosItemAdditionalItems getAddItems() {
        return this.addItems;
    }

    public void setAddItems(PosItemAdditionalItems addItems) {
        this.addItems = addItems;
    }

    public String getAdditionalItemsType() {
        return this.additionalItemsType;
    }

    public void setAdditionalItemsType(String additionalItemsType) {
        this.additionalItemsType = additionalItemsType;
    }

    public String getTitleInPOS() {
        return this.titleInPOS;
    }

    public void setTitleInPOS(String titleInPOS) {
        this.titleInPOS = titleInPOS;
    }

    public Boolean getCanMultiSelect() {
        if (ObjectChecker.isEmptyOrNull((Object)this.canMultiSelect)) {
            this.canMultiSelect = false;
        }
        return this.canMultiSelect;
    }

    public void setCanMultiSelect(Boolean canMultiSelect) {
        this.canMultiSelect = canMultiSelect;
    }

    public Boolean getMakeAddItemsRequired() {
        if (ObjectChecker.isEmptyOrNull((Object)this.makeAddItemsRequired)) {
            this.makeAddItemsRequired = false;
        }
        return this.makeAddItemsRequired;
    }

    public void setMakeAddItemsRequired(Boolean makeAddItemsRequired) {
        this.makeAddItemsRequired = makeAddItemsRequired;
    }

    public Boolean getAddSearchButton() {
        if (ObjectChecker.isEmptyOrNull((Object)this.addSearchButton)) {
            this.addSearchButton = false;
        }
        return this.addSearchButton;
    }

    public void setAddSearchButton(Boolean addSearchButton) {
        this.addSearchButton = addSearchButton;
    }

    public Boolean getAddPagingButton() {
        if (ObjectChecker.isEmptyOrNull((Object)this.addPagingButton)) {
            this.addPagingButton = false;
        }
        return this.addPagingButton;
    }

    public void setAddPagingButton(Boolean addPagingButton) {
        this.addPagingButton = addPagingButton;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }
}

