/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.details.DTONamaPosDefaultsTemplateLine;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.PosDefaultsTemplate;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.Date;
import java.util.UUID;

@Entity
public class PosDefaultsTemplateLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="defaultsTemplate_id")
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    private PosDefaultsTemplate defaultsTemplate;
    private String forType;
    private String field;
    private String refValueType;
    private String refValueCode;
    private String refValueName1;
    private String refValueName2;
    @Column(length=16)
    private UUID refValueId;
    private Date dateValue;
    private String textValue;

    public PosDefaultsTemplateLine() {
    }

    public PosDefaultsTemplateLine(DTONamaPosDefaultsTemplateLine object) {
        this.setForType(object.getForType());
        this.setField(object.getField());
        this.setTextValue(object.getTextValue());
        this.setDateValue(object.getDateValue());
        if (ObjectChecker.isNotEmptyOrNull((Object)object.getRefValue())) {
            this.setRefValueId(ServerStringUtils.strToUUID((String)object.getRefValue().getId()));
            this.setRefValueType(object.getRefValue().getEntityType());
            this.setRefValueCode(object.getRefValue().getCode());
            this.setRefValueName1(object.getRefValue().getName1());
            this.setRefValueName2(object.getRefValue().getName2());
        } else {
            this.setRefValueType(null);
            this.setRefValueId(null);
            this.setRefValueCode(null);
            this.setRefValueName1(null);
            this.setRefValueName2(null);
        }
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public PosDefaultsTemplate getDefaultsTemplate() {
        this.defaultsTemplate = POSPersister.materialize(PosDefaultsTemplate.class, this.defaultsTemplate);
        return this.defaultsTemplate;
    }

    public void setDefaultsTemplate(PosDefaultsTemplate defaultsTemplate) {
        this.defaultsTemplate = defaultsTemplate;
    }

    public String getForType() {
        return this.forType;
    }

    public void setForType(String forType) {
        this.forType = forType;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getRefValueType() {
        return this.refValueType;
    }

    public void setRefValueType(String refValueType) {
        this.refValueType = refValueType;
    }

    public UUID getRefValueId() {
        return this.refValueId;
    }

    public void setRefValueId(UUID refValueId) {
        this.refValueId = refValueId;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public String getRefValueCode() {
        return this.refValueCode;
    }

    public void setRefValueCode(String refValueCode) {
        this.refValueCode = refValueCode;
    }

    public String getRefValueName1() {
        return this.refValueName1;
    }

    public void setRefValueName1(String refValueName1) {
        this.refValueName1 = refValueName1;
    }

    public String getRefValueName2() {
        return this.refValueName2;
    }

    public void setRefValueName2(String refValueName2) {
        this.refValueName2 = refValueName2;
    }
}

