/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.details.DTOPGWMethodGroupLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOPGWProperties;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.entities.PosPGWMethodGroup;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.UUID;

@Entity
@XmlRootElement
public class PosMethodGroupLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="methodGroup_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private PosPGWMethodGroup methodGroup;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSPaymentMethod paymentMethod;
    private String panNum;
    private String stanNum;
    private String terminalId;
    private String schemeId;
    private String merchantId;
    private String ecrRefNum;
    private String panNumOperator;
    private String stanNumOperator;
    private String terminalIdOperator;
    private String schemeIdOperator;
    private String merchantIdOperator;
    private String ecrRefNumOperator;
    private String de55Response;
    private String de55ResponseOperator;
    private String cardType;
    private String cardTypeOperator;
    private String maskedCardNumber;
    private String maskedCardNumberOperator;

    public PosMethodGroupLine() {
    }

    public PosMethodGroupLine(DTOPGWMethodGroupLine l) {
        DTOPGWProperties pgwProperties = l.getPgwProperties();
        if (ObjectChecker.isNotEmptyOrNull((Object)pgwProperties)) {
            this.setEcrRefNum(pgwProperties.getEcrRefNum());
            this.setPanNum(pgwProperties.getPanNum());
            this.setSchemeId(pgwProperties.getSchemeId());
            this.setMerchantId(pgwProperties.getMerchantId());
            this.setStanNum(pgwProperties.getStanNum());
            this.setTerminalId(pgwProperties.getTerminalId());
            this.setCardType(pgwProperties.getCardType());
            this.setMaskedCardNumber(pgwProperties.getMaskedCardNumber());
            this.setDe55Response(pgwProperties.getDe55Response());
        }
        this.setEcrRefNumOperator(l.getEcrRefNumOperator());
        this.setPanNumOperator(l.getPanNumOperator());
        this.setSchemeIdOperator(l.getSchemeIdOperator());
        this.setTerminalIdOperator(l.getTerminalIdOperator());
        this.setStanNumOperator(l.getStanNumOperator());
        this.setMerchantIdOperator(l.getMerchantIdOperator());
        this.setPaymentMethod((POSPaymentMethod)this.fromReference(l.getPaymentMethod()));
        this.setDe55ResponseOperator(l.getDe55ResponseOperator());
        this.setCardTypeOperator(l.getCardTypeOperator());
        this.setMaskedCardNumberOperator(l.getMaskedCardNumberOperator());
    }

    public String getDe55ResponseOperator() {
        return this.de55ResponseOperator;
    }

    public void setDe55ResponseOperator(String de55ResponseOperator) {
        this.de55ResponseOperator = de55ResponseOperator;
    }

    public String getCardTypeOperator() {
        return this.cardTypeOperator;
    }

    public void setCardTypeOperator(String cardTypeOperator) {
        this.cardTypeOperator = cardTypeOperator;
    }

    public String getMaskedCardNumberOperator() {
        return this.maskedCardNumberOperator;
    }

    public void setMaskedCardNumberOperator(String maskedCardNumberOperator) {
        this.maskedCardNumberOperator = maskedCardNumberOperator;
    }

    public String getStanNum() {
        return this.stanNum;
    }

    public void setStanNum(String stanNum) {
        this.stanNum = stanNum;
    }

    public PosPGWMethodGroup getMethodGroup() {
        this.methodGroup = POSPersister.materialize(PosPGWMethodGroup.class, this.methodGroup);
        return this.methodGroup;
    }

    public void setMethodGroup(PosPGWMethodGroup methodGroup) {
        this.methodGroup = methodGroup;
    }

    public POSPaymentMethod getPaymentMethod() {
        this.paymentMethod = POSPersister.materialize(POSPaymentMethod.class, this.paymentMethod);
        return this.paymentMethod;
    }

    public void setPaymentMethod(POSPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getPanNum() {
        return this.panNum;
    }

    public String getDe55Response() {
        return this.de55Response;
    }

    public void setDe55Response(String de55Response) {
        this.de55Response = de55Response;
    }

    public String getCardType() {
        return this.cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getMaskedCardNumber() {
        return this.maskedCardNumber;
    }

    public void setMaskedCardNumber(String maskedCardNumber) {
        this.maskedCardNumber = maskedCardNumber;
    }

    public void setPanNum(String panNum) {
        this.panNum = panNum;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public String getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(String schemeId) {
        this.schemeId = schemeId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getEcrRefNum() {
        return this.ecrRefNum;
    }

    public void setEcrRefNum(String ecrRefNum) {
        this.ecrRefNum = ecrRefNum;
    }

    public String getPanNumOperator() {
        return this.panNumOperator;
    }

    public void setPanNumOperator(String panNumOperator) {
        this.panNumOperator = panNumOperator;
    }

    public String getStanNumOperator() {
        return this.stanNumOperator;
    }

    public void setStanNumOperator(String stanNumOperator) {
        this.stanNumOperator = stanNumOperator;
    }

    public String getTerminalIdOperator() {
        return this.terminalIdOperator;
    }

    public void setTerminalIdOperator(String terminalIdOperator) {
        this.terminalIdOperator = terminalIdOperator;
    }

    public String getSchemeIdOperator() {
        return this.schemeIdOperator;
    }

    public void setSchemeIdOperator(String schemeIdOperator) {
        this.schemeIdOperator = schemeIdOperator;
    }

    public String getMerchantIdOperator() {
        return this.merchantIdOperator;
    }

    public void setMerchantIdOperator(String merchantIdOperator) {
        this.merchantIdOperator = merchantIdOperator;
    }

    public String getEcrRefNumOperator() {
        return this.ecrRefNumOperator;
    }

    public void setEcrRefNumOperator(String ecrRefNumOperator) {
        this.ecrRefNumOperator = ecrRefNumOperator;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }
}

