/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.modules.namapos.contracts.details.DTONamaPosRequiredFieldsLine;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.domain.entities.PosRequiredFields;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class PosRequiredFieldsLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    private String entityType;
    private String fieldID;
    private String relationWithCustomer;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCustomer customer;
    private String relationWithSalesMan;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee salesMan;
    private String relationWithClassification;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSInvoiceClassification invoiceClassification;
    private String relationWithDocCategory;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosDocCategory docCategory;
    private String relationWithWarehouse;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSWarehouse warehouse;
    private String relationWithLocator;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSLocation locator;
    private String posFieldType;
    @JoinColumn(name="reqFields_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private PosRequiredFields reqFields;

    public PosRequiredFieldsLine() {
    }

    public PosRequiredFieldsLine(DTONamaPosRequiredFieldsLine line) {
        this.assignIds();
        this.setEntityType(line.getEntityType());
        this.setFieldID(line.getFieldID());
        this.setRelationWithCustomer(line.getRelationWithCustomer());
        this.setRelationWithClassification(line.getRelationWithClassification());
        this.setRelationWithDocCategory(line.getRelationWithDocCategory());
        this.setRelationWithLocator(line.getRelationWithLocator());
        this.setRelationWithSalesMan(line.getRelationWithSalesMan());
        this.setRelationWithWarehouse(line.getRelationWithWarehouse());
        this.setCustomer((POSCustomer)this.fromReference(line.getCustomer()));
        this.setInvoiceClassification((POSInvoiceClassification)this.fromReference(line.getInvoiceClassification()));
        this.setWarehouse((POSWarehouse)this.fromReference(line.getWarehouse()));
        this.setLocator((POSLocation)this.fromReference(line.getLocator()));
        this.setDocCategory((PosDocCategory)this.fromReference(line.getDocCategory()));
        this.setSalesMan((POSEmployee)this.fromReference(line.getSalesMan()));
        this.setPosFieldType(line.getPosFieldType());
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(String fieldID) {
        this.fieldID = fieldID;
    }

    public String getRelationWithCustomer() {
        return this.relationWithCustomer;
    }

    public void setRelationWithCustomer(String relationWithCustomer) {
        this.relationWithCustomer = relationWithCustomer;
    }

    @Override
    public POSCustomer getCustomer() {
        this.customer = POSPersister.materialize(POSCustomer.class, this.customer);
        return this.customer;
    }

    public void setCustomer(POSCustomer customer) {
        this.customer = customer;
    }

    public String getRelationWithSalesMan() {
        return this.relationWithSalesMan;
    }

    public void setRelationWithSalesMan(String relationWithSalesMan) {
        this.relationWithSalesMan = relationWithSalesMan;
    }

    public POSEmployee getSalesMan() {
        this.salesMan = POSPersister.materialize(POSEmployee.class, this.salesMan);
        return this.salesMan;
    }

    public void setSalesMan(POSEmployee salesMan) {
        this.salesMan = salesMan;
    }

    public String getRelationWithClassification() {
        return this.relationWithClassification;
    }

    public void setRelationWithClassification(String relationWithClassification) {
        this.relationWithClassification = relationWithClassification;
    }

    public POSInvoiceClassification getInvoiceClassification() {
        this.invoiceClassification = POSPersister.materialize(POSInvoiceClassification.class, this.invoiceClassification);
        return this.invoiceClassification;
    }

    public void setInvoiceClassification(POSInvoiceClassification invoiceClassification) {
        this.invoiceClassification = invoiceClassification;
    }

    public String getRelationWithDocCategory() {
        return this.relationWithDocCategory;
    }

    public void setRelationWithDocCategory(String relationWithDocCategory) {
        this.relationWithDocCategory = relationWithDocCategory;
    }

    public PosDocCategory getDocCategory() {
        this.docCategory = POSPersister.materialize(PosDocCategory.class, this.docCategory);
        return this.docCategory;
    }

    public void setDocCategory(PosDocCategory docCategory) {
        this.docCategory = docCategory;
    }

    public String getRelationWithWarehouse() {
        return this.relationWithWarehouse;
    }

    public void setRelationWithWarehouse(String relationWithWarehouse) {
        this.relationWithWarehouse = relationWithWarehouse;
    }

    public POSWarehouse getWarehouse() {
        this.warehouse = POSPersister.materialize(POSWarehouse.class, this.warehouse);
        return this.warehouse;
    }

    public void setWarehouse(POSWarehouse warehouse) {
        this.warehouse = warehouse;
    }

    public String getRelationWithLocator() {
        return this.relationWithLocator;
    }

    public void setRelationWithLocator(String relationWithLocator) {
        this.relationWithLocator = relationWithLocator;
    }

    public POSLocation getLocator() {
        this.locator = POSPersister.materialize(POSLocation.class, this.locator);
        return this.locator;
    }

    public void setLocator(POSLocation locator) {
        this.locator = locator;
    }

    public String getPosFieldType() {
        return this.posFieldType;
    }

    public void setPosFieldType(String posFieldType) {
        this.posFieldType = posFieldType;
    }

    public PosRequiredFields getReqFields() {
        this.reqFields = POSPersister.materialize(PosRequiredFields.class, this.reqFields);
        return this.reqFields;
    }

    public void setReqFields(PosRequiredFields reqFields) {
        this.reqFields = reqFields;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }
}

