/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.IHasTableColumns;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.valueobjects.POSActionType;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSActionHistory
extends POSMasterFile
implements IHasTableColumns {
    private String posUserCode;
    @Column(name="posUserId", length=16)
    private UUID posUserId;
    private String actionType;
    private String actionTypeDescription;
    private String actionEntityType;
    private String actionEntityCode;
    @Column(name="actionEntityId", length=16)
    private UUID actionEntityId;
    private String moreInfo;
    private Date actionDate;

    public UUID getPosUserId() {
        return this.posUserId;
    }

    public void setPosUserId(UUID posUserId) {
        this.posUserId = posUserId;
    }

    public String getActionEntityType() {
        return this.actionEntityType;
    }

    @Enumerated(value=EnumType.STRING)
    public void setActionEntityType(String actionEntityType) {
        this.actionEntityType = actionEntityType;
    }

    public String getActionEntityCode() {
        return this.actionEntityCode;
    }

    public void setActionEntityCode(String actionEntityCode) {
        this.actionEntityCode = actionEntityCode;
    }

    public UUID getActionEntityId() {
        return this.actionEntityId;
    }

    public void setActionEntityId(UUID actionEntityId) {
        this.actionEntityId = actionEntityId;
    }

    public void setPosUserCode(String posUserCode) {
        this.posUserCode = posUserCode;
    }

    public String getPosUserCode() {
        return this.posUserCode;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getActionTypeDescription() {
        return this.actionTypeDescription;
    }

    public String getMoreInfo() {
        return this.moreInfo;
    }

    public Date getActionDate() {
        return this.actionDate;
    }

    @Override
    public String calcNamaEntityType() {
        return this.getClass().getSimpleName();
    }

    public static POSActionHistory create(POSMasterFile actionEntity, POSActionType actionType) {
        POSUser currentUser;
        POSActionHistory actionHistory = new POSActionHistory();
        actionHistory.setActionType(actionType.name());
        actionHistory.setActionDate(new Date());
        POSSettingsInfo currentSetting = POSSettingsInfo.fetchConfiguration();
        POSUser pOSUser = currentUser = currentSetting == null ? null : currentSetting.getCurrentUser();
        if (currentUser != null) {
            actionHistory.setPosUserCode(currentUser.getCode());
            actionHistory.setPosUserId(currentUser.getId());
        }
        if (actionEntity != null) {
            actionHistory.setActionEntityCode(actionEntity.getCode());
            actionHistory.setActionEntityId(actionEntity.getId());
            actionHistory.setActionEntityType(actionEntity.getClass().getSimpleName());
        }
        actionHistory.setCode(new SimpleDateFormat("yyyyMMddHHmmSSS").format(actionHistory.getActionDate()) + actionType.name());
        actionHistory.getId();
        return actionHistory;
    }

    public void setActionDate(Date actionDate) {
        this.actionDate = actionDate;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public void setActionTypeDescription(String actionTypeDescription) {
        this.actionTypeDescription = actionTypeDescription;
    }

    public void setMoreInfo(String moreInfo) {
        this.moreInfo = moreInfo;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("posUserCode", "actionType", "actionEntityType", "actionEntityCode", "actionDate", "moreInfo", "actionTypeDescription");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public void initializeLists() {
    }

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.add("actionEntityType");
        list.add("actionEntityCode");
        return list;
    }

    @Override
    public String orderByCol() {
        return "actionDate";
    }
}

