/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import java.util.UUID;

@Entity
public class POSAlias
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    private String entityType;
    @Column(length=16)
    private UUID entityId;
    private String entityCode;

    public POSAlias() {
    }

    public POSAlias(MasterFileDTO entity, String alias) {
        this.assignIds();
        this.setEntityType(entity.getEntityType());
        this.setEntityId(UUID.fromString(entity.getId()));
        this.setEntityCode(alias);
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }
}

