/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.constants.AttachmentType;
import com.namasoft.contracts.basic.dtos.DTOBranch;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import com.namasoft.contracts.common.dtos.requests.ReadAttachmentRequest;
import com.namasoft.contracts.common.dtos.results.ReadAttachmentResult;
import com.namasoft.contracts.common.services.CoreWS;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.IPOSHasContactInfo;
import com.namasoft.pos.domain.entities.IPOSHasLogo;
import com.namasoft.pos.domain.entities.POSHasUpdateDataWithSession;
import com.namasoft.pos.domain.entities.POSLegalEntity;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.valueobjects.POSContactInfo;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;

@Entity
public class POSBranch
extends POSMasterFile<DTOBranch>
implements IPOSHasContactInfo,
IPOSHasLogo,
POSHasUpdateDataWithSession<DTOBranch> {
    @Embedded
    private POSContactInfo contactInfo;
    @Lob
    private Blob logo;
    private transient ByteArrayInputStream logoStream;
    private String taxFileID;

    @Override
    public POSContactInfo getContactInfo() {
        return this.contactInfo;
    }

    @Override
    public void setContactInfo(POSContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    @Override
    public String calcNamaEntityType() {
        return "Branch";
    }

    @Override
    public void updateData(DTOBranch object, Session session) {
        super.updateData(object);
        POSLegalEntity.updateContactInfo(this, object.getDimensionInfo());
        this.setTaxFileID(object.getTaxFileID());
        DTOLargeData logo = object.getBackgroundImage();
        if (logo == null) {
            this.setLogo(null);
        } else {
            ReadAttachmentRequest attachmentRequest = new ReadAttachmentRequest();
            attachmentRequest.setOwnerEntityType("Branch");
            attachmentRequest.setFileId(logo.getAttachmentInfo().getFileId());
            attachmentRequest.setAttachmentType(AttachmentType.ORIGINAL);
            CoreWS corews = (CoreWS)ServiceUtility.getServiceClient(CoreWS.class);
            ReadAttachmentResult readAttachmentResponse = corews.readAttachment(attachmentRequest);
            this.setLogo(POSReportDefinition.createBlobFromDataHanler(readAttachmentResponse.getData(), (int)logo.getDataLength(), session));
        }
    }

    @Override
    public void initializeLists() {
        if (this.getLogo() != null) {
            try {
                this.logoStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)this.getLogo().getBinaryStream()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Blob getLogo() {
        return this.logo;
    }

    public void setLogo(Blob logo) {
        this.logo = logo;
    }

    @Override
    public InputStream fetchLogoStream() {
        return this.logoStream;
    }

    public String getTaxFileID() {
        return this.taxFileID;
    }

    public void setTaxFileID(String taxFileID) {
        this.taxFileID = taxFileID;
    }
}

