/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.DTOMoney;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSCreditNoteLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSCreditNote;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.IPOSWritableFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSCreditNoteLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@Entity
public class POSCreditNote
extends POSMasterFile<DTONamaPOSCreditNote>
implements IPOSWritableFile<DTONamaPOSCreditNote> {
    @Column(precision=20, scale=10)
    private BigDecimal amount;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency posCurrency;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="note")
    @OrderColumn(name="lineNumber")
    private List<POSCreditNoteLine> details;
    private Boolean sent = false;
    private Boolean deactivated = false;
    private UUID returnId;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCustomer customer;
    private String shiftCode;

    public POSCreditNote() {
    }

    public POSCreditNote(String code, String name1, String name2, BigDecimal amount, POSCurrency posCurrency) {
        super(code, name1, name2);
        this.setAmount(amount);
        this.setPosCurrency(posCurrency);
    }

    @Override
    public void updateData(DTONamaPOSCreditNote dtoNote) {
        super.updateData(dtoNote);
        this.setCustomer((POSCustomer)this.fromReference(dtoNote.getCustomer()));
        this.setAmount(dtoNote.getMoney().getAmount());
        this.setPosCurrency((POSCurrency)this.fromReference(dtoNote.getMoney().getCurrency()));
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<POSCreditNoteLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)dtoNote.getDetails(), this.getDetails(), POSCreditNoteLine::new);
        for (int i = 0; i < dtoNote.getDetails().size(); ++i) {
            DTONamaPOSCreditNoteLine dtoLine = (DTONamaPOSCreditNoteLine)dtoNote.getDetails().get(i);
            POSCreditNoteLine line = this.getDetails().get(i);
            line.setNote(this);
            line.setInvoiceCode(dtoLine.getInvoiceCode());
            line.setValue(dtoLine.getAmount());
            line.setRegisterCode(dtoLine.getRegisterCode());
        }
        this.setSent(true);
    }

    @Override
    public void assignIds() {
        this.getId();
        for (POSCreditNoteLine list : this.getDetails()) {
            list.getId();
        }
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSCreditNote";
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public POSCurrency getPosCurrency() {
        this.posCurrency = POSPersister.materialize(POSCurrency.class, this.posCurrency);
        return this.posCurrency;
    }

    public void setPosCurrency(POSCurrency posCurrency) {
        this.posCurrency = posCurrency;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    public List<POSCreditNoteLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSCreditNoteLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSCreditNoteLine> details) {
        this.details = details;
    }

    public Boolean getSent() {
        return this.sent;
    }

    @Override
    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    @Transient
    public POSSalesReturn getSalesReturn() {
        return POSPersister.findByID(POSSalesReturn.class, this.returnId);
    }

    @Transient
    public void setSalesReturn(POSSalesReturn salesReturn) {
    }

    @Transient
    public BigDecimal getRemaining() {
        POSCreditNote creditNote = POSPersister.findByID(POSCreditNote.class, this.getId());
        return this.calcUnPaidAmount(creditNote.getDetails());
    }

    @Transient
    public void setRemaining(BigDecimal unPaidAmount) {
    }

    public BigDecimal calcUnPaidAmount() {
        return this.calcUnPaidAmount(this.getDetails());
    }

    public BigDecimal calcUnPaidAmount(List<POSCreditNoteLine> lines) {
        BigDecimal amount = this.getAmount();
        if (ObjectChecker.isNotEmptyOrNull(lines)) {
            for (POSCreditNoteLine line : lines) {
                amount = amount.subtract(line.getValue());
            }
        }
        return amount;
    }

    public Boolean getDeactivated() {
        return this.deactivated;
    }

    public void setDeactivated(Boolean deactivated) {
        this.deactivated = deactivated;
    }

    @Override
    public POSCustomer getCustomer() {
        this.customer = POSPersister.materialize(POSCustomer.class, this.customer);
        return this.customer;
    }

    public void setCustomer(POSCustomer customer) {
        this.customer = customer;
    }

    public UUID getReturnId() {
        return this.returnId;
    }

    public void setReturnId(UUID returnId) {
        this.returnId = returnId;
    }

    public String getShiftCode() {
        return this.shiftCode;
    }

    public void setShiftCode(String shiftCode) {
        this.shiftCode = shiftCode;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<POSTableColumn> columns = super.createColumnList(creatorUtil);
        List<String> fields = Arrays.asList("customer", "amount", "returnId");
        columns.addAll(creatorUtil.createColumns(fields));
        return columns;
    }

    @Override
    public List<POSTableColumn> createCalculatedColumnList(TableCellCreatorUtil creatorUtil) {
        List<POSTableColumn> calculatedColumnList = super.createCalculatedColumnList(creatorUtil);
        List<String> fields = Arrays.asList("salesReturn", "remaining");
        calculatedColumnList.addAll(creatorUtil.createColumns(fields));
        return calculatedColumnList;
    }

    @Override
    public DTONamaPOSCreditNote toDTO() {
        DTONamaPOSCreditNote dtoNamaPOSCreditNote = new DTONamaPOSCreditNote();
        dtoNamaPOSCreditNote.setCode(this.getCode());
        dtoNamaPOSCreditNote.setName1(this.getName1());
        dtoNamaPOSCreditNote.setName2(this.getName2());
        dtoNamaPOSCreditNote.setMoney(new DTOMoney());
        dtoNamaPOSCreditNote.getMoney().setAmount(this.getAmount());
        dtoNamaPOSCreditNote.setRegisterId(ServerStringUtils.toUUIDStr((Object)POSResourcesUtil.fetchMainRegister().getId()));
        POSCurrency posCurrency = this.getPosCurrency();
        dtoNamaPOSCreditNote.getMoney().setCurrency(POSMasterFile.toRef(posCurrency));
        dtoNamaPOSCreditNote.setId(ServerStringUtils.toUUIDStr((Object)this.getId()));
        dtoNamaPOSCreditNote.setCustomer(POSMasterFile.toRef(this.getCustomer()));
        dtoNamaPOSCreditNote.setCreatedFrom(EntityReferenceData.id((String)"NamaPOSSalesReturn", (String)ServerStringUtils.toUUIDStr((Object)this.returnId)));
        dtoNamaPOSCreditNote.setDetails(CollectionsUtility.convert(this.getDetails(), object -> {
            DTONamaPOSCreditNoteLine noteLine = new DTONamaPOSCreditNoteLine();
            noteLine.setInvoiceCode(object.getInvoiceCode());
            noteLine.setAmount(object.getValue());
            noteLine.setRegisterCode(object.getRegisterCode());
            noteLine.setInvoiceId(ServerStringUtils.toUUIDStr((Object)object.getInvoiceId()));
            noteLine.setInvoiceEntityType(object.getInvoiceType());
            return noteLine;
        }));
        return dtoNamaPOSCreditNote;
    }
}

