/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.modules.basic.contracts.entities.DTOCurrency;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import jakarta.persistence.Entity;

@Entity
public class POSCurrency
extends POSMasterFile<DTOCurrency> {
    private String altCode;
    private String fractionName1;
    private String fractionName2;
    private Integer fractionDecimalPlaces;
    private Integer displayDecimalPlaces;
    private boolean defaultCurrency;

    public POSCurrency() {
    }

    public Integer getDisplayDecimalPlaces() {
        return this.displayDecimalPlaces;
    }

    public void setDisplayDecimalPlaces(Integer displayDecimalPlaces) {
        this.displayDecimalPlaces = displayDecimalPlaces;
    }

    public POSCurrency(String code, String name1, String name2) {
        super(code, name1, name2);
    }

    public String getAltCode() {
        return this.altCode;
    }

    public void setAltCode(String altCode) {
        this.altCode = altCode;
    }

    public String getFractionName1() {
        return this.fractionName1;
    }

    public void setFractionName1(String fractionName1) {
        this.fractionName1 = fractionName1;
    }

    public String getFractionName2() {
        return this.fractionName2;
    }

    public void setFractionName2(String fractionName2) {
        this.fractionName2 = fractionName2;
    }

    public Integer getFractionDecimalPlaces() {
        return this.fractionDecimalPlaces;
    }

    public void setFractionDecimalPlaces(Integer fractionDecimalPlaces) {
        this.fractionDecimalPlaces = fractionDecimalPlaces;
    }

    public boolean isDefaultCurrency() {
        return this.defaultCurrency;
    }

    public void setDefaultCurrency(boolean defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Override
    public void updateData(DTOCurrency dtoCurrency) {
        super.updateData(dtoCurrency);
        this.setDefaultCurrency(dtoCurrency.getDefaultCurrency());
        this.setFractionDecimalPlaces(dtoCurrency.getFractionDecimalPlaces());
        this.setDisplayDecimalPlaces(dtoCurrency.getDisplayDecimalPlaces());
        this.setFractionName1(dtoCurrency.getFractionName1());
        this.setFractionName2(dtoCurrency.getFractionName2());
        this.setAltCode(dtoCurrency.getActualCode());
        if (POSResourcesUtil.fetchMainRegister() != null) {
            POSResourcesUtil.fetchMainRegister().cacheRegisteryFields();
            if (!POSResourcesUtil.currencies.contains(this)) {
                this.setPreventUsage(true);
            }
        }
    }

    @Override
    public String calcNamaEntityType() {
        return "Currency";
    }
}

