/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.flatobjects.IHasPriceListDefaultPrice;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.contracts.common.dtos.DTOAddress;
import com.namasoft.contracts.common.dtos.DTOContactInfo;
import com.namasoft.contracts.common.dtos.DTONamaRewardInfo;
import com.namasoft.modules.commonbasic.contracts.entities.DTOCustomer;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOLegalDoc;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxInfo;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.WritalblePOSFile;
import com.namasoft.pos.domain.details.POSExtraCodeLine;
import com.namasoft.pos.domain.entities.POSCustomerCategory;
import com.namasoft.pos.domain.entities.POSCustomerClass;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSTaxPlan;
import com.namasoft.pos.domain.entities.PosAddressRegion;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSRewardPointsUtil;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.PosSalesUtil;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import java.util.List;

@Entity
public class POSCustomer
extends WritalblePOSFile<DTOCustomer>
implements IHasPriceListDefaultPrice {
    private String phoneNumber;
    private String address;
    private String countryCode;
    private String city;
    private String area;
    private String district;
    private String street;
    private String landPlotNumber;
    private String buildingNumber;
    private String postalCode;
    private String residency;
    private Boolean sent;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCustomerClass customerClass;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSTaxPlan taxPlan;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCustomerCategory customerCategory;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosAddressRegion addressRegion;
    private String taxRegNo;
    private String companyType;
    private String priceListDefaultPrice;

    public String getPriceListDefaultPrice() {
        return this.priceListDefaultPrice;
    }

    public void setPriceListDefaultPrice(String priceListDefaultPrice) {
        this.priceListDefaultPrice = priceListDefaultPrice;
    }

    public String getTaxRegNo() {
        return this.taxRegNo;
    }

    public void setTaxRegNo(String taxRegNo) {
        this.taxRegNo = taxRegNo;
    }

    public String getCompanyType() {
        return this.companyType;
    }

    public void setCompanyType(String legalEntityOfCompany) {
        this.companyType = legalEntityOfCompany;
    }

    public POSCustomerCategory getCustomerCategory() {
        this.customerCategory = POSPersister.materialize(POSCustomerCategory.class, this.customerCategory);
        return this.customerCategory;
    }

    public void setCustomerCategory(POSCustomerCategory customerCategory) {
        this.customerCategory = customerCategory;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getLandPlotNumber() {
        return this.landPlotNumber;
    }

    public void setLandPlotNumber(String landPlotNumber) {
        this.landPlotNumber = landPlotNumber;
    }

    public POSCustomer() {
    }

    public POSCustomer(String code, String name1, String name2, String phone, String address, String residency, String area) {
        super(code, name1, name2);
        this.setPhoneNumber(phone);
        this.setAddress(address);
        this.setArea(area);
        this.setResidency(residency);
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public PosAddressRegion getAddressRegion() {
        this.addressRegion = POSPersister.materialize(PosAddressRegion.class, this.addressRegion);
        return this.addressRegion;
    }

    public void setAddressRegion(PosAddressRegion addressRegion) {
        this.addressRegion = addressRegion;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Boolean getSent() {
        return this.sent;
    }

    @Override
    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    @Override
    public void updateData(DTOCustomer customer) {
        super.updateData(customer);
        if (customer.getContactInfo() == null) {
            customer.setContactInfo(new DTOContactInfo());
        }
        if (customer.getResidency() == null) {
            customer.setResidency(new DTOLegalDoc());
        }
        this.setPhoneNumber(customer.getContactInfo().getMobile());
        this.setAddress(customer.getContactInfo().getAddress().getAddress1());
        this.setCountryCode(customer.getContactInfo().getAddress().getCountryCode());
        this.setCity(customer.getContactInfo().getAddress().getCity());
        this.setArea(customer.getContactInfo().getAddress().getArea());
        this.setDistrict(customer.getContactInfo().getAddress().getDistrict());
        this.setStreet(customer.getContactInfo().getAddress().getStreet());
        this.setLandPlotNumber(customer.getContactInfo().getAddress().getLandPlotNumber());
        this.setBuildingNumber(customer.getContactInfo().getAddress().getBuildingNumber());
        this.setPostalCode(customer.getContactInfo().getAddress().getPostalCode());
        this.setCustomerClass((POSCustomerClass)this.fromReference(customer.getCustomerClass()));
        this.setTaxRegNo(customer.getTaxInfo() == null ? null : customer.getTaxInfo().getTaxRegNo());
        this.setCompanyType(customer.getTaxInfo() == null ? null : customer.getTaxInfo().getCompanyType());
        this.setResidency(customer.getResidency().getNumber());
        this.setTaxPlan((POSTaxPlan)this.fromReference(customer.getTaxPlan()));
        this.setCustomerCategory((POSCustomerCategory)this.fromReference(customer.getCustomerCategory()));
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{customer.getShippingAddress()})) {
            this.setAddressRegion((PosAddressRegion)this.fromReference(customer.getShippingAddress().getRegion()));
        }
        this.setPriceListDefaultPrice(customer.getPriceListDefaultPrice());
    }

    @Override
    public String calcNamaEntityType() {
        return "Customer";
    }

    public String getResidency() {
        return this.residency;
    }

    public void setResidency(String residency) {
        this.residency = residency;
    }

    public POSCustomerClass getCustomerClass() {
        this.customerClass = POSPersister.materialize(POSCustomerClass.class, this.customerClass);
        return this.customerClass;
    }

    public void setCustomerClass(POSCustomerClass customerClass) {
        this.customerClass = customerClass;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List fields = CollectionsUtility.asList((Object[])new String[]{"code", "name1", "name2", "phoneNumber", "creationDate"});
        if (ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddAddressInCustomerSearchBox())) {
            fields.add("address");
        }
        return creatorUtil.createColumns(fields);
    }

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.add("phoneNumber");
        return list;
    }

    public POSTaxPlan getTaxPlan() {
        this.taxPlan = POSPersister.materialize(POSTaxPlan.class, this.taxPlan);
        return this.taxPlan;
    }

    public void setTaxPlan(POSTaxPlan taxPlan) {
        this.taxPlan = taxPlan;
    }

    @Override
    public void initializeLists() {
        this.materialize(this.getCustomerCategory(), this.getCustomerClass(), this.getTaxPlan());
    }

    @Override
    public boolean canSearchOn() {
        return POSSecurityUtil.userCan(POSSecurityCapability.CanSearchOnCustomers).isSucceeded();
    }

    @Override
    public String filteringCondition(String fieldId, String operator) {
        return POSCustomer.filteringCondition(fieldId, operator, fieldId);
    }

    public static String filteringCondition(String alias, String operator, String value) {
        String navigator = ObjectChecker.isEmptyOrNull((Object)alias) ? "" : ".";
        StringBuilder filter = new StringBuilder(" ( " + alias + navigator + "code" + operator + " :" + value + " or " + alias + navigator + "name1" + operator + " :" + value + " or " + alias + navigator + "name2" + operator + " :" + value + " or " + alias + navigator + "phoneNumber" + operator + " :" + value);
        for (POSExtraCodeLine extraCode : PosSalesUtil.getExtraCodes()) {
            if (ObjectChecker.isEmptyOrNull((Object)extraCode.getFieldID()) || extraCode.getFieldID().contains("contactInfo.")) continue;
            String fieldId = extraCode.getFieldID().toLowerCase().startsWith("customer.") ? extraCode.getFieldID().substring("customer.".length()) : extraCode.getFieldID();
            filter.append(" or ").append(alias).append(navigator).append(fieldId).append(operator).append(" :").append(value);
        }
        filter.append(" )");
        return filter.toString();
    }

    @Override
    public boolean sendAllInfoToMobile() {
        return true;
    }

    public DTONamaRewardInfo fetchRemainingRewardPointsInfo(POSResult result) {
        return POSRewardPointsUtil.calculateRemainingRewardInfo(this, result);
    }

    @Override
    public DTOCustomer toDTO() {
        DTOCustomer dtoCustomer = new DTOCustomer();
        dtoCustomer.setCode(this.getCode());
        dtoCustomer.setName1(this.getName1());
        dtoCustomer.setName2(this.getName2());
        dtoCustomer.setId(this.getId().toString());
        DTOContactInfo contactInfo = new DTOContactInfo();
        contactInfo.setMobile(this.getPhoneNumber());
        contactInfo.setTelephone1(this.getPhoneNumber());
        DTOAddress address = new DTOAddress();
        address.setCountryCode(this.getCountryCode());
        address.setCity(this.getCity());
        address.setDistrict(this.getDistrict());
        address.setStreet(this.getStreet());
        address.setLandPlotNumber(this.getLandPlotNumber());
        address.setBuildingNumber(this.getBuildingNumber());
        address.setPostalCode(this.getPostalCode());
        address.setArea(this.getArea());
        address.setAddress1(this.getAddress());
        contactInfo.setAddress(address);
        dtoCustomer.setContactInfo(contactInfo);
        DTOTaxInfo taxInfo = new DTOTaxInfo();
        taxInfo.setTaxRegNo(this.getTaxRegNo());
        taxInfo.setCompanyType(this.getCompanyType());
        dtoCustomer.setTaxInfo(taxInfo);
        DTOLegalDoc residency = new DTOLegalDoc();
        residency.setNumber(this.getResidency());
        dtoCustomer.setResidency(residency);
        dtoCustomer.setFirstAuthor(POSMasterFile.toRef(POSSettingsInfo.fetchConfiguration().getCurrentUser()));
        dtoCustomer.setCustomerClass(POSMasterFile.toRef(this.getCustomerClass()));
        dtoCustomer.setCustomerCategory(POSMasterFile.toRef(this.getCustomerCategory()));
        if (ObjectChecker.isTrue_b((Boolean)POSResourcesUtil.fetchPOSConfig().getAddPreventUsageFieldInPOSCustomer())) {
            dtoCustomer.setPreventUsage(this.getPreventUsage());
        }
        this.copyCommonToDTO((BaseEntityDTO)dtoCustomer);
        return dtoCustomer;
    }
}

