/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSDepreciationReasonDiscLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSDepreciationReason;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSDepreciationReasonDiscLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Entity
public class POSDepreciationReason
extends POSMasterFile<DTONamaPOSDepreciationReason> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="depreciationReason")
    @OrderColumn(name="lineNumber")
    private List<POSDepreciationReasonDiscLine> discounts;

    @Override
    public void updateData(DTONamaPOSDepreciationReason object) {
        super.updateData(object);
        CollectionsUtility.makeSecondSameSize((List)object.getDiscountLines(), this.getDiscounts(), POSDepreciationReasonDiscLine::new);
        for (int i = 0; i < object.getDiscountLines().size(); ++i) {
            POSDepreciationReasonDiscLine discLine = this.getDiscounts().get(i);
            discLine.assignIds();
            discLine.setDiscount(((DTONamaPOSDepreciationReasonDiscLine)object.getDiscountLines().get(i)).getDiscount());
            discLine.setPercentage(((DTONamaPOSDepreciationReasonDiscLine)object.getDiscountLines().get(i)).getPercentage());
            discLine.setDepreciationReason(this);
        }
        POSResourcesUtil.clearDepreciationReasons();
    }

    @Override
    public void initializeLists() {
        this.getDiscounts().size();
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSDepreciationReason";
    }

    public List<POSDepreciationReasonDiscLine> getDiscounts() {
        if (this.discounts == null) {
            this.discounts = new ArrayList<POSDepreciationReasonDiscLine>();
        }
        return this.discounts;
    }

    public void setDiscounts(List<POSDepreciationReasonDiscLine> discounts) {
        this.discounts = discounts;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }
}

