/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.DTOMoney;
import com.namasoft.modules.basic.contracts.details.DTODiscountCouponLine;
import com.namasoft.modules.basic.contracts.entities.DTODiscountCoupon;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.IPOSWritableFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSDiscountCouponLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSDiscountCoupon
extends POSMasterFile<DTODiscountCoupon>
implements IPOSWritableFile<DTODiscountCoupon> {
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCustomer customer;
    @Column(precision=20, scale=10)
    private BigDecimal couponValue;
    private Date fromDate;
    private Date toDate;
    private Boolean usedOnce;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="coupon")
    @OrderColumn(name="lineNumber")
    private List<POSDiscountCouponLine> details;
    private UUID fromInvoiceId;
    private UUID fromRecId;
    private Boolean sent = false;

    public POSDiscountCoupon(String code, String name1, String name2) {
        this.setCode(code);
        this.setName2(name2);
        this.setName1(name1);
    }

    public POSDiscountCoupon() {
    }

    public UUID getFromInvoiceId() {
        return this.fromInvoiceId;
    }

    public void setFromInvoiceId(UUID fromInvoiceId) {
        this.fromInvoiceId = fromInvoiceId;
    }

    public UUID getFromRecId() {
        return this.fromRecId;
    }

    public void setFromRecId(UUID fromRecId) {
        this.fromRecId = fromRecId;
    }

    @Override
    public POSCustomer getCustomer() {
        this.customer = POSPersister.materialize(POSCustomer.class, this.customer);
        return this.customer;
    }

    public void setCustomer(POSCustomer customer) {
        this.customer = customer;
    }

    public BigDecimal getCouponValue() {
        return this.couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Boolean getUsedOnce() {
        return this.usedOnce;
    }

    public void setUsedOnce(Boolean usedOnce) {
        this.usedOnce = usedOnce;
    }

    public List<POSDiscountCouponLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSDiscountCouponLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSDiscountCouponLine> details) {
        this.details = details;
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    public String calcNamaEntityType() {
        return "DiscountCoupon";
    }

    @Override
    public void assignIds() {
        super.assignIds();
        for (POSDiscountCouponLine line : this.getDetails()) {
            line.getId();
            line.setCoupon(this);
        }
    }

    @Override
    public void updateData(DTODiscountCoupon coupon) {
        super.updateData(coupon);
        if (ObjectChecker.isNotEmptyOrNull((Object)coupon.getTarget()) && ObjectChecker.areEqual((Object)coupon.getTarget().getEntityType(), (Object)"Customer")) {
            this.setCustomer((POSCustomer)this.fromReference(coupon.getTarget()));
        }
        this.setUsedOnce(coupon.getUsedOnce());
        this.setFromDate(coupon.getFromDate());
        this.setToDate(coupon.getToDate());
        this.setCouponValue(coupon.getCouponValue().getAmount());
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<POSDiscountCouponLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)coupon.getDetails(), this.getDetails(), POSDiscountCouponLine::new);
        for (int i = 0; i < coupon.getDetails().size(); ++i) {
            DTODiscountCouponLine dtoLine = (DTODiscountCouponLine)coupon.getDetails().get(i);
            POSDiscountCouponLine line = this.getDetails().get(i);
            line.setCoupon(this);
            line.setInvCode(dtoLine.getInvoiceCode());
            line.setValue(dtoLine.getValue());
            line.setRegisterCode(dtoLine.getRegisterCode());
        }
        this.setSent(true);
    }

    public Boolean getSent() {
        return this.sent;
    }

    @Override
    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    @Override
    public DTODiscountCoupon toDTO() {
        DTODiscountCoupon dtoCoupon = new DTODiscountCoupon();
        dtoCoupon.setCode(this.getCode());
        dtoCoupon.setName1(this.getName1());
        dtoCoupon.setName2(this.getName2());
        dtoCoupon.setCouponValue(new DTOMoney());
        dtoCoupon.setFromDate(this.getFromDate());
        dtoCoupon.setToDate(this.getToDate());
        dtoCoupon.setUsedOnce(this.getUsedOnce());
        dtoCoupon.setTarget(POSMasterFile.toRef(this.getCustomer()));
        dtoCoupon.getCouponValue().setAmount(this.getCouponValue());
        dtoCoupon.setRegisterId(ServerStringUtils.toUUIDStr((Object)POSResourcesUtil.fetchMainRegister().getId()));
        dtoCoupon.getCouponValue().setCurrency(POSMasterFile.toRef(POSPersister.findByID(POSCurrency.class, POSResourcesUtil.fetchMainRegister().getCurrencyId())));
        dtoCoupon.setId(ServerStringUtils.toUUIDStr((Object)this.getId()));
        String fromDocEntityType = "NamaPOSSalesInvoice";
        UUID fromDocId = this.getFromInvoiceId();
        if (ObjectChecker.isEmptyOrNull((Object)fromDocId)) {
            fromDocEntityType = "POSReceiptFromRegister";
            fromDocId = this.getFromRecId();
        }
        dtoCoupon.setGenFrom(POSMasterFile.toRef(fromDocEntityType, fromDocId));
        dtoCoupon.setDetails(CollectionsUtility.convert(this.getDetails(), object -> {
            DTODiscountCouponLine line = new DTODiscountCouponLine();
            line.setInvoiceCode(object.getInvCode());
            line.setValue(object.getValue());
            line.setRegisterCode(object.getRegisterCode());
            line.setInvoiceId(ServerStringUtils.toUUIDStr((Object)object.getInvoiceId()));
            return line;
        }));
        dtoCoupon.setLegalEntity(POSMasterFile.toRef("LegalEntity", this.getGenericDims().getLegalEntity().getId()));
        dtoCoupon.setSector(POSMasterFile.toRef("Sector", this.getGenericDims().getSector().getId()));
        dtoCoupon.setBranch(POSMasterFile.toRef("Branch", this.getGenericDims().getBranch().getId()));
        dtoCoupon.setDepartment(POSMasterFile.toRef("Department", this.getGenericDims().getDepartment().getId()));
        dtoCoupon.setAnalysisSet(POSMasterFile.toRef("AnalysisSet", this.getGenericDims().getAnalysisSet().getId()));
        return dtoCoupon;
    }
}

