/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.infra.contractsbase.modules.hr.DTOEmployee;
import com.namasoft.pos.domain.POSMasterFile;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
public class POSEmployee
extends POSMasterFile<DTOEmployee> {
    private Boolean salesMan;
    @Column(precision=20, scale=10)
    private BigDecimal maxHeaderDiscPercentage;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc1Percentage;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc2Percentage;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc3Percentage;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc4Percentage;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc5Percentage;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc6Percentage;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc7Percentage;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc8Percentage;
    @Column(precision=20, scale=10)
    private BigDecimal maxHeaderDiscValue;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc1Value;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc2Value;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc3Value;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc4Value;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc5Value;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc6Value;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc7Value;
    @Column(precision=20, scale=10)
    private BigDecimal maxDisc8Value;
    @Column(length=16)
    private UUID jobPositionId;
    @Column(length=16)
    private UUID departmentSectionId;
    @Column(length=16)
    private UUID organizationPositionId;
    @Column(length=16)
    private UUID employeeDepartmentId;

    public POSEmployee() {
    }

    public POSEmployee(String code, String name1, String name2) {
        super(code, name1, name2);
    }

    public UUID getJobPositionId() {
        return this.jobPositionId;
    }

    public void setJobPositionId(UUID jobPositionId) {
        this.jobPositionId = jobPositionId;
    }

    public UUID getDepartmentSectionId() {
        return this.departmentSectionId;
    }

    public void setDepartmentSectionId(UUID departmentSectionId) {
        this.departmentSectionId = departmentSectionId;
    }

    public UUID getOrganizationPositionId() {
        return this.organizationPositionId;
    }

    public void setOrganizationPositionId(UUID organizationPositionId) {
        this.organizationPositionId = organizationPositionId;
    }

    public UUID getEmployeeDepartmentId() {
        return this.employeeDepartmentId;
    }

    public void setEmployeeDepartmentId(UUID employeeDepartmentId) {
        this.employeeDepartmentId = employeeDepartmentId;
    }

    @Override
    public void updateData(DTOEmployee object) {
        this.setSalesMan(object.getSalesMan());
        this.setMaxHeaderDiscPercentage(object.getMaxHeaderDiscPercentage());
        this.setMaxDisc1Percentage(object.getMaxDisc1Percentage());
        this.setMaxDisc2Percentage(object.getMaxDisc2Percentage());
        this.setMaxDisc3Percentage(object.getMaxDisc3Percentage());
        this.setMaxDisc4Percentage(object.getMaxDisc4Percentage());
        this.setMaxDisc5Percentage(object.getMaxDisc5Percentage());
        this.setMaxDisc6Percentage(object.getMaxDisc6Percentage());
        this.setMaxDisc7Percentage(object.getMaxDisc7Percentage());
        this.setMaxDisc8Percentage(object.getMaxDisc8Percentage());
        this.setMaxHeaderDiscValue(object.getMaxHeaderDiscValue());
        this.setMaxDisc1Value(object.getMaxDisc1Value());
        this.setMaxDisc2Value(object.getMaxDisc2Value());
        this.setMaxDisc3Value(object.getMaxDisc3Value());
        this.setMaxDisc4Value(object.getMaxDisc4Value());
        this.setMaxDisc5Value(object.getMaxDisc5Value());
        this.setMaxDisc6Value(object.getMaxDisc6Value());
        this.setMaxDisc7Value(object.getMaxDisc7Value());
        this.setMaxDisc8Value(object.getMaxDisc8Value());
        if (ObjectChecker.isNotEmptyOrNull((Object)object.getOrganizationPosition())) {
            this.setOrganizationPositionId(UUID.fromString(object.getOrganizationPosition().getId()));
        } else {
            this.setOrganizationPositionId(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)object.getDepartmentSection())) {
            this.setDepartmentSectionId(UUID.fromString(object.getDepartmentSection().getId()));
        } else {
            this.setDepartmentSectionId(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)object.getEmployeeDepartment())) {
            this.setEmployeeDepartmentId(UUID.fromString(object.getEmployeeDepartment().getId()));
        } else {
            this.setEmployeeDepartmentId(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)object.getJobPosition())) {
            this.setJobPositionId(UUID.fromString(object.getJobPosition().getId()));
        } else {
            this.setJobPositionId(null);
        }
        super.updateData(object);
    }

    public BigDecimal getMaxDisc3Percentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc3Percentage)) {
            return BigDecimal.valueOf(100L);
        }
        return this.maxDisc3Percentage;
    }

    public void setMaxDisc3Percentage(BigDecimal maxDisc3Percentage) {
        this.maxDisc3Percentage = maxDisc3Percentage;
    }

    public BigDecimal getMaxDisc4Percentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc4Percentage)) {
            return BigDecimal.valueOf(100L);
        }
        return this.maxDisc4Percentage;
    }

    public void setMaxDisc4Percentage(BigDecimal maxDisc4Percentage) {
        this.maxDisc4Percentage = maxDisc4Percentage;
    }

    public BigDecimal getMaxDisc5Percentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc5Percentage)) {
            return BigDecimal.valueOf(100L);
        }
        return this.maxDisc5Percentage;
    }

    public void setMaxDisc5Percentage(BigDecimal maxDisc5Percentage) {
        this.maxDisc5Percentage = maxDisc5Percentage;
    }

    public BigDecimal getMaxDisc6Percentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc6Percentage)) {
            return BigDecimal.valueOf(100L);
        }
        return this.maxDisc6Percentage;
    }

    public void setMaxDisc6Percentage(BigDecimal maxDisc6Percentage) {
        this.maxDisc6Percentage = maxDisc6Percentage;
    }

    public BigDecimal getMaxDisc7Percentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc7Percentage)) {
            return BigDecimal.valueOf(100L);
        }
        return this.maxDisc7Percentage;
    }

    public void setMaxDisc7Percentage(BigDecimal maxDisc7Percentage) {
        this.maxDisc7Percentage = maxDisc7Percentage;
    }

    public BigDecimal getMaxDisc8Percentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc8Percentage)) {
            return BigDecimal.valueOf(100L);
        }
        return this.maxDisc8Percentage;
    }

    public void setMaxDisc8Percentage(BigDecimal maxDisc8Percentage) {
        this.maxDisc8Percentage = maxDisc8Percentage;
    }

    public Boolean getSalesMan() {
        if (ObjectChecker.isEmptyOrNull((Object)this.salesMan)) {
            return false;
        }
        return this.salesMan;
    }

    public void setSalesMan(Boolean salesMan) {
        this.salesMan = salesMan;
    }

    @Override
    public String calcNamaEntityType() {
        return "Employee";
    }

    public BigDecimal getMaxHeaderDiscPercentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxHeaderDiscPercentage)) {
            return BigDecimal.valueOf(100L);
        }
        return this.maxHeaderDiscPercentage;
    }

    public void setMaxHeaderDiscPercentage(BigDecimal maxHeaderDiscPercentage) {
        this.maxHeaderDiscPercentage = maxHeaderDiscPercentage;
    }

    public BigDecimal getMaxDisc1Percentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc1Percentage)) {
            return BigDecimal.valueOf(100L);
        }
        return this.maxDisc1Percentage;
    }

    public void setMaxDisc1Percentage(BigDecimal maxDisc1Percentage) {
        this.maxDisc1Percentage = maxDisc1Percentage;
    }

    public BigDecimal getMaxDisc2Percentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc2Percentage)) {
            return BigDecimal.valueOf(100L);
        }
        return this.maxDisc2Percentage;
    }

    public void setMaxDisc2Percentage(BigDecimal maxDisc2Percentage) {
        this.maxDisc2Percentage = maxDisc2Percentage;
    }

    public BigDecimal getMaxHeaderDiscValue() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxHeaderDiscValue)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        return this.maxHeaderDiscValue;
    }

    public void setMaxHeaderDiscValue(BigDecimal maxHeaderDiscValue) {
        this.maxHeaderDiscValue = maxHeaderDiscValue;
    }

    public BigDecimal getMaxDisc1Value() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc1Value)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        return this.maxDisc1Value;
    }

    public void setMaxDisc1Value(BigDecimal maxDisc1Value) {
        this.maxDisc1Value = maxDisc1Value;
    }

    public BigDecimal getMaxDisc2Value() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc2Value)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        return this.maxDisc2Value;
    }

    public void setMaxDisc2Value(BigDecimal maxDisc2Value) {
        this.maxDisc2Value = maxDisc2Value;
    }

    public BigDecimal getMaxDisc3Value() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc3Value)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        return this.maxDisc3Value;
    }

    public void setMaxDisc3Value(BigDecimal maxDisc3Value) {
        this.maxDisc3Value = maxDisc3Value;
    }

    public BigDecimal getMaxDisc4Value() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc4Value)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        return this.maxDisc4Value;
    }

    public void setMaxDisc4Value(BigDecimal maxDisc4Value) {
        this.maxDisc4Value = maxDisc4Value;
    }

    public BigDecimal getMaxDisc5Value() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc5Value)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        return this.maxDisc5Value;
    }

    public void setMaxDisc5Value(BigDecimal maxDisc5Value) {
        this.maxDisc5Value = maxDisc5Value;
    }

    public BigDecimal getMaxDisc6Value() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc6Value)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        return this.maxDisc6Value;
    }

    public void setMaxDisc6Value(BigDecimal maxDisc6Value) {
        this.maxDisc6Value = maxDisc6Value;
    }

    public BigDecimal getMaxDisc7Value() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc7Value)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        return this.maxDisc7Value;
    }

    public void setMaxDisc7Value(BigDecimal maxDisc7Value) {
        this.maxDisc7Value = maxDisc7Value;
    }

    public BigDecimal getMaxDisc8Value() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.maxDisc8Value)) {
            return BigDecimal.valueOf(Integer.MAX_VALUE);
        }
        return this.maxDisc8Value;
    }

    public void setMaxDisc8Value(BigDecimal maxDisc8Value) {
        this.maxDisc8Value = maxDisc8Value;
    }
}

