/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.constants.DateWrapper;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.basic.contracts.details.DTOExchangeRateLine;
import com.namasoft.modules.basic.contracts.entities.DTOExchangeRate;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSExchangeRateLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSExchangeRate
extends POSMasterFile<DTOExchangeRate> {
    private String type;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency mainCurrency;
    @Temporal(value=TemporalType.DATE)
    private Date date;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="exchangeRate")
    @OrderColumn(name="lineNumber")
    private List<POSExchangeRateLine> details;
    @Column(length=16)
    private UUID ledgerId;
    @Temporal(value=TemporalType.DATE)
    private Date startDate;
    @Temporal(value=TemporalType.DATE)
    private Date endDate;

    @Override
    public void updateData(DTOExchangeRate object) {
        super.updateData(object);
        this.setType(object.getType());
        this.setMainCurrency((POSCurrency)this.fromReference(object.getMainCurrency()));
        this.setDate(object.getDate());
        if (object.getLedger() != null) {
            this.setLedgerId(ServerStringUtils.strToUUID((String)object.getLedger().getId()));
        }
        Date startDate = object.getDate();
        Date endDate = object.getDate();
        if (ObjectChecker.isNotEmptyOrNull((Object)object.getFiscalPeriod())) {
            startDate = ((DateWrapper)object.getFiscalPeriod().get("startDate")).toDate();
            endDate = ((DateWrapper)object.getFiscalPeriod().get("endDate")).toDate();
        } else if (ObjectChecker.isNotEmptyOrNull((Object)object.getFiscalYear())) {
            startDate = ((DateWrapper)object.getFiscalYear().get("startDate")).toDate();
            endDate = ((DateWrapper)object.getFiscalYear().get("endDate")).toDate();
        }
        this.setStartDate(startDate);
        this.setEndDate(endDate);
        CollectionsUtility.makeSecondSameSize((List)object.getLines(), this.getDetails(), POSExchangeRateLine::new);
        for (int i = 0; i < object.getLines().size(); ++i) {
            DTOExchangeRateLine dtoLine = (DTOExchangeRateLine)object.getLines().get(i);
            POSExchangeRateLine line = this.getDetails().get(i);
            line.setExchangeRate(this);
            line.setBuy(dtoLine.getBuy());
            line.setCurrency((POSCurrency)this.fromReference(dtoLine.getCurrency()));
            line.setDate(dtoLine.getDate());
            line.setMainCurrency((POSCurrency)this.fromReference(dtoLine.getMainCurrency()));
            line.setType(dtoLine.getType());
            line.setSell(dtoLine.getSell());
            line.setRemarks(dtoLine.getRemarks());
            line.setLedgerId(this.getLedgerId());
            line.setStartDate(this.getStartDate());
            line.setEndDate(this.getEndDate());
        }
    }

    @Override
    public void assignIds() {
        this.getId();
        for (POSExchangeRateLine list : this.getDetails()) {
            list.getId();
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public POSCurrency getMainCurrency() {
        this.mainCurrency = POSPersister.materialize(POSCurrency.class, this.mainCurrency);
        return this.mainCurrency;
    }

    public void setMainCurrency(POSCurrency mainCurrency) {
        this.mainCurrency = mainCurrency;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public List<POSExchangeRateLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSExchangeRateLine>();
            return this.details;
        }
        return this.details;
    }

    public void setDetails(List<POSExchangeRateLine> details) {
        this.details = details;
    }

    public UUID getLedgerId() {
        return this.ledgerId;
    }

    public void setLedgerId(UUID ledgerId) {
        this.ledgerId = ledgerId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public String calcNamaEntityType() {
        return "ExchangeRate";
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }
}

