/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.modules.supplychain.contracts.details.DTOCustomerItemCode;
import com.namasoft.modules.supplychain.contracts.details.DTOItemDimensionsDetail;
import com.namasoft.modules.supplychain.contracts.details.DTOItemRevision;
import com.namasoft.modules.supplychain.contracts.details.DTOItemUOMLine;
import com.namasoft.modules.supplychain.contracts.details.DTOManufacturerItemCode;
import com.namasoft.modules.supplychain.contracts.details.DTOPrimaryItemUOMLine;
import com.namasoft.modules.supplychain.contracts.details.DTOSecondaryItemUOMLine;
import com.namasoft.modules.supplychain.contracts.details.DTOSizesAndColors;
import com.namasoft.modules.supplychain.contracts.entities.DTOInvItem;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOItemUOM;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSCustomerItemCode;
import com.namasoft.pos.domain.details.POSItemDimsDetail;
import com.namasoft.pos.domain.details.POSItemUnit;
import com.namasoft.pos.domain.details.POSManufacturerItemCode;
import com.namasoft.pos.domain.details.POSSizesAndColors;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSHasImage;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItemBrand;
import com.namasoft.pos.domain.entities.POSItemCategory;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass10;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemClass6;
import com.namasoft.pos.domain.entities.POSItemClass7;
import com.namasoft.pos.domain.entities.POSItemClass8;
import com.namasoft.pos.domain.entities.POSItemClass9;
import com.namasoft.pos.domain.entities.POSItemCode;
import com.namasoft.pos.domain.entities.POSItemCodeType;
import com.namasoft.pos.domain.entities.POSItemConfig;
import com.namasoft.pos.domain.entities.POSItemRevision;
import com.namasoft.pos.domain.entities.POSItemSection;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSTaxPlan;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.domain.entities.POSVendor;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceReq;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceRes;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceReqDetail;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceReqType;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSPricesCachingUtil;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.annotations.Index;

@Entity
public class POSItem
extends POSMasterFile<DTOInvItem>
implements POSHasImage {
    private String altCode;
    private boolean hasLot;
    private boolean hasSerial;
    private boolean hasSize;
    private boolean hasColor;
    private boolean hasRevisions;
    private boolean hasPackages;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_category1")
    private POSItemCategory category1;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_category2")
    private POSItemCategory category2;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_category3")
    private POSItemCategory category3;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_category4")
    private POSItemCategory category4;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_category5")
    private POSItemCategory category5;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_section")
    private POSItemSection section;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_brand")
    private POSItemBrand brand;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUnit baseUnit;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUnit defaultSalesUnit;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posItem")
    @OrderColumn(name="lineNumber")
    @JsonIgnore
    private List<POSSizesAndColors> sizesAndColors;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posItem")
    @OrderColumn(name="lineNumber")
    @JsonIgnore
    private List<POSCustomerItemCode> customerCodes;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posItem")
    @OrderColumn(name="lineNumber")
    @JsonIgnore
    private List<POSManufacturerItemCode> manfCodes;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posItem")
    @OrderColumn(name="lineNumber")
    @JsonIgnore
    private List<POSItemRevision> revisions;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posItem")
    @OrderColumn(name="lineNumber")
    @JsonIgnore
    private List<POSItemUnit> units;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSTaxPlan taxPlan;
    private Boolean returnable;
    private Boolean sellable;
    private Boolean replaceable;
    private String racksCodes;
    private Boolean hasImage;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemConfig itemConfig;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass1")
    private POSItemClass1 itemClass1;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass2")
    private POSItemClass2 itemClass2;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass3")
    private POSItemClass3 itemClass3;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass4")
    private POSItemClass4 itemClass4;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass5")
    private POSItemClass5 itemClass5;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass6")
    private POSItemClass6 itemClass6;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass7")
    private POSItemClass7 itemClass7;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass8")
    private POSItemClass8 itemClass8;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass9")
    private POSItemClass9 itemClass9;
    @ManyToOne(fetch=FetchType.LAZY)
    @Index(name="index_itemClass10")
    private POSItemClass10 itemClass10;
    private String itemType;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSVendor defaultSupplier;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posItem")
    @OrderColumn(name="lineNumber")
    @JsonIgnore
    private List<POSItemDimsDetail> details;
    private static Map<UUID, BigDecimal> cachedPrices = new ConcurrentHashMap<UUID, BigDecimal>();

    public static Map<String, String> fetchSizesAndColors(POSItem item, Boolean isSize) {
        return isSize != false ? POSItem.fetchSizes(item) : POSItem.fetchColors(item);
    }

    public List<POSItemDimsDetail> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSItemDimsDetail>();
        }
        return this.details;
    }

    public void setDetails(List<POSItemDimsDetail> details) {
        this.details = details;
    }

    public POSItemClass1 getItemClass1() {
        this.itemClass1 = POSPersister.materialize(POSItemClass1.class, this.itemClass1);
        return this.itemClass1;
    }

    public void setItemClass1(POSItemClass1 itemClass1) {
        this.itemClass1 = itemClass1;
    }

    public POSItemClass2 getItemClass2() {
        this.itemClass2 = POSPersister.materialize(POSItemClass2.class, this.itemClass2);
        return this.itemClass2;
    }

    public void setItemClass2(POSItemClass2 itemClass2) {
        this.itemClass2 = itemClass2;
    }

    public POSItemClass3 getItemClass3() {
        this.itemClass3 = POSPersister.materialize(POSItemClass3.class, this.itemClass3);
        return this.itemClass3;
    }

    public void setItemClass3(POSItemClass3 itemClass3) {
        this.itemClass3 = itemClass3;
    }

    public POSItemClass4 getItemClass4() {
        this.itemClass4 = POSPersister.materialize(POSItemClass4.class, this.itemClass4);
        return this.itemClass4;
    }

    public void setItemClass4(POSItemClass4 itemClass4) {
        this.itemClass4 = itemClass4;
    }

    public POSItemClass5 getItemClass5() {
        this.itemClass5 = POSPersister.materialize(POSItemClass5.class, this.itemClass5);
        return this.itemClass5;
    }

    public void setItemClass5(POSItemClass5 itemClass5) {
        this.itemClass5 = itemClass5;
    }

    public POSItemClass6 getItemClass6() {
        this.itemClass6 = POSPersister.materialize(POSItemClass6.class, this.itemClass6);
        return this.itemClass6;
    }

    public void setItemClass6(POSItemClass6 itemClass6) {
        this.itemClass6 = itemClass6;
    }

    public POSItemClass7 getItemClass7() {
        this.itemClass7 = POSPersister.materialize(POSItemClass7.class, this.itemClass7);
        return this.itemClass7;
    }

    public void setItemClass7(POSItemClass7 itemClass7) {
        this.itemClass7 = itemClass7;
    }

    public POSItemClass8 getItemClass8() {
        this.itemClass8 = POSPersister.materialize(POSItemClass8.class, this.itemClass8);
        return this.itemClass8;
    }

    public void setItemClass8(POSItemClass8 itemClass8) {
        this.itemClass8 = itemClass8;
    }

    public POSItemClass9 getItemClass9() {
        this.itemClass9 = POSPersister.materialize(POSItemClass9.class, this.itemClass9);
        return this.itemClass9;
    }

    public void setItemClass9(POSItemClass9 itemClass9) {
        this.itemClass9 = itemClass9;
    }

    public POSItemClass10 getItemClass10() {
        this.itemClass10 = POSPersister.materialize(POSItemClass10.class, this.itemClass10);
        return this.itemClass10;
    }

    public void setItemClass10(POSItemClass10 itemClass10) {
        this.itemClass10 = itemClass10;
    }

    public POSTaxPlan getTaxPlan() {
        this.taxPlan = POSPersister.materialize(POSTaxPlan.class, this.taxPlan);
        return this.taxPlan;
    }

    public UUID fetchTaxPlanId() {
        return this.fetchId(this.taxPlan);
    }

    private UUID fetchId(POSMasterFile masterFile) {
        if (masterFile == null) {
            return null;
        }
        return masterFile.getId();
    }

    public void setTaxPlan(POSTaxPlan taxPlan) {
        this.taxPlan = taxPlan;
    }

    public POSItemCategory getCategory1() {
        this.category1 = POSPersister.materialize(POSItemCategory.class, this.category1);
        return this.category1;
    }

    public POSItemCategory fetchCategory1Proxy() {
        return this.category1;
    }

    public void setCategory1(POSItemCategory category1) {
        this.category1 = category1;
    }

    public POSItemCategory getCategory2() {
        this.category2 = POSPersister.materialize(POSItemCategory.class, this.category2);
        return this.category2;
    }

    public POSItemCategory fetchCategory2Proxy() {
        return this.category2;
    }

    public void setCategory2(POSItemCategory category2) {
        this.category2 = category2;
    }

    public POSItemCategory getCategory3() {
        this.category3 = POSPersister.materialize(POSItemCategory.class, this.category3);
        return this.category3;
    }

    public POSItemCategory fetchCategory3Proxy() {
        return this.category3;
    }

    public void setCategory3(POSItemCategory category3) {
        this.category3 = category3;
    }

    public POSItemCategory getCategory4() {
        this.category4 = POSPersister.materialize(POSItemCategory.class, this.category4);
        return this.category4;
    }

    public POSItemCategory fetchCategory4Proxy() {
        return this.category4;
    }

    public void setCategory4(POSItemCategory category4) {
        this.category4 = category4;
    }

    public POSItemCategory getCategory5() {
        this.category5 = POSPersister.materialize(POSItemCategory.class, this.category5);
        return this.category5;
    }

    public POSItemCategory fetchCategory5Proxy() {
        return this.category5;
    }

    public void setCategory5(POSItemCategory category5) {
        this.category5 = category5;
    }

    public POSItemSection getSection() {
        this.section = POSPersister.materialize(POSItemSection.class, this.section);
        return this.section;
    }

    public POSItemSection fetchItemSectionProxy() {
        return this.section;
    }

    public void setSection(POSItemSection section) {
        this.section = section;
    }

    public POSItem() {
    }

    public POSItem(String code, String name1, String name2) {
        super(code, name1, name2);
    }

    public boolean isHasLot() {
        return this.hasLot;
    }

    public void setHasLot(boolean hasLot) {
        this.hasLot = hasLot;
    }

    public boolean isHasSerial() {
        return this.hasSerial;
    }

    public void setHasSerial(boolean hasSerial) {
        this.hasSerial = hasSerial;
    }

    public boolean isHasSize() {
        return this.hasSize;
    }

    public void setHasSize(boolean hasSize) {
        this.hasSize = hasSize;
    }

    public boolean isHasColor() {
        return this.hasColor;
    }

    public void setHasColor(boolean hasColor) {
        this.hasColor = hasColor;
    }

    public boolean isHasRevisions() {
        return this.hasRevisions;
    }

    public void setHasRevisions(boolean hasRevisions) {
        this.hasRevisions = hasRevisions;
    }

    public boolean isHasPackages() {
        return this.hasPackages;
    }

    public void setHasPackages(boolean hasPackages) {
        this.hasPackages = hasPackages;
    }

    public List<POSSizesAndColors> getSizesAndColors() {
        if (this.sizesAndColors == null) {
            this.sizesAndColors = new ArrayList<POSSizesAndColors>();
        }
        return this.sizesAndColors;
    }

    public void setSizesAndColors(List<POSSizesAndColors> sizesAndColors) {
        this.sizesAndColors = sizesAndColors;
    }

    public List<POSCustomerItemCode> getCustomerCodes() {
        if (this.customerCodes == null) {
            this.customerCodes = new ArrayList<POSCustomerItemCode>();
        }
        return this.customerCodes;
    }

    public void setCustomerCodes(List<POSCustomerItemCode> customerCodes) {
        this.customerCodes = customerCodes;
    }

    public List<POSManufacturerItemCode> getManfCodes() {
        if (this.manfCodes == null) {
            this.manfCodes = new ArrayList<POSManufacturerItemCode>();
        }
        return this.manfCodes;
    }

    public void setManfCodes(List<POSManufacturerItemCode> manfCodes) {
        this.manfCodes = manfCodes;
    }

    public List<POSItemRevision> getRevisions() {
        if (this.revisions == null) {
            this.revisions = new ArrayList<POSItemRevision>();
        }
        return this.revisions;
    }

    public void setRevisions(List<POSItemRevision> revisions) {
        this.revisions = revisions;
    }

    public List<POSItemUnit> getUnits() {
        if (this.units == null) {
            this.units = new ArrayList<POSItemUnit>();
        }
        return this.units;
    }

    public void setUnits(List<POSItemUnit> units) {
        this.units = units;
    }

    @Override
    public void initializeLists() {
        this.getSizesAndColors().size();
        this.getRevisions().size();
        this.getUnits().size();
        this.getCustomerCodes().size();
        this.getManfCodes().size();
        this.getDetails().size();
    }

    @Override
    public void updateData(DTOInvItem dtoItem) {
        int i;
        super.updateData(dtoItem);
        this.setDefaultSupplier((POSVendor)this.fromReference(dtoItem.getDefaultSupplier()));
        this.setItemType(dtoItem.getItemType());
        this.setHasColor(dtoItem.getHasColor());
        this.setHasLot(dtoItem.getHasLot());
        this.setHasPackages(dtoItem.getHasPackages());
        this.setHasSerial(dtoItem.getHasSerial());
        this.setAltCode(dtoItem.getAltCode());
        this.setHasRevisions(dtoItem.getHasRevisions());
        this.setHasSize(dtoItem.getHasSize());
        this.setReplaceable(dtoItem.getReplaceable());
        this.setReturnable(dtoItem.getReturnable());
        this.setSellable(dtoItem.getSellable());
        DTOItemUOM primaryUOM = dtoItem.getPrimaryUOM();
        this.setBaseUnit((POSUnit)this.fromReference(primaryUOM.getBaseUnit()));
        this.setDefaultSalesUnit((POSUnit)this.fromReference((EntityReferenceData)ObjectChecker.getFirstNotNullObj((Object[])new EntityReferenceData[]{primaryUOM.getDefaultSalesUnit(), primaryUOM.getBaseUnit()})));
        this.setTaxPlan((POSTaxPlan)this.fromReference(dtoItem.getTaxPlan()));
        CollectionsUtility.makeSecondSameSize((List)dtoItem.getRevisions(), this.getRevisions(), () -> new POSItemRevision());
        for (i = 0; i < dtoItem.getRevisions().size(); ++i) {
            this.getRevisions().get(i).updateRevision((DTOItemRevision)dtoItem.getRevisions().get(i));
            this.getRevisions().get(i).setPosItem(this);
        }
        CollectionsUtility.makeSecondSameSize((List)dtoItem.getSizesAndColors(), this.getSizesAndColors(), POSSizesAndColors::new);
        for (i = 0; i < dtoItem.getSizesAndColors().size(); ++i) {
            this.getSizesAndColors().get(i).updateColorAndSize((DTOSizesAndColors)dtoItem.getSizesAndColors().get(i));
            this.getSizesAndColors().get(i).setPosItem(this);
        }
        CollectionsUtility.makeSecondSameSize((List)dtoItem.getCustomerCodes(), this.getCustomerCodes(), POSCustomerItemCode::new);
        for (i = 0; i < dtoItem.getCustomerCodes().size(); ++i) {
            this.getCustomerCodes().get(i).updateDate((DTOCustomerItemCode)dtoItem.getCustomerCodes().get(i));
            this.getCustomerCodes().get(i).setPosItem(this);
        }
        CollectionsUtility.makeSecondSameSize((List)dtoItem.getManfCodes(), this.getManfCodes(), POSManufacturerItemCode::new);
        for (i = 0; i < dtoItem.getManfCodes().size(); ++i) {
            this.getManfCodes().get(i).updateDate((DTOManufacturerItemCode)dtoItem.getManfCodes().get(i));
            this.getManfCodes().get(i).setPosItem(this);
        }
        CollectionsUtility.makeSecondSameSize((List)dtoItem.getPrimaryUnits(), this.getUnits(), POSItemUnit::new);
        for (i = 0; i < dtoItem.getPrimaryUnits().size(); ++i) {
            DTOPrimaryItemUOMLine primaryLine = (DTOPrimaryItemUOMLine)dtoItem.getPrimaryUnits().get(i);
            this.updateUnitLine(i, (DTOItemUOMLine)primaryLine);
        }
        POSPricesCachingUtil.clearCache();
        for (i = 0; i < dtoItem.getSecondaryUnits().size(); ++i) {
            DTOSecondaryItemUOMLine secondaryLine = (DTOSecondaryItemUOMLine)dtoItem.getSecondaryUnits().get(i);
            this.updateUnitLine(i, (DTOItemUOMLine)secondaryLine);
        }
        if (ObjectChecker.isEmptyOrNull((Object)this.getRacksCodes())) {
            this.setRacksCodes("_#_");
        }
        CollectionsUtility.makeSecondSameSize((List)dtoItem.getDetails(), this.getDetails(), POSItemDimsDetail::new);
        for (i = 0; i < dtoItem.getDetails().size(); ++i) {
            DTOItemDimensionsDetail line = (DTOItemDimensionsDetail)dtoItem.getDetails().get(i);
            this.updateItemDimLine(i, line);
            boolean rackWithSameWare = POSResourcesUtil.fileMatched(POSResourcesUtil.fetchMainRegister().getWarehouse(), line.getItemDimensions().getSpecificDimensions().getWarehouse());
            boolean rackWithSameLocator = POSResourcesUtil.fileMatched(POSResourcesUtil.fetchMainRegister().getLocation(), line.getItemDimensions().getSpecificDimensions().getLocator());
            if (line.getData() == null || !ObjectChecker.isNotEmptyOrNull((Object)line.getData().getRackCode()) || this.getRacksCodes().contains(line.getData().getRackCode()) || !rackWithSameWare || !rackWithSameLocator) continue;
            this.setRacksCodes(this.getRacksCodes() + line.getData().getRackCode() + "_#_");
        }
        POSResourcesUtil.deleteOldImg(this.getId());
        if (dtoItem.getMainFile() == null || dtoItem.getMainFile().getDataLength() == 0L) {
            this.setHasImage(false);
        } else {
            this.setHasImage(true);
        }
        this.setCategory1((POSItemCategory)this.fromReference(dtoItem.getCategory1()));
        this.setCategory2((POSItemCategory)this.fromReference(dtoItem.getCategory2()));
        this.setCategory3((POSItemCategory)this.fromReference(dtoItem.getCategory3()));
        this.setCategory4((POSItemCategory)this.fromReference(dtoItem.getCategory4()));
        this.setCategory5((POSItemCategory)this.fromReference(dtoItem.getCategory5()));
        this.setSection((POSItemSection)this.fromReference(dtoItem.getSection()));
        this.setBrand((POSItemBrand)this.fromReference(dtoItem.getBrand()));
        this.setItemConfig((POSItemConfig)this.fromReference(dtoItem.getConfigurations()));
        this.setItemClass1((POSItemClass1)this.fromReference(dtoItem.getItemClass1()));
        this.setItemClass2((POSItemClass2)this.fromReference(dtoItem.getItemClass2()));
        this.setItemClass3((POSItemClass3)this.fromReference(dtoItem.getItemClass3()));
        this.setItemClass4((POSItemClass4)this.fromReference(dtoItem.getItemClass4()));
        this.setItemClass5((POSItemClass5)this.fromReference(dtoItem.getItemClass5()));
        this.setItemClass6((POSItemClass6)this.fromReference(dtoItem.getItemClass6()));
        this.setItemClass7((POSItemClass7)this.fromReference(dtoItem.getItemClass7()));
        this.setItemClass8((POSItemClass8)this.fromReference(dtoItem.getItemClass8()));
        this.setItemClass9((POSItemClass9)this.fromReference(dtoItem.getItemClass9()));
        this.setItemClass10((POSItemClass10)this.fromReference(dtoItem.getItemClass10()));
        POSResourcesUtil.clearCachedFavourites();
        POSResourcesUtil.removeItemFromTaxPlanCache(this.getId());
    }

    private void updateItemDimLine(int i, DTOItemDimensionsDetail line) {
        this.getDetails().get(i).setId(ServerStringUtils.strToUUID((String)line.getId()));
        this.getDetails().get(i).setPosItem(this);
        this.getDetails().get(i).setDefaultLocator(line.getDefaultLocator());
        this.getDetails().get(i).setLocation((POSLocation)this.fromReference(line.getItemDimensions().getSpecificDimensions().getLocator()));
        this.getDetails().get(i).setWarehouse((POSWarehouse)this.fromReference(line.getItemDimensions().getSpecificDimensions().getWarehouse()));
    }

    private void updateUnitLine(int i, DTOItemUOMLine dtoPrimaryItemUOMLine) {
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoPrimaryItemUOMLine.getUom())) {
            this.getUnits().get(i).setPosItem(this);
            this.getUnits().get(i).setCode(dtoPrimaryItemUOMLine.getCode());
            this.getUnits().get(i).setUnit((POSUnit)this.fromReference(dtoPrimaryItemUOMLine.getUom()));
            this.getUnits().get(i).setReteToBase(dtoPrimaryItemUOMLine.getRateToBase());
            this.getUnits().get(i).setDefaultPrice(dtoPrimaryItemUOMLine.getDefaultPrice());
            this.getUnits().get(i).setMinPrice(dtoPrimaryItemUOMLine.getMinPrice());
            this.getUnits().get(i).setMaxPrice(dtoPrimaryItemUOMLine.getMaxPrice());
        }
    }

    @Override
    public void assignIds() {
        if (this.getRevisions() != null) {
            for (POSItemRevision posItemRevision : this.getRevisions()) {
                posItemRevision.getId();
            }
        }
        if (this.getSizesAndColors() != null) {
            for (POSSizesAndColors sizeColor : this.getSizesAndColors()) {
                sizeColor.getId();
            }
        }
        if (this.getUnits() != null) {
            for (POSItemUnit unit : this.getUnits()) {
                unit.getId();
            }
        }
        for (POSCustomerItemCode customerItemCode : this.getCustomerCodes()) {
            customerItemCode.getId();
        }
        for (POSManufacturerItemCode manufacturerItemCode : this.getManfCodes()) {
            manufacturerItemCode.getId();
        }
        super.assignIds();
    }

    public static Map<String, String> fetchSizesAndColors_(String itemCode, boolean size) {
        POSItem item = (POSItem)POSPersister.findByCode(POSItem.class, itemCode);
        if (ObjectChecker.isEmptyOrNull((Object)item)) {
            return new HashMap<String, String>();
        }
        return size ? POSItem.fetchSizes(item) : POSItem.fetchColors(item);
    }

    public static Map<String, String> fetchSizes(POSItem item) {
        return item.getSizesAndColors().stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getSize())).collect(Collectors.toMap(POSSizesAndColors::getSize, POSSizesAndColors::getSizeName, (o1, o2) -> o1));
    }

    public static Map<String, String> fetchColors(POSItem item) {
        return item.getSizesAndColors().stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getColor())).collect(Collectors.toMap(POSSizesAndColors::getColor, POSSizesAndColors::getColorName, (o1, o2) -> o1));
    }

    public static Map<String, String> fetchRevisions(String itemCode) {
        POSItem item = (POSItem)POSPersister.findByCode(POSItem.class, itemCode);
        if (ObjectChecker.isNotEmptyOrNull((Object)item)) {
            return item.getRevisions().stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getRevisionId())).collect(Collectors.toMap(POSItemRevision::getRevisionId, POSItemRevision::nameByLanguage));
        }
        return new HashMap<String, String>();
    }

    public static String findDefaultRevision(String itemCode) {
        POSItem item = (POSItem)POSPersister.findByCode(POSItem.class, itemCode);
        if (ObjectChecker.isNotEmptyOrNull((Object)item)) {
            return item.getRevisions().stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getRevisionId())).filter(l -> ObjectChecker.isTrue((Boolean)l.isDefaultRevision())).map(POSItemRevision::getRevisionId).findFirst().orElse(null);
        }
        return null;
    }

    public static Map<String, String> fetchItemUoms(POSItem item, String itemCode) {
        HashMap<String, String> itemUoms = new HashMap<String, String>();
        List<POSUnit> units = POSItem.calcItemUoms(item, itemCode);
        for (POSUnit posUnit : units) {
            itemUoms.put(posUnit.getCode(), posUnit.nameByLanguage());
        }
        return itemUoms;
    }

    public static List<POSUnit> calcItemUoms(POSItem item, String itemCode) {
        ArrayList<POSUnit> units = new ArrayList<POSUnit>();
        if (item != null) {
            item = POSPersister.findByID(POSItem.class, item.getId());
        }
        if (item == null) {
            item = (POSItem)POSPersister.findByCode(POSItem.class, itemCode);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)item)) {
            for (POSItemUnit posItemUnit : item.getUnits()) {
                units.add(posItemUnit.getUnit());
            }
        }
        return units;
    }

    public POSUnit getBaseUnit() {
        this.baseUnit = POSPersister.materialize(POSUnit.class, this.baseUnit);
        return this.baseUnit;
    }

    public UUID fetchBaseUnitId() {
        return this.fetchId(this.baseUnit);
    }

    public void setBaseUnit(POSUnit baseUnit) {
        this.baseUnit = baseUnit;
    }

    public POSUnit getDefaultSalesUnit() {
        this.defaultSalesUnit = POSPersister.materialize(POSUnit.class, this.defaultSalesUnit);
        return this.defaultSalesUnit;
    }

    public UUID fetchDefaultSalesUnitId() {
        return this.fetchId(this.defaultSalesUnit);
    }

    public void setDefaultSalesUnit(POSUnit defaultSalesUnit) {
        this.defaultSalesUnit = defaultSalesUnit;
    }

    public static void clearUnitPriceCache() {
        cachedPrices.clear();
    }

    public BigDecimal getCurrentPrice() {
        return this.getCurrentPrice(null);
    }

    public BigDecimal getCurrentPrice(POSItemCode itemCode) {
        UUID key = this.getId();
        if (itemCode != null) {
            key = itemCode.getId();
        }
        if (cachedPrices.containsKey(key)) {
            return cachedPrices.get(key);
        }
        BigDecimal price = this.calcUnitPrice(itemCode);
        cachedPrices.put(key, price);
        return price;
    }

    public BigDecimal calcUnitPrice(POSItemCode itemCode) {
        POSItemSalesPriceReq priceRequest = this.createPriceRequest(BigDecimal.ONE, POSResourcesUtil.calcInvoiceClassification(POSResourcesUtil.fetchMainRegister()), itemCode, null);
        priceRequest.setPriceOnly(true);
        POSItemSalesPriceRes result = POSSalesPriceUtil.updateLinePriceAndDiscounts(priceRequest);
        if (result != null && ObjectChecker.isNotEmptyOrNull(result.getDetails())) {
            return result.getDetails().get(0).getPrice();
        }
        return BigDecimal.ZERO;
    }

    public void setCurrentPrice(BigDecimal price) {
    }

    public POSItemSalesPriceReq createPriceRequest(BigDecimal qty, POSInvoiceClassification posInvoiceClassification, POSItemCode itemCode, POSCustomer customer) {
        POSItemSalesPriceReq itemPriceReq = new POSItemSalesPriceReq();
        itemPriceReq.setRequestType(POSSalesPriceReqType.SingleLine);
        itemPriceReq.setValueDate(new Date());
        itemPriceReq.setDetails(new ArrayList<POSSalesPriceReqDetail>());
        itemPriceReq.setAfterDiscount1(BigDecimal.ZERO);
        itemPriceReq.setAfterDiscount2(BigDecimal.ZERO);
        itemPriceReq.setAfterDiscount3(BigDecimal.ZERO);
        itemPriceReq.setInvoiceClassification(posInvoiceClassification);
        itemPriceReq.setNetValue(BigDecimal.ZERO);
        itemPriceReq.setTotalValue(BigDecimal.ZERO);
        itemPriceReq.setCustomer(customer);
        itemPriceReq.setFractionalDecimalPlaces(POSMoneyUtils.fractionalDecimalPlaces);
        POSSalesPriceReqDetail req = new POSSalesPriceReqDetail();
        itemPriceReq.getDetails().add(req);
        req.setItem(this);
        POSUnit salesUnit = this.getDefaultSalesUnit();
        if (itemCode != null && itemCode.getUnit() != null) {
            salesUnit = itemCode.getUnit();
        }
        req.setUom(salesUnit);
        req.setQty(qty);
        req.setCurrentPrice(BigDecimal.ZERO);
        req.setDiscount1Percent(BigDecimal.ZERO);
        req.setDiscount2Percent(BigDecimal.ZERO);
        req.setSpecificDimensions(POSItem.createItemSpecificDims(itemCode));
        req.setFree(false);
        return itemPriceReq;
    }

    private static POSItemSpecificDimensions createItemSpecificDims(POSItemCode itemCode) {
        if (itemCode == null) {
            return null;
        }
        POSItemSpecificDimensions itemSpecificDimensions = new POSItemSpecificDimensions();
        if (ObjectChecker.areEqual((Object)((Object)itemCode.getCodeType()), (Object)((Object)POSItemCodeType.SizeAndColor))) {
            itemSpecificDimensions.setSize(itemCode.getSize());
            itemSpecificDimensions.setColor(itemCode.getColor());
            itemSpecificDimensions.setColorName(itemCode.getColorName());
            itemSpecificDimensions.setSizeName(itemCode.getSizeName());
        }
        if (ObjectChecker.areEqual((Object)((Object)itemCode.getCodeType()), (Object)((Object)POSItemCodeType.Revision))) {
            itemSpecificDimensions.setRevisionId(itemCode.getRevision());
        }
        return itemSpecificDimensions;
    }

    public boolean containsColor(String color) {
        for (POSSizesAndColors sizesAndColors : this.getSizesAndColors()) {
            if (!ObjectChecker.areEqual((Object)color, (Object)sizesAndColors.getColor())) continue;
            return true;
        }
        return false;
    }

    public boolean containsSize(String size) {
        for (POSSizesAndColors sizesAndColors : this.getSizesAndColors()) {
            if (!ObjectChecker.areEqual((Object)size, (Object)sizesAndColors.getSize())) continue;
            return true;
        }
        return false;
    }

    public boolean containsRevsision(String revision) {
        for (POSItemRevision revisions : this.getRevisions()) {
            if (!ObjectChecker.areEqual((Object)revision, (Object)revisions.getRevisionId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void postCommitAction(Session session) {
        POSItemCode posItemCode;
        List<?> oldCodes = POSPersister.listAll(POSItemCode.class, " where itemId =:item or code = :code", POSPersister.params("item", this.getId(), "code", this.getCode()), "");
        POSPersister.deleteAll(oldCodes);
        POSItemCode itemCode = new POSItemCode();
        itemCode.setCode(this.getCode());
        itemCode.setCodeType(POSItemCodeType.Code);
        itemCode.setItemId(this.getId());
        itemCode.setName1(this.getName1());
        itemCode.setName2(this.getName2());
        POSPersister.saveOrUpdate(itemCode, session);
        POSItemCode itemAltCode = new POSItemCode();
        itemAltCode.setCode(this.getAltCode());
        itemAltCode.setCodeType(POSItemCodeType.AltCode);
        itemAltCode.setItemId(this.getId());
        itemAltCode.setName1(this.getName1());
        itemAltCode.setName2(this.getName2());
        POSPersister.saveOrUpdate(itemAltCode, session);
        for (POSItemRevision posItemRevision : this.getRevisions()) {
            POSItemCode itemRevCode = this.createPOSItemCode(posItemRevision.getCode(), POSItemCodeType.Revision);
            itemRevCode.setName1(posItemRevision.getName1());
            itemRevCode.setName2(posItemRevision.getName2());
            itemRevCode.setRevision(posItemRevision.getRevisionId());
            itemRevCode.setUnit(posItemRevision.getDefaultUnit());
            POSPersister.saveOrUpdate(itemRevCode, session);
        }
        for (POSSizesAndColors posItemSizeColor : this.getSizesAndColors()) {
            POSItemCode itemSizeColor = this.createPOSItemCode(posItemSizeColor.getCode(), POSItemCodeType.SizeAndColor);
            itemSizeColor.setName1(posItemSizeColor.getName1());
            itemSizeColor.setName2(posItemSizeColor.getName2());
            itemSizeColor.setSize(posItemSizeColor.getSize());
            itemSizeColor.setColor(posItemSizeColor.getColor());
            itemSizeColor.setColorName(posItemSizeColor.getColorName());
            itemSizeColor.setSizeName(posItemSizeColor.getSizeName());
            POSPersister.saveOrUpdate(itemSizeColor, session);
        }
        for (POSCustomerItemCode posCustomerItemCode : this.getCustomerCodes()) {
            posItemCode = this.createPOSItemCode(posCustomerItemCode.getCode(), POSItemCodeType.CustomerCode);
            POSPersister.saveOrUpdate(posItemCode, session);
        }
        for (POSManufacturerItemCode posManufacturerItemCode : this.getManfCodes()) {
            posItemCode = this.createPOSItemCode(posManufacturerItemCode.getCode(), POSItemCodeType.ManfCode);
            POSPersister.saveOrUpdate(posItemCode, session);
        }
        for (POSItemUnit unitLine : this.getUnits()) {
            if (!ObjectChecker.isNotEmptyOrNull((Object)unitLine.getCode())) continue;
            POSItemCode uomLine = this.createPOSItemCode(unitLine.getCode(), POSItemCodeType.UOM);
            uomLine.setUnit(unitLine.getUnit());
            POSPersister.saveOrUpdate(uomLine, session);
        }
    }

    private POSItemCode createPOSItemCode(String posCustomerItemCode, POSItemCodeType customerCode) {
        POSItemCode posItemCode = new POSItemCode();
        posItemCode.setCode(posCustomerItemCode);
        posItemCode.setCodeType(customerCode);
        posItemCode.setItemId(this.getId());
        return posItemCode;
    }

    @Override
    public String calcNamaEntityType() {
        return "InvItem";
    }

    public String getAltCode() {
        return this.altCode;
    }

    public void setAltCode(String altCode) {
        this.altCode = altCode;
    }

    public Boolean getReturnable() {
        if (ObjectChecker.isEmptyOrNull((Object)this.returnable)) {
            return false;
        }
        return this.returnable;
    }

    public void setReturnable(Boolean returnable) {
        this.returnable = returnable;
    }

    public Boolean getReplaceable() {
        if (ObjectChecker.isEmptyOrNull((Object)this.replaceable)) {
            return false;
        }
        return this.replaceable;
    }

    public void setReplaceable(Boolean replaceable) {
        this.replaceable = replaceable;
    }

    public String getRacksCodes() {
        if (this.racksCodes == null) {
            this.racksCodes = "";
        }
        return this.racksCodes;
    }

    public void setRacksCodes(String racksCodes) {
        this.racksCodes = racksCodes;
    }

    @Override
    public Boolean isHasImage() {
        if (this.hasImage == null) {
            return true;
        }
        return this.hasImage;
    }

    @Override
    public void setHasImage(Boolean hasImage) {
        this.hasImage = hasImage;
    }

    public POSItemBrand getBrand() {
        this.brand = POSPersister.materialize(POSItemBrand.class, this.brand);
        return this.brand;
    }

    public POSItemBrand fetchBrandProxy() {
        return this.brand;
    }

    public void setBrand(POSItemBrand brand) {
        this.brand = brand;
    }

    public POSItemConfig getItemConfig() {
        this.itemConfig = POSPersister.materialize(POSItemConfig.class, this.itemConfig);
        return this.itemConfig;
    }

    public void setItemConfig(POSItemConfig itemConfig) {
        this.itemConfig = itemConfig;
    }

    public Boolean getSellable() {
        if (ObjectChecker.isEmptyOrNull((Object)this.sellable)) {
            return false;
        }
        return this.sellable;
    }

    public void setSellable(Boolean sellable) {
        this.sellable = sellable;
    }

    @Override
    public void postDeleteActions() {
        POSPersister.execute("delete from " + POSItemCode.class.getSimpleName() + " where itemId = :itemId", "itemId", this.id);
    }

    @Override
    public boolean canSearchOn() {
        return POSSecurityUtil.userCan(POSSecurityCapability.CanSearchOnItemCode).isSucceeded();
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList("code", "name1", "name2"));
        if (ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddRackCodeFields())) {
            fields.add("racksCodes");
        }
        return creatorUtil.createColumns(fields);
    }

    @Override
    public List<POSTableColumn> createCalculatedColumnList(TableCellCreatorUtil creatorUtil) {
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getAddPriceColToItemSearch())) {
            return creatorUtil.createColumns(Arrays.asList("currentPrice"));
        }
        return new ArrayList<POSTableColumn>();
    }

    @Override
    public List<String> filterByFields() {
        List<String> filterBy = super.filterByFields();
        if (ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddRackCodeFields())) {
            filterBy.add("racksCodes");
        }
        return filterBy;
    }

    @Override
    public boolean notAllowedToBeSelected(NamaSearchBox searchBox) {
        return !searchBox.isUsedInReport();
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public POSVendor getDefaultSupplier() {
        this.defaultSupplier = POSPersister.materialize(POSVendor.class, this.defaultSupplier);
        return this.defaultSupplier;
    }

    public void setDefaultSupplier(POSVendor defaultSupplier) {
        this.defaultSupplier = defaultSupplier;
    }

    @Override
    public void initializeSearchLevelLists() {
        this.getUnits().size();
    }

    public UUID fetchSectionId() {
        return this.fetchId(this.section);
    }

    public UUID fetchClass1Id() {
        return this.fetchId(this.itemClass1);
    }

    public UUID fetchClass2Id() {
        return this.fetchId(this.itemClass2);
    }

    public UUID fetchClass3Id() {
        return this.fetchId(this.itemClass3);
    }

    public UUID fetchClass4Id() {
        return this.fetchId(this.itemClass4);
    }

    public UUID fetchClass5Id() {
        return this.fetchId(this.itemClass5);
    }

    public UUID fetchClass6Id() {
        return this.fetchId(this.itemClass6);
    }

    public UUID fetchClass7Id() {
        return this.fetchId(this.itemClass7);
    }

    public UUID fetchClass8Id() {
        return this.fetchId(this.itemClass8);
    }

    public UUID fetchClass9Id() {
        return this.fetchId(this.itemClass9);
    }

    public UUID fetchClass10Id() {
        return this.fetchId(this.itemClass10);
    }
}

