/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.modules.supplychain.contracts.entities.DTOItemBrand;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSHasImage;
import com.namasoft.pos.domain.entities.POSItemSection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import org.hibernate.annotations.Index;

@Entity
public class POSItemBrand
extends POSMasterFile<DTOItemBrand>
implements POSHasImage {
    @Index(name="index_section")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemSection section;
    private Boolean hasImage;

    @Override
    public Boolean isHasImage() {
        if (this.hasImage == null) {
            return true;
        }
        return this.hasImage;
    }

    @Override
    public void setHasImage(Boolean hasImage) {
        this.hasImage = hasImage;
    }

    public POSItemSection getSection() {
        this.section = POSPersister.materialize(POSItemSection.class, this.section);
        return this.section;
    }

    public void setSection(POSItemSection section) {
        this.section = section;
    }

    @Override
    public String calcNamaEntityType() {
        return "ItemBrand";
    }

    @Override
    public void updateData(DTOItemBrand dtoItemBrand) {
        super.updateData(dtoItemBrand);
        this.setSection((POSItemSection)this.fromReference(dtoItemBrand.getSection()));
        POSResourcesUtil.deleteOldImg(this.getId());
        if (dtoItemBrand.getMainFile() == null || dtoItemBrand.getMainFile().getDataLength() == 0L) {
            this.setHasImage(false);
        } else {
            this.setHasImage(true);
        }
        POSResourcesUtil.clearCachedFavourites();
    }
}

