/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.modules.supplychain.contracts.entities.DTOItemCategory;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSHasImage;
import com.namasoft.pos.domain.entities.POSItemSection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import org.hibernate.annotations.Index;

@Entity
public class POSItemCategory
extends POSMasterFile<DTOItemCategory>
implements POSHasImage {
    @Index(name="index_section")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemSection section;
    private String categoryLevel;
    private String serial;
    private Boolean hasImage;

    @Override
    public Boolean isHasImage() {
        if (this.hasImage == null) {
            return true;
        }
        return this.hasImage;
    }

    @Override
    public void setHasImage(Boolean hasImage) {
        this.hasImage = hasImage;
    }

    public POSItemSection getSection() {
        this.section = POSPersister.materialize(POSItemSection.class, this.section);
        return this.section;
    }

    public void setSection(POSItemSection section) {
        this.section = section;
    }

    public String getCategoryLevel() {
        return this.categoryLevel;
    }

    public void setCategoryLevel(String categoryLevel) {
        this.categoryLevel = categoryLevel;
    }

    public String getSerial() {
        return this.serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    @Override
    public void updateData(DTOItemCategory dtoItemCategory) {
        super.updateData(dtoItemCategory);
        this.setCategoryLevel(dtoItemCategory.getCategoryLevel());
        this.setSection((POSItemSection)this.fromReference(dtoItemCategory.getSection()));
        POSResourcesUtil.deleteOldImg(this.getId());
        if (dtoItemCategory.getMainFile() == null || dtoItemCategory.getMainFile().getDataLength() == 0L) {
            this.setHasImage(false);
        } else {
            this.setHasImage(true);
        }
        POSResourcesUtil.clearCachedFavourites();
    }

    @Override
    public String calcNamaEntityType() {
        return "ItemCategory";
    }
}

