/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.modules.supplychain.contracts.entities.DTOItemClass2;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSHasImage;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemSection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import org.hibernate.annotations.Index;

@Entity
public class POSItemClass2
extends POSMasterFile<DTOItemClass2>
implements POSHasImage {
    @Index(name="index_section")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemSection section;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass1 parent;
    private Boolean hasImage;

    @Override
    public Boolean isHasImage() {
        if (this.hasImage == null) {
            return true;
        }
        return this.hasImage;
    }

    @Override
    public void setHasImage(Boolean hasImage) {
        this.hasImage = hasImage;
    }

    public POSItemSection getSection() {
        this.section = POSPersister.materialize(POSItemSection.class, this.section);
        return this.section;
    }

    public void setSection(POSItemSection section) {
        this.section = section;
    }

    public POSItemClass1 getParent() {
        this.parent = POSPersister.materialize(POSItemClass1.class, this.parent);
        return this.parent;
    }

    public void setParent(POSItemClass1 parent) {
        this.parent = parent;
    }

    @Override
    public String calcNamaEntityType() {
        return "ItemClass2";
    }

    @Override
    public void updateData(DTOItemClass2 itemClass) {
        super.updateData(itemClass);
        this.setSection((POSItemSection)this.fromReference(itemClass.getSection()));
        this.setParent((POSItemClass1)this.fromReference(itemClass.getParent()));
        POSResourcesUtil.deleteOldImg(this.getId());
        if (itemClass.getMainFile() == null || itemClass.getMainFile().getDataLength() == 0L) {
            this.setHasImage(false);
        } else {
            this.setHasImage(true);
        }
        POSResourcesUtil.clearCachedFavourites();
    }
}

