/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.modules.supplychain.contracts.entities.DTOItemClass6;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSHasImage;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemSection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import org.hibernate.annotations.Index;

@Entity
public class POSItemClass6
extends POSMasterFile<DTOItemClass6>
implements POSHasImage {
    @Index(name="index_section")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemSection section;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass5 parent;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass4 itemClass4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass3 itemClass3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass2 itemClass2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass1 itemClass1;
    private Boolean hasImage;

    @Override
    public Boolean isHasImage() {
        if (this.hasImage == null) {
            return true;
        }
        return this.hasImage;
    }

    @Override
    public void setHasImage(Boolean hasImage) {
        this.hasImage = hasImage;
    }

    @Override
    public String calcNamaEntityType() {
        return "ItemClass6";
    }

    public POSItemSection getSection() {
        this.section = POSPersister.materialize(POSItemSection.class, this.section);
        return this.section;
    }

    public void setSection(POSItemSection section) {
        this.section = section;
    }

    public POSItemClass5 getParent() {
        this.parent = POSPersister.materialize(POSItemClass5.class, this.parent);
        return this.parent;
    }

    public void setParent(POSItemClass5 parent) {
        this.parent = parent;
    }

    public POSItemClass4 getItemClass4() {
        this.itemClass4 = POSPersister.materialize(POSItemClass4.class, this.itemClass4);
        return this.itemClass4;
    }

    public void setItemClass4(POSItemClass4 itemClass4) {
        this.itemClass4 = itemClass4;
    }

    public POSItemClass3 getItemClass3() {
        this.itemClass3 = POSPersister.materialize(POSItemClass3.class, this.itemClass3);
        return this.itemClass3;
    }

    public void setItemClass3(POSItemClass3 itemClass3) {
        this.itemClass3 = itemClass3;
    }

    public POSItemClass2 getItemClass2() {
        this.itemClass2 = POSPersister.materialize(POSItemClass2.class, this.itemClass2);
        return this.itemClass2;
    }

    public void setItemClass2(POSItemClass2 itemClass2) {
        this.itemClass2 = itemClass2;
    }

    public POSItemClass1 getItemClass1() {
        this.itemClass1 = POSPersister.materialize(POSItemClass1.class, this.itemClass1);
        return this.itemClass1;
    }

    public void setItemClass1(POSItemClass1 itemClass1) {
        this.itemClass1 = itemClass1;
    }

    @Override
    public void updateData(DTOItemClass6 itemClass) {
        super.updateData(itemClass);
        this.setSection((POSItemSection)this.fromReference(itemClass.getSection()));
        this.setParent((POSItemClass5)this.fromReference(itemClass.getParent()));
        this.setItemClass1((POSItemClass1)this.fromReference(itemClass.getItemClass1()));
        this.setItemClass2((POSItemClass2)this.fromReference(itemClass.getItemClass2()));
        this.setItemClass3((POSItemClass3)this.fromReference(itemClass.getItemClass3()));
        this.setItemClass4((POSItemClass4)this.fromReference(itemClass.getItemClass4()));
        POSResourcesUtil.deleteOldImg(this.getId());
        if (itemClass.getMainFile() == null || itemClass.getMainFile().getDataLength() == 0L) {
            this.setHasImage(false);
        } else {
            this.setHasImage(true);
        }
        POSResourcesUtil.clearCachedFavourites();
    }
}

