/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.constants.AttachmentType;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.basic.dtos.DTOLegalEntity;
import com.namasoft.contracts.common.dtos.DTOContactInfo;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import com.namasoft.contracts.common.dtos.requests.ReadAttachmentRequest;
import com.namasoft.contracts.common.dtos.results.ReadAttachmentResult;
import com.namasoft.contracts.common.services.CoreWS;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.basic.contracts.valueobjects.DTODimensionInfo;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.IPOSHasContactInfo;
import com.namasoft.pos.domain.entities.IPOSHasLogo;
import com.namasoft.pos.domain.entities.POSHasUpdateDataWithSession;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.valueobjects.POSContactInfo;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;

@Entity
public class POSLegalEntity
extends POSMasterFile
implements POSHasUpdateDataWithSession<DTOLegalEntity>,
IPOSHasContactInfo,
IPOSHasLogo {
    @Lob
    private Blob logo;
    private transient ByteArrayInputStream logoStream;
    private Date foundationDate;
    private String commercialRegNo;
    private String socialInsuranceNo;
    private String taxRegNumber;
    private String taxFileID;
    private String taxRegIssuingOffice;
    @Embedded
    private POSContactInfo contactInfo;
    @Column(length=16)
    private UUID ledgerId;

    public UUID getLedgerId() {
        return this.ledgerId;
    }

    public void setLedgerId(UUID ledgerId) {
        this.ledgerId = ledgerId;
    }

    public ByteArrayInputStream getLogoStream() {
        return this.logoStream;
    }

    public void setLogoStream(ByteArrayInputStream logoStream) {
        this.logoStream = logoStream;
    }

    public Date getFoundationDate() {
        return this.foundationDate;
    }

    public void setFoundationDate(Date foundationDate) {
        this.foundationDate = foundationDate;
    }

    public String getCommercialRegNo() {
        return this.commercialRegNo;
    }

    public void setCommercialRegNo(String commercialRegNo) {
        this.commercialRegNo = commercialRegNo;
    }

    public String getSocialInsuranceNo() {
        return this.socialInsuranceNo;
    }

    public void setSocialInsuranceNo(String socialInsuranceNo) {
        this.socialInsuranceNo = socialInsuranceNo;
    }

    public String getTaxRegIssuingOffice() {
        return this.taxRegIssuingOffice;
    }

    public void setTaxRegIssuingOffice(String taxRegIssuingOffice) {
        this.taxRegIssuingOffice = taxRegIssuingOffice;
    }

    @Override
    public void setContactInfo(POSContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    @Override
    public POSContactInfo getContactInfo() {
        return this.contactInfo;
    }

    @Override
    public void initializeLists() {
        if (this.getLogo() != null) {
            try {
                this.logoStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)this.getLogo().getBinaryStream()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String calcNamaEntityType() {
        return "LegalEntity";
    }

    public Blob getLogo() {
        return this.logo;
    }

    public void setLogo(Blob logo) {
        this.logo = logo;
    }

    @Override
    public void updateData(DTOLegalEntity object, Session session) {
        super.updateData(object);
        DTOLargeData logo = object.getLogo();
        if (logo == null) {
            this.setLogo(null);
        } else {
            ReadAttachmentRequest attachmentRequest = new ReadAttachmentRequest();
            attachmentRequest.setOwnerEntityType("LegalEntity");
            attachmentRequest.setFileId(logo.getAttachmentInfo().getFileId());
            attachmentRequest.setAttachmentType(AttachmentType.ORIGINAL);
            CoreWS corews = (CoreWS)ServiceUtility.getServiceClient(CoreWS.class);
            ReadAttachmentResult readAttachmentResponse = corews.readAttachment(attachmentRequest);
            this.setLogo(POSReportDefinition.createBlobFromDataHanler(readAttachmentResponse.getData(), (int)logo.getDataLength(), session));
        }
        this.setFoundationDate(object.getInfo().getFoundationDate());
        this.setCommercialRegNo(object.getInfo().getCommercialRegNo());
        this.setSocialInsuranceNo(object.getInfo().getSocialInsuranceNo());
        this.setTaxRegNumber(object.getInfo().getTaxRegNumber());
        this.setTaxFileID(object.getInfo().getTaxFileID());
        this.setTaxRegIssuingOffice(object.getInfo().getTaxRegIssuingOffice());
        if (object.getLedger() != null) {
            this.setLedgerId(ServerStringUtils.strToUUID((String)object.getLedger().getId()));
        }
        POSLegalEntity.updateContactInfo(this, object.getDimensionInfo());
    }

    public static void updateContactInfo(IPOSHasContactInfo hasContactInfo, DTODimensionInfo dimensionInfo) {
        DTOContactInfo contactInfo;
        if (ObjectChecker.isEmptyOrNull((Object)dimensionInfo)) {
            dimensionInfo = new DTODimensionInfo();
        }
        if (ObjectChecker.isEmptyOrNull((Object)(contactInfo = dimensionInfo.getContactInfo()))) {
            contactInfo = new DTOContactInfo();
        }
        hasContactInfo.setContactInfo(new POSContactInfo());
        hasContactInfo.getContactInfo().setEmail(contactInfo.getEmail());
        hasContactInfo.getContactInfo().setFaxNumber(contactInfo.getFaxNumber());
        hasContactInfo.getContactInfo().setMobile(contactInfo.getMobile());
        hasContactInfo.getContactInfo().setTelephone1(contactInfo.getTelephone1());
        hasContactInfo.getContactInfo().setWebsite(contactInfo.getWebsite());
        hasContactInfo.getContactInfo().setAddress1(contactInfo.getAddress().getAddress1());
        hasContactInfo.getContactInfo().setAddress2(contactInfo.getAddress().getAddress2());
        hasContactInfo.getContactInfo().setCity(contactInfo.getAddress().getCity());
        hasContactInfo.getContactInfo().setCountryCode(contactInfo.getAddress().getCountryCode());
        hasContactInfo.getContactInfo().setBuildingNumber(contactInfo.getAddress().getBuildingNumber());
        hasContactInfo.getContactInfo().setDistrict(contactInfo.getAddress().getDistrict());
        hasContactInfo.getContactInfo().setPostalCode(contactInfo.getAddress().getPostalCode());
        hasContactInfo.getContactInfo().setArea(contactInfo.getAddress().getArea());
        hasContactInfo.getContactInfo().setCountry(contactInfo.getAddress().getCountry());
        hasContactInfo.getContactInfo().setState(contactInfo.getAddress().getState());
        hasContactInfo.getContactInfo().setStreet(contactInfo.getAddress().getStreet());
    }

    @Override
    public InputStream fetchLogoStream() {
        return this.logoStream;
    }

    public String getTaxFileID() {
        return this.taxFileID;
    }

    public void setTaxFileID(String taxFileID) {
        this.taxFileID = taxFileID;
    }

    public String getTaxRegNumber() {
        return this.taxRegNumber;
    }

    public void setTaxRegNumber(String taxRegNumber) {
        this.taxRegNumber = taxRegNumber;
    }
}

