/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.modules.supplychain.contracts.entities.DTOLocator;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSWarehouse;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;

@Entity
public class POSLocation
extends POSMasterFile<DTOLocator> {
    @ManyToOne(fetch=FetchType.LAZY)
    private POSWarehouse warehouse;
    private long priority;

    public POSLocation() {
    }

    public POSLocation(String code, String name1, String name2) {
        super(code, name1, name2);
    }

    public POSWarehouse getWarehouse() {
        this.warehouse = POSPersister.materialize(POSWarehouse.class, this.warehouse);
        return this.warehouse;
    }

    public void setWarehouse(POSWarehouse warehouse) {
        this.warehouse = warehouse;
    }

    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    @Override
    public void updateData(DTOLocator dtoLocator) {
        super.updateData(dtoLocator);
        this.setPriority(dtoLocator.getPriority());
        this.setCode(dtoLocator.getCode());
        this.setWarehouse((POSWarehouse)this.fromReference(dtoLocator.getWarehouse()));
    }

    @Override
    public String calcNamaEntityType() {
        return "Locator";
    }
}

