/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSPaymentMethodsSettingsLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSPaymentMethodsSettings;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSPaymentMethodsSettingsLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Entity
public class POSPaymentMethodsSettings
extends POSMasterFile<DTONamaPOSPaymentMethodsSettings> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="settings_id")
    @OrderColumn(name="lineNumber")
    private List<POSPaymentMethodsSettingsLine> details;

    public List<POSPaymentMethodsSettingsLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSPaymentMethodsSettingsLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSPaymentMethodsSettingsLine> details) {
        this.details = details;
    }

    @Override
    public void updateData(DTONamaPOSPaymentMethodsSettings object) {
        super.updateData(object);
        CollectionsUtility.makeSecondSameSize((List)object.getDetails(), this.getDetails(), POSPaymentMethodsSettingsLine::new);
        for (DTONamaPOSPaymentMethodsSettingsLine detail : object.getDetails()) {
            POSPaymentMethodsSettingsLine line = this.getDetails().removeFirst();
            line.setPaymentMethodId(UUID.fromString(detail.getPaymentMethod().getId()));
            if (detail.getDocCategory() != null) {
                line.setDocCategoryId(UUID.fromString(detail.getDocCategory().getId()));
            }
            if (detail.getInvoiceClassification() != null) {
                line.setInvoiceClassificationId(UUID.fromString(detail.getInvoiceClassification().getId()));
            }
            this.getDetails().add(line);
        }
        POSResourcesUtil.resetPaymentMethodsSettings();
    }

    @Override
    public void assignIds() {
        super.assignIds();
        this.getDetails().forEach(POSPaymentMethodsSettingsLine::getId);
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }
}

