/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.constants.AttachmentType;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.IHasPriceListDefaultPrice;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import com.namasoft.contracts.common.dtos.requests.ReadAttachmentRequest;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.ReadAttachmentResult;
import com.namasoft.contracts.common.services.CoreWS;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.namapos.contracts.common.DTOPOSReadQueueRequest;
import com.namasoft.modules.namapos.contracts.common.DTORegisterUpdater;
import com.namasoft.modules.namapos.contracts.details.DTOAbsPOSPaymentMethodLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSRegister;
import com.namasoft.modules.namapos.contracts.valueobjects.DTOPOSConditionGroup;
import com.namasoft.modules.namapos.contracts.valueobjects.DTOPosServiceCharge;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.displayPole.DisplayPoleConnectorUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.PosMobileUISettings;
import com.namasoft.pos.domain.PosUISettings;
import com.namasoft.pos.domain.details.POSHallTableLine;
import com.namasoft.pos.domain.details.POSRegisterContactInfoLine;
import com.namasoft.pos.domain.details.POSRegisteryCodingParam;
import com.namasoft.pos.domain.details.POSRegisteryCurrecyLine;
import com.namasoft.pos.domain.details.POSRegisteryFavouriteDocLine;
import com.namasoft.pos.domain.details.POSRegisteryFavouriteLine;
import com.namasoft.pos.domain.details.POSRegisteryFixedFavouriteLine;
import com.namasoft.pos.domain.details.POSRegisteryMethodLine;
import com.namasoft.pos.domain.details.POSRegisteryUserLine;
import com.namasoft.pos.domain.details.POSTakenElementsPerShiftLine;
import com.namasoft.pos.domain.details.PosMethodGroupLine;
import com.namasoft.pos.domain.entities.IPOSHasLogo;
import com.namasoft.pos.domain.entities.POSBranch;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSExtraFilter;
import com.namasoft.pos.domain.entities.POSHasUpdateDataWithSession;
import com.namasoft.pos.domain.entities.POSInternalMessage;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSLegalEntity;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.entities.POSRewardPointConfig;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSavingSettings;
import com.namasoft.pos.domain.entities.POSServiceChargeSettings;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosDefaultsTemplate;
import com.namasoft.pos.domain.entities.PosDeliveryCost;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.domain.entities.PosMinCharge;
import com.namasoft.pos.domain.entities.PosPaymentTerminal;
import com.namasoft.pos.domain.entities.PosPoleDisplaySpecs;
import com.namasoft.pos.domain.entities.Shortcuts;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.upgrader.POSUpgrader;
import com.namasoft.pos.util.POSDataReaderUtil;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSScreenSettings;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.pos.util.PosSalesUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Transient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;

@Entity
public class POSRegistery
extends POSMasterFile<DTONamaPOSRegister>
implements IPOSHasLogo,
POSHasUpdateDataWithSession<DTONamaPOSRegister>,
IHasPriceListDefaultPrice {
    private Boolean currentRegister;
    private UUID currencyId;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSWarehouse warehouse;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSLocation location;
    private Integer replaceWithIn;
    private String textCondition1;
    private String textCondition2;
    private String textCondition3;
    private String textCondition4;
    private String textCondition5;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSInvoiceClassification invoiceClassification;
    private String printerName;
    private String openDrawerCmd;
    private Boolean reSendPOSDataToNama;
    private Boolean downloadLatestRelease;
    private Boolean alwaysPrintFullInvoice;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosPaymentTerminal paymentTerminal;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="register")
    @OrderColumn(name="lineNumber")
    private List<POSRegisteryCurrecyLine> currencies;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="register")
    @OrderColumn(name="lineNumber")
    private List<POSRegisteryMethodLine> paymentMethods;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="register")
    @OrderColumn(name="lineNumber")
    private List<POSRegisteryCodingParam> docsCodingParams;
    private UUID itemBarcodeParserId;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="register")
    @OrderColumn(name="lineNumber")
    private List<POSRegisteryFavouriteLine> favouriteLines;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    private List<POSRegisteryFixedFavouriteLine> fixedFavouriteLines;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="register")
    @OrderColumn(name="lineNumber")
    private List<POSRegisteryFavouriteDocLine> favouriteDocs;
    private String machineIpAddress;
    private Integer machinePort;
    private Integer returnInvoicesWithIn;
    private Boolean inActive;
    private String favouriteItemsQuery;
    private Date workShiftTime;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosDocCategory docCategory;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosUISettings uiSettings;
    private Boolean collectPayMethodsByGroup;
    private Boolean useFavouritesColorCodeAsBG;
    private Boolean showFavoritesWithNoNextLevels;
    private Boolean doNotPrintNormalWithFullForm;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosPoleDisplaySpecs posPoleDisplaySpecs;
    private String defaultPaySubsidiaryType;
    private String defaultRecSubsidiaryType;
    private String linesCollectionMethod;
    private String customPriceQuery;
    private Integer documentsPrintCount;
    @Column(precision=20, scale=10)
    private BigDecimal maxFractionDiscountValue;
    private Boolean availableInMobileApp;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItem serviceChargeItem;
    @Column(precision=20, scale=10)
    private BigDecimal serviceChargePercent;
    private String serviceItemCalcType;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSServiceChargeSettings serviceChargeSettings;
    private String addServiceItemByInvClassification;
    private String addServiceItemWhenSelectingTable;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosDeliveryCost deliveryCost;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItem deliveryItem;
    private String addDeliveryItemByInvoiceClassification;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="register")
    @OrderColumn(name="lineNumber")
    private List<POSHallTableLine> tableLines;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="register_id")
    private List<POSTakenElementsPerShiftLine> takenElementsPerShiftLines;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItem minChargeItem;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosMinCharge minChargeSettings;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSavingSettings savingSettings;
    private String minChargeCalcType;
    private String addMinChargeItemByInvClassification;
    private String printPrepFormWithPayment;
    private String printPrepFormWithHold;
    private String printPrepFormWithDelayPay;
    private UUID posItemQtyUpdateConfigId;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosMobileUISettings mobileUISettings;
    @Lob
    private Blob logo;
    private transient ByteArrayInputStream logoStream;
    private String registerLoginTitle;
    @ManyToOne(fetch=FetchType.LAZY)
    private PosDefaultsTemplate defaultsTemplate;
    private Boolean doNotDisplayReturnedLinesWhenSelectingInv;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSExtraFilter extraFilters;
    private String codeDatePartFormat;
    private String addServiceItemAutomaticallyInInv;
    private String addDeliveryItemAutomaticallyInInv;
    private String addDeliveryItemWithCustomer;
    private Integer removeDocsAfter;
    private UUID shortcuts;
    private String priceListDefaultPrice;
    private UUID paymentMethodsSettings;
    private String trackInvoiceRemovedLines;
    @Transient
    private EntityReferenceData legalEntityRef;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSRewardPointConfig rewardPointConfig;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<POSRegisterContactInfoLine> contacts;
    private UUID ref1UUID;
    private UUID ref2UUID;
    private UUID ref3UUID;
    private UUID ref4UUID;
    private UUID ref5UUID;
    private Boolean subRegisterForCaptainOrder;
    private Boolean callCenterMode;
    private Boolean readOnlineOrdersFromCallCenter;
    private String description1;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    private List<POSRegisteryUserLine> allowedUsers;
    private String allowCustomerToOverpayByNonCash;
    @Transient
    private List<String> contactsAddresses = new ArrayList<String>();

    public Boolean getAlwaysPrintFullInvoice() {
        return this.alwaysPrintFullInvoice;
    }

    public void setAlwaysPrintFullInvoice(Boolean alwaysPrintFullInvoice) {
        this.alwaysPrintFullInvoice = alwaysPrintFullInvoice;
    }

    public String getPriceListDefaultPrice() {
        return this.priceListDefaultPrice;
    }

    public void setPriceListDefaultPrice(String priceListDefaultPrice) {
        this.priceListDefaultPrice = priceListDefaultPrice;
    }

    public PosDefaultsTemplate getDefaultsTemplate() {
        this.defaultsTemplate = POSPersister.materialize(PosDefaultsTemplate.class, this.defaultsTemplate);
        return this.defaultsTemplate;
    }

    public void setDefaultsTemplate(PosDefaultsTemplate defaultsTemplate) {
        this.defaultsTemplate = defaultsTemplate;
    }

    public Blob getLogo() {
        return this.logo;
    }

    public void setLogo(Blob logo) {
        this.logo = logo;
    }

    @Override
    public InputStream fetchLogoStream() {
        return this.logoStream;
    }

    public String getRegisterLoginTitle() {
        return this.registerLoginTitle;
    }

    public void setRegisterLoginTitle(String registerLoginTitle) {
        this.registerLoginTitle = registerLoginTitle;
    }

    public PosMobileUISettings getMobileUISettings() {
        this.mobileUISettings = POSPersister.materialize(PosMobileUISettings.class, this.mobileUISettings);
        return this.mobileUISettings;
    }

    public void setMobileUISettings(PosMobileUISettings mobileUISettings) {
        this.mobileUISettings = mobileUISettings;
    }

    public String getPrintPrepFormWithPayment() {
        return this.printPrepFormWithPayment;
    }

    public void setPrintPrepFormWithPayment(String printPrepFormWithPayment) {
        this.printPrepFormWithPayment = printPrepFormWithPayment;
    }

    public String getPrintPrepFormWithHold() {
        return this.printPrepFormWithHold;
    }

    public void setPrintPrepFormWithHold(String printPrepFormWithHold) {
        this.printPrepFormWithHold = printPrepFormWithHold;
    }

    public String getPrintPrepFormWithDelayPay() {
        return this.printPrepFormWithDelayPay;
    }

    public void setPrintPrepFormWithDelayPay(String printPrepFormWithDelayPay) {
        this.printPrepFormWithDelayPay = printPrepFormWithDelayPay;
    }

    public POSItem getMinChargeItem() {
        this.minChargeItem = POSPersister.materialize(POSItem.class, this.minChargeItem);
        return this.minChargeItem;
    }

    public void setMinChargeItem(POSItem minChargeItem) {
        this.minChargeItem = minChargeItem;
    }

    public PosMinCharge getMinChargeSettings() {
        this.minChargeSettings = POSPersister.materialize(PosMinCharge.class, this.minChargeSettings);
        return this.minChargeSettings;
    }

    public void setMinChargeSettings(PosMinCharge minChargeSettings) {
        this.minChargeSettings = minChargeSettings;
    }

    public String getMinChargeCalcType() {
        return this.minChargeCalcType;
    }

    public void setMinChargeCalcType(String minChargeCalcType) {
        this.minChargeCalcType = minChargeCalcType;
    }

    public String getAddMinChargeItemByInvClassification() {
        return this.addMinChargeItemByInvClassification;
    }

    public void setAddMinChargeItemByInvClassification(String addMinChargeByInvClassification) {
        this.addMinChargeItemByInvClassification = addMinChargeByInvClassification;
    }

    public POSSavingSettings getSavingSettings() {
        this.savingSettings = POSPersister.materialize(POSSavingSettings.class, this.savingSettings);
        return this.savingSettings;
    }

    public void setSavingSettings(POSSavingSettings savingSettings) {
        this.savingSettings = savingSettings;
    }

    public POSItem getDeliveryItem() {
        this.deliveryItem = POSPersister.materialize(POSItem.class, this.deliveryItem);
        return this.deliveryItem;
    }

    public void setDeliveryItem(POSItem deliveryItem) {
        this.deliveryItem = deliveryItem;
    }

    public PosDeliveryCost getDeliveryCost() {
        this.deliveryCost = POSPersister.materialize(PosDeliveryCost.class, this.deliveryCost);
        return this.deliveryCost;
    }

    public void setDeliveryCost(PosDeliveryCost deliveryCost) {
        this.deliveryCost = deliveryCost;
    }

    public String getAddDeliveryItemByInvoiceClassification() {
        return this.addDeliveryItemByInvoiceClassification;
    }

    public void setAddDeliveryItemByInvoiceClassification(String addDeliveryItemByInvoiceClassification) {
        this.addDeliveryItemByInvoiceClassification = addDeliveryItemByInvoiceClassification;
    }

    public String getServiceItemCalcType() {
        return this.serviceItemCalcType;
    }

    public void setServiceItemCalcType(String serviceItemCalcType) {
        this.serviceItemCalcType = serviceItemCalcType;
    }

    public POSItem getServiceChargeItem() {
        this.serviceChargeItem = POSPersister.materialize(POSItem.class, this.serviceChargeItem);
        return this.serviceChargeItem;
    }

    public void setServiceChargeItem(POSItem serviceChargeItem) {
        this.serviceChargeItem = serviceChargeItem;
    }

    public BigDecimal getServiceChargePercent() {
        if (ObjectChecker.isEmptyOrNull((Object)this.serviceChargePercent)) {
            this.serviceChargePercent = BigDecimal.ZERO;
        }
        return this.serviceChargePercent;
    }

    public POSServiceChargeSettings getServiceChargeSettings() {
        this.serviceChargeSettings = POSPersister.materialize(POSServiceChargeSettings.class, this.serviceChargeSettings);
        return this.serviceChargeSettings;
    }

    public void setServiceChargeSettings(POSServiceChargeSettings serviceChargeSettings) {
        this.serviceChargeSettings = serviceChargeSettings;
    }

    public void setServiceChargePercent(BigDecimal serviceChargePercent) {
        this.serviceChargePercent = serviceChargePercent;
    }

    public String getAddServiceItemByInvClassification() {
        return this.addServiceItemByInvClassification;
    }

    public void setAddServiceItemByInvClassification(String addServiceItemByInvClassification) {
        this.addServiceItemByInvClassification = addServiceItemByInvClassification;
    }

    public String getAddServiceItemWhenSelectingTable() {
        return this.addServiceItemWhenSelectingTable;
    }

    public void setAddServiceItemWhenSelectingTable(String addServiceItemWhenSelectingTable) {
        this.addServiceItemWhenSelectingTable = addServiceItemWhenSelectingTable;
    }

    public Boolean getAvailableInMobileApp() {
        if (ObjectChecker.isEmptyOrNull((Object)this.availableInMobileApp)) {
            this.availableInMobileApp = false;
        }
        return this.availableInMobileApp;
    }

    public void setAvailableInMobileApp(Boolean availableInMobileApp) {
        this.availableInMobileApp = availableInMobileApp;
    }

    public BigDecimal getMaxFractionDiscountValue() {
        return this.maxFractionDiscountValue;
    }

    public void setMaxFractionDiscountValue(BigDecimal maxFractionDiscountValue) {
        this.maxFractionDiscountValue = maxFractionDiscountValue;
    }

    public Integer getDocumentsPrintCount() {
        if (ObjectChecker.isEmptyOrZero((Integer)this.documentsPrintCount)) {
            this.documentsPrintCount = 1;
        }
        return this.documentsPrintCount;
    }

    public void setDocumentsPrintCount(Integer documentsPrintCount) {
        this.documentsPrintCount = documentsPrintCount;
    }

    public Boolean getDoNotPrintNormalWithFullForm() {
        if (ObjectChecker.isEmptyOrNull((Object)this.doNotPrintNormalWithFullForm)) {
            this.doNotPrintNormalWithFullForm = false;
        }
        return this.doNotPrintNormalWithFullForm;
    }

    public void setDoNotPrintNormalWithFullForm(Boolean doNotPrintNormalWithFullForm) {
        this.doNotPrintNormalWithFullForm = doNotPrintNormalWithFullForm;
    }

    public String getCustomPriceQuery() {
        return this.customPriceQuery;
    }

    public void setCustomPriceQuery(String customPriceQuery) {
        this.customPriceQuery = customPriceQuery;
    }

    public String getLinesCollectionMethod() {
        return this.linesCollectionMethod;
    }

    public void setLinesCollectionMethod(String linesCollectionMethod) {
        this.linesCollectionMethod = linesCollectionMethod;
    }

    public String getDefaultPaySubsidiaryType() {
        return this.defaultPaySubsidiaryType;
    }

    public void setDefaultPaySubsidiaryType(String defaultPaySubsidiaryType) {
        this.defaultPaySubsidiaryType = defaultPaySubsidiaryType;
    }

    public String getDefaultRecSubsidiaryType() {
        return this.defaultRecSubsidiaryType;
    }

    public void setDefaultRecSubsidiaryType(String defaultRecSubsidiaryType) {
        this.defaultRecSubsidiaryType = defaultRecSubsidiaryType;
    }

    public PosPoleDisplaySpecs getPosPoleDisplaySpecs() {
        this.posPoleDisplaySpecs = POSPersister.materialize(PosPoleDisplaySpecs.class, this.posPoleDisplaySpecs);
        return this.posPoleDisplaySpecs;
    }

    public void setPosPoleDisplaySpecs(PosPoleDisplaySpecs posPoleDisplaySpecs) {
        this.posPoleDisplaySpecs = posPoleDisplaySpecs;
    }

    public Boolean getShowFavoritesWithNoNextLevels() {
        return this.showFavoritesWithNoNextLevels;
    }

    public void setShowFavoritesWithNoNextLevels(Boolean showFavoritesWithNoNextLevels) {
        this.showFavoritesWithNoNextLevels = showFavoritesWithNoNextLevels;
    }

    public Boolean getUseFavouritesColorCodeAsBG() {
        if (ObjectChecker.isEmptyOrNull((Object)this.useFavouritesColorCodeAsBG)) {
            return false;
        }
        return this.useFavouritesColorCodeAsBG;
    }

    public void setUseFavouritesColorCodeAsBG(Boolean useFavouritesColorCodeAsBG) {
        this.useFavouritesColorCodeAsBG = useFavouritesColorCodeAsBG;
    }

    public Boolean getCollectPayMethodsByGroup() {
        return this.collectPayMethodsByGroup;
    }

    public void setCollectPayMethodsByGroup(Boolean collectPayMethodsByGroup) {
        this.collectPayMethodsByGroup = collectPayMethodsByGroup;
    }

    public PosUISettings getUiSettings() {
        this.uiSettings = POSPersister.materialize(PosUISettings.class, this.uiSettings);
        return this.uiSettings;
    }

    public void setUiSettings(PosUISettings uiSettings) {
        this.uiSettings = uiSettings;
    }

    public PosDocCategory getDocCategory() {
        this.docCategory = POSPersister.materialize(PosDocCategory.class, this.docCategory);
        return this.docCategory;
    }

    public void setDocCategory(PosDocCategory docCategory) {
        this.docCategory = docCategory;
    }

    public void setWorkShiftTime(Date workShiftTime) {
        this.workShiftTime = workShiftTime;
    }

    public Date getWorkShiftTime() {
        return this.workShiftTime;
    }

    public String getFavouriteItemsQuery() {
        return this.favouriteItemsQuery;
    }

    public void setFavouriteItemsQuery(String favouriteItemsQuery) {
        this.favouriteItemsQuery = favouriteItemsQuery;
    }

    public Boolean getInActive() {
        return this.inActive;
    }

    public void setInActive(Boolean inActive) {
        this.inActive = inActive;
    }

    public POSRegistery() {
    }

    public POSRegistery(String code, String name1, String name2, boolean currentRegister) {
        super(code, name1, name2);
        this.setCurrentRegister(currentRegister);
    }

    public Integer getReplaceWithIn() {
        return this.replaceWithIn;
    }

    public void setReplaceWithIn(Integer replaceWithIn) {
        this.replaceWithIn = replaceWithIn;
    }

    public String getTextCondition1() {
        return this.textCondition1;
    }

    public void setTextCondition1(String textCondition1) {
        this.textCondition1 = textCondition1;
    }

    public String getTextCondition2() {
        return this.textCondition2;
    }

    public void setTextCondition2(String textCondition2) {
        this.textCondition2 = textCondition2;
    }

    public String getTextCondition3() {
        return this.textCondition3;
    }

    public void setTextCondition3(String textCondition3) {
        this.textCondition3 = textCondition3;
    }

    public String getTextCondition4() {
        return this.textCondition4;
    }

    public void setTextCondition4(String textCondition4) {
        this.textCondition4 = textCondition4;
    }

    public String getTextCondition5() {
        return this.textCondition5;
    }

    public void setTextCondition5(String textCondition5) {
        this.textCondition5 = textCondition5;
    }

    public Boolean getCurrentRegister() {
        return this.currentRegister;
    }

    public void setCurrentRegister(Boolean currentRegister) {
        this.currentRegister = currentRegister;
    }

    public List<POSRegisteryFavouriteDocLine> getFavouriteDocs() {
        if (this.favouriteDocs == null) {
            this.favouriteDocs = new ArrayList<POSRegisteryFavouriteDocLine>();
            return this.favouriteDocs;
        }
        return this.favouriteDocs;
    }

    public void setFavouriteDocs(List<POSRegisteryFavouriteDocLine> favouriteDocs) {
        this.favouriteDocs = favouriteDocs;
    }

    public List<POSHallTableLine> getTableLines() {
        if (this.tableLines == null) {
            this.tableLines = new ArrayList<POSHallTableLine>();
            return this.tableLines;
        }
        return this.tableLines;
    }

    public Boolean getDoNotDisplayReturnedLinesWhenSelectingInv() {
        return this.doNotDisplayReturnedLinesWhenSelectingInv;
    }

    public void setDoNotDisplayReturnedLinesWhenSelectingInv(Boolean doNotDisplayReturnedLinesWhenSelectingInv) {
        this.doNotDisplayReturnedLinesWhenSelectingInv = doNotDisplayReturnedLinesWhenSelectingInv;
    }

    public void setTableLines(List<POSHallTableLine> tableLines) {
        this.tableLines = tableLines;
    }

    public List<POSTakenElementsPerShiftLine> getTakenElementsPerShiftLines() {
        if (this.takenElementsPerShiftLines == null) {
            this.takenElementsPerShiftLines = new ArrayList<POSTakenElementsPerShiftLine>();
        }
        return this.takenElementsPerShiftLines;
    }

    public void setTakenElementsPerShiftLines(List<POSTakenElementsPerShiftLine> takenElementsPerShiftLines) {
        this.takenElementsPerShiftLines = takenElementsPerShiftLines;
    }

    public POSExtraFilter getExtraFilters() {
        this.extraFilters = POSPersister.materialize(POSExtraFilter.class, this.extraFilters);
        return this.extraFilters;
    }

    public void setExtraFilters(POSExtraFilter extraFilters) {
        this.extraFilters = extraFilters;
    }

    public String getCodeDatePartFormat() {
        return this.codeDatePartFormat;
    }

    public void setCodeDatePartFormat(String codeDatePartFormat) {
        this.codeDatePartFormat = codeDatePartFormat;
    }

    public String getAddServiceItemAutomaticallyInInv() {
        return this.addServiceItemAutomaticallyInInv;
    }

    public void setAddServiceItemAutomaticallyInInv(String addServiceItemAutomaticallyInInv) {
        this.addServiceItemAutomaticallyInInv = addServiceItemAutomaticallyInInv;
    }

    public String getAddDeliveryItemAutomaticallyInInv() {
        return this.addDeliveryItemAutomaticallyInInv;
    }

    public void setAddDeliveryItemAutomaticallyInInv(String addDeliveryItemAutomaticallyInInv) {
        this.addDeliveryItemAutomaticallyInInv = addDeliveryItemAutomaticallyInInv;
    }

    public String getAddDeliveryItemWithCustomer() {
        return this.addDeliveryItemWithCustomer;
    }

    public void setAddDeliveryItemWithCustomer(String addDeliveryItemWithCustomer) {
        this.addDeliveryItemWithCustomer = addDeliveryItemWithCustomer;
    }

    public Integer getRemoveDocsAfter() {
        return this.removeDocsAfter;
    }

    public void setRemoveDocsAfter(Integer removeDocsAfter) {
        this.removeDocsAfter = removeDocsAfter;
    }

    public UUID getShortcuts() {
        return this.shortcuts;
    }

    public Shortcuts fetchShortcuts() {
        return POSPersister.findByID(Shortcuts.class, this.shortcuts);
    }

    public void setShortcuts(UUID shortcuts) {
        this.shortcuts = shortcuts;
    }

    public UUID getPaymentMethodsSettings() {
        return this.paymentMethodsSettings;
    }

    public void setPaymentMethodsSettings(UUID paymentMethodsSettings) {
        this.paymentMethodsSettings = paymentMethodsSettings;
    }

    public String getTrackInvoiceRemovedLines() {
        return this.trackInvoiceRemovedLines;
    }

    public void setTrackInvoiceRemovedLines(String trackInvoiceRemovedLines) {
        this.trackInvoiceRemovedLines = trackInvoiceRemovedLines;
    }

    public POSRewardPointConfig getRewardPointConfig() {
        return POSPersister.materialize(POSRewardPointConfig.class, this.rewardPointConfig);
    }

    public void setRewardPointConfig(POSRewardPointConfig rewardPointConfig) {
        this.rewardPointConfig = rewardPointConfig;
    }

    public List<POSRegisterContactInfoLine> getContacts() {
        if (this.contacts == null) {
            this.contacts = new ArrayList<POSRegisterContactInfoLine>();
        }
        return this.contacts;
    }

    public void setContacts(List<POSRegisterContactInfoLine> contacts) {
        this.contacts = contacts;
    }

    public UUID getRef1UUID() {
        return this.ref1UUID;
    }

    public void setRef1UUID(UUID ref1UUID) {
        this.ref1UUID = ref1UUID;
    }

    public UUID getRef2UUID() {
        return this.ref2UUID;
    }

    public void setRef2UUID(UUID ref2UUID) {
        this.ref2UUID = ref2UUID;
    }

    public UUID getRef3UUID() {
        return this.ref3UUID;
    }

    public void setRef3UUID(UUID ref3UUID) {
        this.ref3UUID = ref3UUID;
    }

    public UUID getRef4UUID() {
        return this.ref4UUID;
    }

    public void setRef4UUID(UUID ref4UUID) {
        this.ref4UUID = ref4UUID;
    }

    public UUID getRef5UUID() {
        return this.ref5UUID;
    }

    public void setRef5UUID(UUID ref5UUID) {
        this.ref5UUID = ref5UUID;
    }

    public Boolean getSubRegisterForCaptainOrder() {
        return this.subRegisterForCaptainOrder;
    }

    public void setSubRegisterForCaptainOrder(Boolean subRegisterForCaptainOrder) {
        this.subRegisterForCaptainOrder = subRegisterForCaptainOrder;
    }

    public Boolean getCallCenterMode() {
        return this.callCenterMode;
    }

    public void setCallCenterMode(Boolean callCenter) {
        this.callCenterMode = callCenter;
    }

    public Boolean getReadOnlineOrdersFromCallCenter() {
        return this.readOnlineOrdersFromCallCenter;
    }

    public void setReadOnlineOrdersFromCallCenter(Boolean acceptOnlineOrders) {
        this.readOnlineOrdersFromCallCenter = acceptOnlineOrders;
    }

    public String getDescription1() {
        return this.description1;
    }

    public void setDescription1(String description1) {
        this.description1 = description1;
    }

    public List<POSRegisteryUserLine> getAllowedUsers() {
        if (this.allowedUsers == null) {
            this.allowedUsers = new ArrayList<POSRegisteryUserLine>();
        }
        return this.allowedUsers;
    }

    public void setAllowedUsers(List<POSRegisteryUserLine> users) {
        this.allowedUsers = users;
    }

    public String getAllowCustomerToOverpayByNonCash() {
        return this.allowCustomerToOverpayByNonCash;
    }

    public void setAllowCustomerToOverpayByNonCash(String allowCustomerToOverpayByNonCash) {
        this.allowCustomerToOverpayByNonCash = allowCustomerToOverpayByNonCash;
    }

    @Override
    public void updateData(DTONamaPOSRegister dtoRegistry, Session session) {
        super.updateData(dtoRegistry);
        this.setCurrentRegister(dtoRegistry.getCurrentRegister());
        this.setPaymentTerminal((PosPaymentTerminal)this.fromReference((EntityReferenceData)ObjectChecker.getFirstNotNullObj((Object[])new EntityReferenceData[]{dtoRegistry.getPaymentTerminal(), POSResourcesUtil.fetchPOSConfig().getPaymentTerminal()})));
        this.setAlwaysPrintFullInvoice(dtoRegistry.getAlwaysPrintFullInvoice());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoRegistry.getPosItemBarcodeParser())) {
            this.setItemBarcodeParserId(ServerStringUtils.strToUUID((String)dtoRegistry.getPosItemBarcodeParser().getId()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoRegistry.getItemQtyUpdateConfig())) {
            this.setPosItemQtyUpdateConfigId(ServerStringUtils.strToUUID((String)dtoRegistry.getItemQtyUpdateConfig().getId()));
        } else {
            this.setPosItemQtyUpdateConfigId(null);
        }
        this.setWarehouse((POSWarehouse)this.fromReference(dtoRegistry.getWarehouse()));
        this.setDeliveryCost((PosDeliveryCost)this.fromReference(dtoRegistry.getDeliveryCost()));
        this.setAddDeliveryItemByInvoiceClassification(dtoRegistry.getAddDeliveryItemByInvoiceClassification());
        this.setMinChargeSettings((PosMinCharge)this.fromReference(dtoRegistry.getMinChargeSettings()));
        this.setMinChargeCalcType(dtoRegistry.getMinChargeCalcType());
        this.setSavingSettings((POSSavingSettings)POSSavable.staticFromReference(dtoRegistry.getInvSavingSettings()));
        this.setPrintPrepFormWithDelayPay(dtoRegistry.getPrintPrepFormWithDelayPay());
        this.setPrintPrepFormWithPayment(dtoRegistry.getPrintPrepFormWithPayment());
        this.setPrintPrepFormWithHold(dtoRegistry.getPrintPrepFormWithHold());
        this.setMinChargeItem((POSItem)this.fromReference(dtoRegistry.getMinChargeItem()));
        this.setAddMinChargeItemByInvClassification(dtoRegistry.getAddMinChargeItemByInvClassification());
        this.setMobileUISettings((PosMobileUISettings)this.fromReference(dtoRegistry.getMobileUISettings()));
        this.setDefaultPaySubsidiaryType(dtoRegistry.getDefaultPaySubsidiaryType());
        this.setDefaultRecSubsidiaryType(dtoRegistry.getDefaultRecSubsidiaryType());
        this.setLinesCollectionMethod(dtoRegistry.getLinesCollectionMethod());
        this.setLocation((POSLocation)this.fromReference(dtoRegistry.getLocator()));
        this.setInvoiceClassification((POSInvoiceClassification)this.fromReference(dtoRegistry.getInvoiceClassification()));
        this.setDocCategory((PosDocCategory)this.fromReference(dtoRegistry.getDefaultDocCategory()));
        this.setGenericDims(POSGenericDims.calcDims((BaseEntityDTO)dtoRegistry));
        this.setCollectPayMethodsByGroup(dtoRegistry.getCollectPayMethodsByGroup());
        this.setAvailableInMobileApp(dtoRegistry.getAvailableInMobileApp());
        if (dtoRegistry.getServiceCharge() == null) {
            dtoRegistry.setServiceCharge(new DTOPosServiceCharge());
        }
        this.setServiceItemCalcType(dtoRegistry.getServiceCharge().getServiceItemCalcType());
        this.setServiceChargePercent(dtoRegistry.getServiceCharge().getPercentage());
        this.setServiceChargeItem((POSItem)POSSavable.staticFromReference(dtoRegistry.getServiceCharge().getItem()));
        this.setServiceChargeSettings((POSServiceChargeSettings)POSSavable.staticFromReference(dtoRegistry.getServiceChargeSettings()));
        this.setAddServiceItemByInvClassification(dtoRegistry.getAddServiceItemByInvClassification());
        this.setAddServiceItemWhenSelectingTable(dtoRegistry.getAddServiceItemWhenSelectingTable());
        if (dtoRegistry.getSubsidiaryAccounts() != null) {
            this.fromReference(dtoRegistry.getSubsidiaryAccounts().getCurrency());
            this.setCurrencyId(ServerStringUtils.strToUUID((String)dtoRegistry.getSubsidiaryAccounts().getCurrency().getId()));
        }
        String registerId = ServerStringUtils.toUUIDStr((Object)dtoRegistry.getId());
        boolean currentRegister = ObjectChecker.areEqual((Object)dtoRegistry.getCode(), (Object)POSGeneralSettings.getRegisterCode());
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoRegistry.getReSendPOSDataToNama()) && dtoRegistry.getReSendPOSDataToNama().booleanValue() && currentRegister) {
            try {
                POSRegistery.resetFailureTimesAction();
                POSDataWriterUtil.writeData(this);
                POSWSClient.instance.updateRegisterResendOption((SendRequest<DTORegisterUpdater>)new SendRequest((Object)new DTORegisterUpdater(registerId, false)));
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
            }
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoRegistry.getDownloadLatestRelease()) && dtoRegistry.getDownloadLatestRelease().booleanValue() && currentRegister) {
            try {
                POSUpgrader.downloadUpgraderAndStartItWithoutConfirmation();
                POSWSClient.instance.updateDownloadReleaseOption((SendRequest<DTORegisterUpdater>)new SendRequest((Object)new DTORegisterUpdater(registerId, false)));
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
            }
        }
        if (ObjectChecker.isEmptyOrNull((Object)dtoRegistry.getConditionGroup())) {
            dtoRegistry.setConditionGroup(new DTOPOSConditionGroup());
        }
        if (ObjectChecker.isNotEmptyOrZero((Integer)dtoRegistry.getConditionGroup().getReplaceWithIn())) {
            this.setReplaceWithIn(dtoRegistry.getConditionGroup().getReplaceWithIn());
        } else {
            this.setReplaceWithIn(POSResourcesUtil.safeGetValue(POSResourcesUtil.fetchConfigConditionGroup().getReplaceWithIn()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoRegistry.getConditionGroup().getTextCondition1())) {
            this.setTextCondition1(dtoRegistry.getConditionGroup().getTextCondition1());
        } else {
            this.setTextCondition1(POSResourcesUtil.safeGetValue(POSResourcesUtil.fetchConfigConditionGroup().getTextCondition1()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoRegistry.getConditionGroup().getTextCondition2())) {
            this.setTextCondition2(dtoRegistry.getConditionGroup().getTextCondition2());
        } else {
            this.setTextCondition2(POSResourcesUtil.safeGetValue(POSResourcesUtil.fetchConfigConditionGroup().getTextCondition2()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoRegistry.getConditionGroup().getTextCondition3())) {
            this.setTextCondition3(dtoRegistry.getConditionGroup().getTextCondition3());
        } else {
            this.setTextCondition3(POSResourcesUtil.safeGetValue(POSResourcesUtil.fetchConfigConditionGroup().getTextCondition3()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoRegistry.getConditionGroup().getTextCondition4())) {
            this.setTextCondition4(dtoRegistry.getConditionGroup().getTextCondition4());
        } else {
            this.setTextCondition4(POSResourcesUtil.safeGetValue(POSResourcesUtil.fetchConfigConditionGroup().getTextCondition4()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)dtoRegistry.getConditionGroup().getTextCondition5())) {
            this.setTextCondition5(dtoRegistry.getConditionGroup().getTextCondition5());
        } else {
            this.setTextCondition5(POSResourcesUtil.safeGetValue(POSResourcesUtil.fetchConfigConditionGroup().getTextCondition5()));
        }
        this.setPrinterName(dtoRegistry.getPrinterName());
        this.setOpenDrawerCmd(dtoRegistry.getOpenDrawerCmd());
        if (currentRegister && ObjectChecker.isTrue((Boolean)dtoRegistry.getUpdatePOSRegisterProperties())) {
            POSGeneralSettings.updateProperties(dtoRegistry.getScreenProperties(), "screenProperties.properties");
            POSGeneralSettings.updateProperties(dtoRegistry.getConnectionProperties(), POSGeneralSettings.settingsFilePath);
            POSWSClient.instance.updatePOSRegisterProperties((SendRequest<DTORegisterUpdater>)new SendRequest((Object)new DTORegisterUpdater(registerId, false)));
        }
        if (currentRegister && ObjectChecker.isTrue((Boolean)dtoRegistry.getReadPropertiesFromRegister())) {
            DTOPOSReadQueueRequest request = new DTOPOSReadQueueRequest();
            request.setRegisterCode(dtoRegistry.getCode());
            request.setScreenProps(POSRegistery.getPropertyAsString(POSScreenSettings.load()));
            request.setConnectionProps(POSRegistery.getPropertyAsString(POSGeneralSettings.load()));
            POSWSClient.instance.readPropertiesFromRegister((SendRequest<DTOPOSReadQueueRequest>)new SendRequest((Object)request));
        }
        this.getCurrencies().clear();
        this.getCurrencies().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getCurrencies(), POSRegisteryCurrecyLine::new));
        this.getPaymentMethods().clear();
        this.getPaymentMethods().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getPaymentMethods(), object -> {
            POSRegisteryMethodLine line = new POSRegisteryMethodLine((DTOAbsPOSPaymentMethodLine)object, dtoRegistry);
            return line;
        }));
        this.getDocsCodingParams().clear();
        this.getDocsCodingParams().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getDocsCodingParams(), POSRegisteryCodingParam::new));
        if (ObjectChecker.areEqual((Object)POSGeneralSettings.getRegisterCode(), (Object)this.getCode())) {
            this.cacheRegisteryFields();
            this.preventOthersCurrenciesAndMethodsUsage();
            POSResourcesUtil.fieldAllowedValues.clear();
        }
        this.getFavouriteLines().clear();
        this.getFavouriteLines().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getFavouriteItems(), POSRegisteryFavouriteLine::new));
        this.getFixedFavouriteLines().clear();
        this.getFixedFavouriteLines().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getFixedFavouriteItems(), POSRegisteryFixedFavouriteLine::new));
        this.getFavouriteDocs().clear();
        this.getFavouriteDocs().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getFavouriteDocs(), POSRegisteryFavouriteDocLine::new));
        this.setMachineIpAddress(dtoRegistry.getMachineIpAddress());
        this.setMachinePort(dtoRegistry.getMachinePort());
        this.setReturnInvoicesWithIn(dtoRegistry.getReturnInvoicesWithIn());
        this.setInActive(dtoRegistry.getInActive());
        this.setSubRegisterForCaptainOrder(dtoRegistry.getSubRegisterForCaptainOrder());
        this.setCallCenterMode(dtoRegistry.getCallCenterMode());
        this.setReadOnlineOrdersFromCallCenter(dtoRegistry.getReadOnlineOrdersFromCallCenter());
        this.setFavouriteItemsQuery(dtoRegistry.getFavouriteItemsQuery());
        this.setUiSettings((PosUISettings)this.fromReference(dtoRegistry.getUiSettings()));
        this.setUseFavouritesColorCodeAsBG(dtoRegistry.getUseFavouritesColorCodeAsBG());
        if (currentRegister) {
            POSDataReaderUtil.cacheReportDefinitions();
            POSResourcesUtil.clearCachedFavourites();
        }
        this.setShowFavoritesWithNoNextLevels(dtoRegistry.getShowFavoritesWithNoNextLevels());
        this.setPosPoleDisplaySpecs((PosPoleDisplaySpecs)this.fromReference(dtoRegistry.getPoleDisplaySpecs()));
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getPosPoleDisplaySpecs()) && currentRegister) {
            DisplayPoleConnectorUtil.createDisplayPoleConnectorIfNeeded(this);
        }
        this.setCustomPriceQuery(dtoRegistry.getCustomPriceQuery());
        this.setDoNotPrintNormalWithFullForm(dtoRegistry.getDoNotPrintNormalWithFullForm());
        this.setDocumentsPrintCount(dtoRegistry.getDocumentsPrintCount());
        this.setMaxFractionDiscountValue(dtoRegistry.getMaxFractionDiscountValue());
        this.setDeliveryItem((POSItem)this.fromReference(dtoRegistry.getDeliveryItem()));
        this.getTableLines().clear();
        this.getTableLines().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getTables(), POSHallTableLine::new));
        this.getTakenElementsPerShiftLines().clear();
        this.getTakenElementsPerShiftLines().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getTakenElementsPerShift(), POSTakenElementsPerShiftLine::new));
        this.setRegisterLoginTitle(dtoRegistry.getRegisterLoginTitle());
        DTOLargeData logo = dtoRegistry.getRegisterLogo();
        if (logo == null) {
            this.setLogo(null);
        } else {
            ReadAttachmentResult readAttachmentResponse = this.readAttachment(logo.getAttachmentInfo().getFileId());
            this.setLogo(POSReportDefinition.createBlobFromDataHanler(readAttachmentResponse.getData(), (int)logo.getDataLength(), session));
        }
        this.setDefaultsTemplate((PosDefaultsTemplate)this.fromReference(dtoRegistry.getDefaultsTemplate()));
        this.setDoNotDisplayReturnedLinesWhenSelectingInv(dtoRegistry.getDoNotDisplayReturnedLinesWhenSelectingInv());
        this.setExtraFilters((POSExtraFilter)POSSavable.staticFromReference(dtoRegistry.getExtraFilters()));
        POSResourcesUtil.resetExtraFilters();
        this.setCodeDatePartFormat(dtoRegistry.getPosCodeDatePartFormat());
        this.setAddServiceItemAutomaticallyInInv(dtoRegistry.getAddServiceItemAutomaticallyInInv());
        this.setAddDeliveryItemWithCustomer(dtoRegistry.getAddDeliveryItemWithCustomer());
        this.setAddDeliveryItemAutomaticallyInInv(dtoRegistry.getAddDeliveryItemAutomaticallyInInv());
        this.setRemoveDocsAfter(dtoRegistry.getRemoveDocsFromPOSAfter());
        this.setShortcuts(ServerStringUtils.strToUUID(dtoRegistry.getShortcuts() == null ? null : dtoRegistry.getShortcuts().getId()));
        this.setPaymentMethodsSettings(ServerStringUtils.strToUUID(dtoRegistry.getPaymentMethodsSettings() == null ? null : dtoRegistry.getPaymentMethodsSettings().getId()));
        POSResourcesUtil.resetPaymentMethodsSettings();
        PosSalesUtil.evictChargeItemsAndDeliveryCostCache();
        this.setPriceListDefaultPrice(dtoRegistry.getPriceListDefaultPrice());
        this.setTrackInvoiceRemovedLines(dtoRegistry.getTrackInvoiceRemovedLines());
        this.setRewardPointConfig((POSRewardPointConfig)POSSavable.staticFromReference(dtoRegistry.getRewardPointsConfig()));
        this.getContacts().clear();
        this.getContacts().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getContacts(), POSRegisterContactInfoLine::new));
        this.setRef1UUID(this.fetchRefUUID(dtoRegistry.getRef1()));
        this.setRef2UUID(this.fetchRefUUID(dtoRegistry.getRef2()));
        this.setRef3UUID(this.fetchRefUUID(dtoRegistry.getRef3()));
        this.setRef4UUID(this.fetchRefUUID(dtoRegistry.getRef4()));
        this.setRef5UUID(this.fetchRefUUID(dtoRegistry.getRef5()));
        this.setDescription1(dtoRegistry.getDescription1());
        this.getAllowedUsers().clear();
        this.getAllowedUsers().addAll(CollectionsUtility.convert((Collection)dtoRegistry.getAllowedUsers(), POSRegisteryUserLine::new));
        this.setAllowCustomerToOverpayByNonCash(dtoRegistry.getAllowCustomerToOverpayByNonCash());
    }

    public void cacheRegisteryFields() {
        for (POSRegisteryCurrecyLine currecyLine : this.getCurrencies()) {
            if (POSResourcesUtil.currencies.contains(currecyLine.getCurrency())) continue;
            POSResourcesUtil.currencies.add(currecyLine.getCurrency());
        }
        POSRegistery.addBasicCurrencyIfNotAdded();
        try {
            this.cachePaymentMethods();
            this.cacheTablesAndHalls();
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public static String getPropertyAsString(Properties properties) {
        if (properties == null) {
            return null;
        }
        if (properties.isEmpty()) {
            return "";
        }
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        String text = POSRegistery.normalizeNewLines(writer.toString());
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(text.split("\n")));
        lines.remove(0);
        return lines.stream().collect(Collectors.joining("\n"));
    }

    private static String normalizeNewLines(String text) {
        return text.replace("\r\n", "\n").replace("\r", "\n");
    }

    private void cacheTablesAndHalls() {
        POSResourcesUtil.tables.clear();
        POSResourcesUtil.tables.addAll(this.getTableLines().stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getPosTable())).map(POSHallTableLine::getPosTable).collect(Collectors.toList()));
        POSResourcesUtil.halls.clear();
        POSResourcesUtil.halls.addAll(this.getTableLines().stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getPosHall())).map(POSHallTableLine::getPosHall).collect(Collectors.toList()));
    }

    private void cachePaymentMethods() {
        POSResourcesUtil.methods.clear();
        ArrayList appliedMethods = new ArrayList();
        List configLines = CollectionsUtility.convert((Collection)POSResourcesUtil.fetchPOSConfig().getPaymentMethods(), object -> new POSRegisteryMethodLine((DTOAbsPOSPaymentMethodLine)object, null, true));
        if (ObjectChecker.isNotEmptyOrNull(this.getPaymentMethods())) {
            appliedMethods.addAll(this.getPaymentMethods().stream().map(POSRegisteryMethodLine::getPaymentMethod).collect(Collectors.toList()));
        } else if (ObjectChecker.isNotEmptyOrNull((Object)configLines)) {
            appliedMethods.addAll(configLines.stream().map(l -> POSPersister.findByID(POSPaymentMethod.class, l.getPaymentMethod().getId())).collect(Collectors.toList()));
        }
        appliedMethods.forEach(m -> {
            if (!POSResourcesUtil.methods.contains(m)) {
                POSResourcesUtil.methods.add((POSPaymentMethod)m);
            }
        });
    }

    public static void addBasicCurrencyIfNotAdded() {
        if (POSResourcesUtil.fetchMainRegister() == null) {
            return;
        }
        POSCurrency currency = POSPersister.findByID(POSCurrency.class, POSResourcesUtil.fetchMainRegister().getCurrencyId());
        if (!POSResourcesUtil.currencies.contains(currency)) {
            POSResourcesUtil.currencies.add(currency);
        }
    }

    public void preventOthersCurrenciesAndMethodsUsage() {
        List<POSCurrency> allCurrencies = POSPersister.listAll(POSCurrency.class);
        for (POSCurrency pOSCurrency : allCurrencies) {
            pOSCurrency.allowUsage();
        }
        List otherCurrencies = CollectionsUtility.filter(allCurrencies, object -> !POSResourcesUtil.currencies.contains(object));
        for (Object posCurrency : otherCurrencies) {
            ((POSMasterFile)posCurrency).preventItFromUsage();
        }
        List<POSPaymentMethod> list = POSPersister.listAll(POSPaymentMethod.class);
        for (POSPaymentMethod method2 : list) {
            method2.allowUsage();
        }
        List otherPaymentMethods = CollectionsUtility.filter(list, method -> !POSResourcesUtil.methods.contains(method));
        for (POSPaymentMethod method3 : otherPaymentMethods) {
            method3.preventItFromUsage();
        }
    }

    public ReadAttachmentResult readAttachment(String fileId) {
        ReadAttachmentRequest attachmentRequest = new ReadAttachmentRequest();
        attachmentRequest.setOwnerEntityType("NamaPOSRegister");
        attachmentRequest.setFileId(fileId);
        attachmentRequest.setAttachmentType(AttachmentType.ORIGINAL);
        CoreWS corews = (CoreWS)ServiceUtility.getServiceClient(CoreWS.class);
        ReadAttachmentResult readAttachmentResponse = corews.readAttachment(attachmentRequest);
        return readAttachmentResponse;
    }

    private UUID fetchRefUUID(EntityReferenceData ref) {
        if (ref == null || ObjectChecker.isEmptyOrNull((Object)ref.getId())) {
            return null;
        }
        return UUID.fromString(ref.getId());
    }

    public POSLocation getLocation() {
        this.location = POSPersister.materialize(POSLocation.class, this.location);
        return this.location;
    }

    public void setLocation(POSLocation location) {
        this.location = location;
    }

    public POSWarehouse getWarehouse() {
        this.warehouse = POSPersister.materialize(POSWarehouse.class, this.warehouse);
        return this.warehouse;
    }

    public void setWarehouse(POSWarehouse warehouse) {
        this.warehouse = warehouse;
    }

    public UUID getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(UUID currencyId) {
        this.currencyId = currencyId;
    }

    public POSCurrency fetchCurrency() {
        return POSPersister.findByID(POSCurrency.class, this.getCurrencyId());
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSRegister";
    }

    public POSInvoiceClassification getInvoiceClassification() {
        this.invoiceClassification = POSPersister.materialize(POSInvoiceClassification.class, this.invoiceClassification);
        return this.invoiceClassification;
    }

    public void setInvoiceClassification(POSInvoiceClassification invoiceClassification) {
        this.invoiceClassification = invoiceClassification;
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    public String getOpenDrawerCmd() {
        return this.openDrawerCmd;
    }

    public void setOpenDrawerCmd(String openDrawerCmd) {
        this.openDrawerCmd = openDrawerCmd;
    }

    public List<POSRegisteryCurrecyLine> getCurrencies() {
        if (this.currencies == null) {
            this.currencies = new ArrayList<POSRegisteryCurrecyLine>();
            return this.currencies;
        }
        return this.currencies;
    }

    public void setCurrencies(List<POSRegisteryCurrecyLine> currencies) {
        this.currencies = currencies;
    }

    public List<POSRegisteryMethodLine> getPaymentMethods() {
        if (this.paymentMethods == null) {
            this.paymentMethods = new ArrayList<POSRegisteryMethodLine>();
            return this.paymentMethods;
        }
        return this.paymentMethods;
    }

    public void setPaymentMethods(List<POSRegisteryMethodLine> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }

    @Override
    public void initializeLists() {
        this.getCurrencies().size();
        this.getPaymentMethods().size();
        this.getDocsCodingParams().size();
        this.getFavouriteLines().size();
        this.getFixedFavouriteLines().size();
        this.getFavouriteDocs().size();
        this.getTableLines().size();
        this.getTakenElementsPerShiftLines().size();
        this.getContacts().size();
        this.getAllowedUsers().size();
        if (this.getLogo() != null) {
            try {
                this.logoStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)this.getLogo().getBinaryStream()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setFavouriteLines(List<POSRegisteryFavouriteLine> favouriteLines) {
        this.favouriteLines = favouriteLines;
    }

    public List<POSRegisteryFavouriteLine> getFavouriteLines() {
        if (this.favouriteLines == null) {
            this.favouriteLines = new ArrayList<POSRegisteryFavouriteLine>();
            return this.favouriteLines;
        }
        return this.favouriteLines;
    }

    public List<POSRegisteryFixedFavouriteLine> getFixedFavouriteLines() {
        if (this.fixedFavouriteLines == null) {
            this.fixedFavouriteLines = new ArrayList<POSRegisteryFixedFavouriteLine>();
            return this.fixedFavouriteLines;
        }
        return this.fixedFavouriteLines;
    }

    public void setFixedFavouriteLines(List<POSRegisteryFixedFavouriteLine> fixedFavouriteLines) {
        this.fixedFavouriteLines = fixedFavouriteLines;
    }

    @Override
    public void assignIds() {
        super.assignIds();
        for (POSRegisteryCurrecyLine pOSRegisteryCurrecyLine : this.getCurrencies()) {
            pOSRegisteryCurrecyLine.getId();
            pOSRegisteryCurrecyLine.setRegister(this);
        }
        for (POSRegisteryMethodLine pOSRegisteryMethodLine : this.getPaymentMethods()) {
            pOSRegisteryMethodLine.getId();
            pOSRegisteryMethodLine.setRegister(this);
        }
        for (POSRegisteryCodingParam pOSRegisteryCodingParam : this.getDocsCodingParams()) {
            pOSRegisteryCodingParam.getId();
            pOSRegisteryCodingParam.setRegister(this);
        }
        for (POSRegisteryFavouriteLine pOSRegisteryFavouriteLine : this.getFavouriteLines()) {
            pOSRegisteryFavouriteLine.getId();
            pOSRegisteryFavouriteLine.setRegister(this);
        }
        this.getFixedFavouriteLines().forEach(l -> l.assignIds());
        for (POSRegisteryFavouriteDocLine pOSRegisteryFavouriteDocLine : this.getFavouriteDocs()) {
            pOSRegisteryFavouriteDocLine.getId();
            pOSRegisteryFavouriteDocLine.setRegister(this);
        }
        for (POSHallTableLine pOSHallTableLine : this.getTableLines()) {
            pOSHallTableLine.getId();
            pOSHallTableLine.setRegister(this);
        }
        for (POSTakenElementsPerShiftLine pOSTakenElementsPerShiftLine : this.getTakenElementsPerShiftLines()) {
            pOSTakenElementsPerShiftLine.getId();
        }
        this.getContacts().forEach(POSRegisterContactInfoLine::getId);
        this.getAllowedUsers().forEach(POSRegisteryUserLine::getId);
    }

    public String fetchCashMethodId() {
        for (POSPaymentMethod method : POSResourcesUtil.methods) {
            if (!ObjectChecker.isTrue((Boolean)method.getCashMethod())) continue;
            return method.getId().toString();
        }
        return "";
    }

    public static void resetFailureTimesAction() {
        POSRegistery.resetFailureTimes(POSCustomer.class);
        POSRegistery.resetFailureTimes(POSSalesInvoice.class);
        POSRegistery.resetFailureTimes(POSSalesReturn.class);
        POSRegistery.resetFailureTimes(POSSalesReplacement.class);
        POSRegistery.resetFailureTimes(POSStockTransferReq.class);
        POSRegistery.resetFailureTimes(POSPaymentToRegistery.class);
        POSRegistery.resetFailureTimes(POSReceiptFromRegistery.class);
        POSRegistery.resetFailureTimes(POSShiftOpen.class);
        POSRegistery.resetFailureTimes(POSShiftClose.class);
        POSRegistery.resetFailureTimes(POSInventory.class);
        POSRegistery.resetFailureTimes(POSInternalMessage.class);
        POSRegistery.resetFailureTimes(POSCreditNote.class);
    }

    private static void resetFailureTimes(Class<? extends POSMasterFile> klass) {
        String oql = "Update " + klass.getSimpleName() + " set writeFailures = 0 where writeFailures > 0";
        POSPersister.execute(oql);
    }

    public List<POSRegisteryCodingParam> getDocsCodingParams() {
        if (this.docsCodingParams == null) {
            this.docsCodingParams = new ArrayList<POSRegisteryCodingParam>();
            return this.docsCodingParams;
        }
        return this.docsCodingParams;
    }

    public POSRegisteryCodingParam fetchPOSRegisteryCodingParam(String entityType) {
        List typeCodes = this.getDocsCodingParams().stream().filter(ObjectChecker.equalsPredicate((Object)entityType, POSRegisteryCodingParam::getType)).collect(Collectors.toList());
        if (ObjectChecker.isEmptyOrNull(typeCodes)) {
            return null;
        }
        if (typeCodes.size() == 1) {
            return (POSRegisteryCodingParam)typeCodes.get(0);
        }
        return typeCodes.stream().filter(ObjectChecker.equalsPredicate((Object)POSGeneralSettings.codePrefix(), POSRegisteryCodingParam::getPerfix)).findFirst().orElse((POSRegisteryCodingParam)typeCodes.get(0));
    }

    public UUID getItemBarcodeParserId() {
        return this.itemBarcodeParserId;
    }

    public void setItemBarcodeParserId(UUID itemBarcodeParserId) {
        this.itemBarcodeParserId = itemBarcodeParserId;
    }

    @Override
    public void postCommitAction(Session session) {
        POSResourcesUtil.defaultsTemplate = null;
        POSRegistery.cachePgwMethods(this);
    }

    public static void cachePgwMethods(POSRegistery registery) {
        POSRegistery currentRegister = POSResourcesUtil.fetchMainRegister();
        if (currentRegister == null) {
            return;
        }
        if (ObjectChecker.areNotEqual((Object)currentRegister.getId(), (Object)registery.getId())) {
            return;
        }
        PosPaymentTerminal registerTerminal = registery.getPaymentTerminal();
        if (registerTerminal == null && POSResourcesUtil.fetchPOSConfig().getPaymentTerminal() != null) {
            registerTerminal = POSPersister.findByID(PosPaymentTerminal.class, UUID.fromString(POSResourcesUtil.fetchPOSConfig().getPaymentTerminal().getId()));
        }
        if (registerTerminal == null) {
            POSResourcesUtil.pgwMethods = new ArrayList<POSPaymentMethod>();
        } else if (ObjectChecker.isNotEmptyOrNull((Object)registerTerminal.getMethodGroup()) && ObjectChecker.isNotEmptyOrNull(registerTerminal.getMethodGroup().getDetails())) {
            POSResourcesUtil.pgwMethods = registerTerminal.getMethodGroup().getDetails().stream().map(PosMethodGroupLine::getPaymentMethod).filter(pm -> ObjectChecker.isFalseOrNull((Boolean)pm.getHideInPaymentDialog())).collect(Collectors.toList());
        }
    }

    @Override
    public void afterCommitSuccessfully() {
        POSResourcesUtil.clearRegisteryCache();
        if (ObjectChecker.areNotEqual((Object)POSGeneralSettings.getRegisterCode(), (Object)this.getCode())) {
            return;
        }
        POSResourcesUtil.fetchRegister(true);
        POSResourcesUtil.cacheRegisterConfigFields();
    }

    public String getMachineIpAddress() {
        return this.machineIpAddress;
    }

    public void setMachineIpAddress(String machineIpAddress) {
        this.machineIpAddress = machineIpAddress;
    }

    public Integer getMachinePort() {
        return this.machinePort;
    }

    public void setMachinePort(Integer machinePort) {
        this.machinePort = machinePort;
    }

    public PosPaymentTerminal getPaymentTerminal() {
        this.paymentTerminal = POSPersister.materialize(PosPaymentTerminal.class, this.paymentTerminal);
        return this.paymentTerminal;
    }

    public void setPaymentTerminal(PosPaymentTerminal paymentTerminal) {
        this.paymentTerminal = paymentTerminal;
    }

    public InputStream fetchLogo() {
        InputStream logoStream = this.fetchLogoFor(POSRegistery.class, this.getId());
        if (logoStream == null) {
            logoStream = this.fetchLogoFor(POSBranch.class, this.getGenericDims().getBranch().getId());
        }
        if (logoStream == null) {
            logoStream = this.fetchLogoFor(POSLegalEntity.class, this.getGenericDims().getLegalEntity().getId());
        }
        return logoStream;
    }

    public <T extends IPOSHasLogo & POSSavable> InputStream fetchLogoFor(Class<T> forClass, UUID logoContainerID) {
        if (ObjectChecker.isEmptyOrNull((Object)logoContainerID)) {
            return null;
        }
        IPOSHasLogo logoContainer = (IPOSHasLogo)POSPersister.findByID(forClass, logoContainerID);
        return logoContainer == null ? null : logoContainer.fetchLogoStream();
    }

    public POSSavable fetchDim(Class klass) {
        POSDimInfo dim = this.getGenericDims().getLegalEntity();
        switch (klass.getSimpleName()) {
            case "POSSector": {
                dim = this.getGenericDims().getSector();
                break;
            }
            case "POSBranch": {
                dim = this.getGenericDims().getBranch();
                break;
            }
            case "POSDepartment": {
                dim = this.getGenericDims().getDepartment();
                break;
            }
            case "POSAnalysisset": {
                dim = this.getGenericDims().getAnalysisSet();
            }
        }
        if (ObjectChecker.isEmptyOrNull((Object)dim)) {
            return null;
        }
        UUID dimId = dim.getId();
        if (ObjectChecker.isEmptyOrNull((Object)dimId)) {
            return null;
        }
        return POSPersister.findByID(klass, dimId);
    }

    public POSLegalEntity fetchLegalEntity() {
        return (POSLegalEntity)this.fetchDim(POSLegalEntity.class);
    }

    public Integer getReturnInvoicesWithIn() {
        return this.returnInvoicesWithIn;
    }

    public void setReturnInvoicesWithIn(Integer returnInvoicesWithIn) {
        this.returnInvoicesWithIn = returnInvoicesWithIn;
    }

    public boolean hasSpringBootProps() {
        return ObjectChecker.isNotEmptyOrZero((Integer)this.getMachinePort());
    }

    public UUID getPosItemQtyUpdateConfigId() {
        return this.posItemQtyUpdateConfigId;
    }

    public void setPosItemQtyUpdateConfigId(UUID posItemQtyUpdateConfigId) {
        this.posItemQtyUpdateConfigId = posItemQtyUpdateConfigId;
    }

    public EntityReferenceData fetchLegalEntityRef() {
        if (this.legalEntityRef == null) {
            this.legalEntityRef = this.fetchLegalEntity().toEntityReferenceData();
        }
        return this.legalEntityRef;
    }

    public String fetchRegisterLoginTitle() {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getRegisterLoginTitle())) {
            return this.getRegisterLoginTitle();
        }
        if (this.fetchLegalEntity() != null) {
            return this.fetchLegalEntity().nameByLanguage();
        }
        return "Namasoft";
    }

    public List<String> fetchContactsAddresses() {
        if (ObjectChecker.isNotEmptyOrNull(this.contactsAddresses)) {
            return this.contactsAddresses;
        }
        if (ObjectChecker.isEmptyOrNull(this.getContacts())) {
            return new ArrayList<String>();
        }
        String registers = this.getContacts().stream().map(l -> "0x" + ServerStringUtils.toUUIDStr((Object)l.getRegisterId())).collect(Collectors.joining(","));
        List<Object[]> registersInfo = POSPersister.executeSelect("SELECT MachineIpAddress,MachinePort FROM POSRegistery ", " id in (" + registers + ")", new HashMap<String, Object>());
        for (Object[] objects : registersInfo) {
            this.contactsAddresses.add(String.valueOf(objects[0]) + ":" + String.valueOf(objects[1]));
        }
        return this.contactsAddresses;
    }
}

