/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesReplacement;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSReplacementReturnPaymentLine;
import com.namasoft.pos.domain.details.POSReplacementSalesPaymentLine;
import com.namasoft.pos.domain.details.POSReturnPaymentLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.details.POSSalesPaymentLine;
import com.namasoft.pos.domain.details.POSSalesRepalcementLine;
import com.namasoft.pos.domain.details.POSSalesReturnLine;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoice;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReturnReason;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.PosSalesUtil;
import com.namasoft.pos.util.TableCellCreatorUtil;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.Session;

@Entity
public class POSSalesReplacement
extends AbsPOSSales
implements IPOSDocFromInvoice {
    private String fromInvCode;
    private UUID fromInvoiceId;
    private Boolean fromInvoiceOnServer;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSSalesRepalcementLine> details;
    @Transient
    private List<POSSalesInvoiceLine> invLines;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSReplacementSalesPaymentLine> salesPaymentLines;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSReplacementReturnPaymentLine> returnPaymentLines;
    private String genInvoiceCode;
    private String genReturnCode;
    @Column(precision=20, scale=10)
    private BigDecimal newPaidCash;
    @Column(precision=20, scale=10)
    private BigDecimal returnTotalPaid;
    @Column(precision=20, scale=10)
    private BigDecimal salesTotalPaid;
    private Boolean srcInvoiceFromRemoteRegister = false;
    private UUID srcInvoiceRegisterId;
    @JoinColumn(name="returnReason_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSReturnReason returnReason;
    @Transient
    private Integer extendedReplacementDays;

    @Override
    public UUID getSrcInvoiceRegisterId() {
        return this.srcInvoiceRegisterId;
    }

    @Override
    public void setSrcInvoiceRegisterId(UUID srcInvoiceRegisterId) {
        this.srcInvoiceRegisterId = srcInvoiceRegisterId;
    }

    @Override
    public Boolean getSrcInvoiceFromRemoteRegister() {
        return this.srcInvoiceFromRemoteRegister;
    }

    @Override
    public void setSrcInvoiceFromRemoteRegister(Boolean srcInvoiceFromRemoteRegister) {
        this.srcInvoiceFromRemoteRegister = srcInvoiceFromRemoteRegister;
    }

    @Override
    public POSReturnReason getReturnReason() {
        this.returnReason = POSPersister.materialize(POSReturnReason.class, this.returnReason);
        return this.returnReason;
    }

    @Override
    public void setReturnReason(POSReturnReason returnReason) {
        this.returnReason = returnReason;
    }

    public POSSalesReplacement() {
    }

    public POSSalesReplacement(AbsPosSalesScreen screen) {
        this.setDetails(new ArrayList<POSSalesRepalcementLine>());
        this.setSalesPaymentLines(new ArrayList<POSReplacementSalesPaymentLine>());
        this.setReturnPaymentLines(new ArrayList<POSReplacementReturnPaymentLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public BigDecimal getReturnTotalPaid() {
        return this.returnTotalPaid;
    }

    public void setReturnTotalPaid(BigDecimal returnTotalPaid) {
        this.returnTotalPaid = returnTotalPaid;
    }

    public List<POSReplacementSalesPaymentLine> getSalesPaymentLines() {
        if (this.salesPaymentLines == null) {
            this.salesPaymentLines = new ArrayList<POSReplacementSalesPaymentLine>();
        }
        return this.salesPaymentLines;
    }

    @Override
    public Boolean isFromInvoiceOnServer() {
        if (this.fromInvoiceOnServer == null) {
            this.fromInvoiceOnServer = false;
        }
        return this.fromInvoiceOnServer;
    }

    @Override
    public void setFromInvoiceOnServer(Boolean fromInvoiceOnServer) {
        this.fromInvoiceOnServer = fromInvoiceOnServer;
    }

    public void setSalesPaymentLines(List<POSReplacementSalesPaymentLine> salesPaymentLines) {
        this.salesPaymentLines = salesPaymentLines;
    }

    public List<POSReplacementReturnPaymentLine> getReturnPaymentLines() {
        if (this.returnPaymentLines == null) {
            this.returnPaymentLines = new ArrayList<POSReplacementReturnPaymentLine>();
        }
        return this.returnPaymentLines;
    }

    public void setReturnPaymentLines(List<POSReplacementReturnPaymentLine> returnPaymentLines) {
        this.returnPaymentLines = returnPaymentLines;
    }

    public void setGenInvoiceCode(String genInvoiceCode) {
        this.genInvoiceCode = genInvoiceCode;
    }

    public void setGenReturnCode(String genReturnCode) {
        this.genReturnCode = genReturnCode;
    }

    @Override
    public String getFromInvCode() {
        return this.fromInvCode;
    }

    @Override
    public void setFromInvCode(String fromInvCode) {
        this.fromInvCode = fromInvCode;
    }

    public List<POSSalesRepalcementLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSSalesRepalcementLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSSalesRepalcementLine> details) {
        this.details = details;
    }

    public List<POSSalesInvoiceLine> fetchInvLines() {
        if (this.invLines == null) {
            this.invLines = new ArrayList<POSSalesInvoiceLine>();
        }
        return this.invLines;
    }

    public void setInvLines(List<POSSalesInvoiceLine> invLines) {
        this.invLines = invLines;
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public String fromInvoiceCode() {
        return this.getFromInvCode();
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID methodId, BigDecimal value, String authorizationNumber, Boolean cash) {
        return (T)new POSReplacementSalesPaymentLine(methodName, methodId, value, authorizationNumber, cash);
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        POSSalesRepalcementLine posSalesRepalcementLine = new POSSalesRepalcementLine();
        posSalesRepalcementLine.setInvoice(this);
        return (T)posSalesRepalcementLine;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSSalesReplacement";
    }

    @Override
    public Integer fetchInvoiceGracePeriod() {
        return POSResourcesUtil.fetchMainRegister().getReplaceWithIn() + this.fetchExtendedReplacementDays();
    }

    public Integer fetchExtendedReplacementDays() {
        return ObjectChecker.toZeroIfNull((Integer)this.extendedReplacementDays);
    }

    @Override
    public void setExtendedReturnOrReplacementDays(Integer extendedReturnDays) {
        this.extendedReplacementDays = extendedReturnDays;
    }

    public void genDocs(Session session, boolean saveAsDraft) {
        if (ObjectChecker.isTrue((Boolean)this.getHold())) {
            return;
        }
        ArrayList<POSSalesRepalcementLine> invoiceLines = new ArrayList<POSSalesRepalcementLine>();
        ArrayList<POSSalesRepalcementLine> returnLines = new ArrayList<POSSalesRepalcementLine>();
        for (POSSalesRepalcementLine line : this.getDetails()) {
            if (line.getQty().getValue().compareTo(BigDecimal.ZERO) < 0) {
                line.setReturnedLine(true);
            }
            if (ObjectChecker.isEmptyOrNull((Object)line.getReturnedLine()) || !line.getReturnedLine().booleanValue()) {
                invoiceLines.add(line);
                continue;
            }
            returnLines.add(line);
        }
        if (ObjectChecker.isNotEmptyOrNull(invoiceLines)) {
            this.createInvoice(invoiceLines, session);
        }
        if (ObjectChecker.isNotEmptyOrNull(returnLines)) {
            this.createReturn(returnLines, session, saveAsDraft);
        }
    }

    private void createReturn(List<POSSalesRepalcementLine> returnLines, Session session, boolean saveAsDraft) {
        POSSalesReturn salesReturn = (POSSalesReturn)this.findGeneratedDocOrCreateIt(POSSalesReturn.class);
        salesReturn.setReplacementCode(this.getCode());
        salesReturn.setReplacementId(this.getId());
        salesReturn.setRegisterId(this.getRegisterId());
        this.setGenReturnCode(salesReturn.getCode());
        this.updateCommonFields(salesReturn);
        salesReturn.getDetails().clear();
        salesReturn.getDetails().addAll(CollectionsUtility.convert(returnLines, object -> {
            POSQuantity qty = object.getQty();
            qty.setValue(qty.getValue().abs());
            POSSalesReturnLine invoiceLine = new POSSalesReturnLine(qty, object.getUnitPrice(), object.getTotalPrice(), object.getItem(), object.getItemCode(), object.getDiscount1(), object.getDiscount2(), object.getTax1(), object.getTax2(), object.getNetPrice(), object.getDiscount3(), object.getDiscount4(), object.getDiscount5(), object.getDiscount6(), object.getDiscount7(), object.getDiscount8());
            invoiceLine.setBox(object.getBox());
            invoiceLine.setAfterDisc1(object.getAfterDisc1());
            invoiceLine.setAfterDisc2(object.getAfterDisc2());
            invoiceLine.setAfterDisc3(object.getAfterDisc3());
            invoiceLine.setAfterDisc4(object.getAfterDisc4());
            invoiceLine.setAfterDisc5(object.getAfterDisc5());
            invoiceLine.setAfterDisc6(object.getAfterDisc6());
            invoiceLine.setAfterDisc7(object.getAfterDisc7());
            invoiceLine.setAfterDisc8(object.getAfterDisc8());
            invoiceLine.setAfterTax1(object.getAfterTax1());
            invoiceLine.setAfterTax2(object.getAfterTax2());
            invoiceLine.setCurrency(object.getCurrency());
            invoiceLine.setFreeLine(object.getFreeLine());
            invoiceLine.setHeaderDicount(object.getHeaderDicount());
            invoiceLine.setInvoice(salesReturn);
            invoiceLine.setItem(object.getItem());
            invoiceLine.setItemDimensions(object.getItemDimensions());
            invoiceLine.setLocation(object.getLocation());
            invoiceLine.setWarehouse(object.getWarehouse());
            invoiceLine.setRemarks(object.getRemarks());
            this.updateLineValues(invoiceLine);
            return invoiceLine;
        }));
        salesReturn.getPaymentLines().clear();
        salesReturn.getPaymentLines().addAll(CollectionsUtility.convert(this.getReturnPaymentLines(), object -> {
            POSReturnPaymentLine paymentLine = new POSReturnPaymentLine(object.getMethodName(), object.getMethod_id(), object.getValue(), object.getAuthorizationNumber(), object.getCash());
            paymentLine.setInvoice(salesReturn);
            paymentLine.setMethodName(object.getMethodName());
            paymentLine.setCurrency(object.getCurrency());
            paymentLine.setShiftCode(object.getShiftCode());
            return paymentLine;
        }));
        salesReturn.setNetPrice(this.calcReturnNet());
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getPaidCash())) {
            salesReturn.setPaidCash(this.calcReturnNet().abs());
        }
        salesReturn.assignIds();
        if (ObjectChecker.isEmptyOrZero((BigDecimal)salesReturn.getPaidCash())) {
            salesReturn.setPaidCash(salesReturn.getTotalPaid().subtract(salesReturn.totalOtherPayments()));
        }
        salesReturn.updateLineAndTotalMoney(null, true);
        salesReturn.setRemainingChange(salesReturn.getNetPrice().abs().subtract(salesReturn.getTotalPaid()));
        POSResult posResult = POSPersister.saveOrUpdateWithActionHistory(salesReturn, session);
        if (posResult.isSucceeded().booleanValue()) {
            POSDataWriterUtil.writeReturns(Arrays.asList(salesReturn), null, saveAsDraft);
        }
    }

    private <T extends AbsPOSSales> T findGeneratedDocOrCreateIt(Class<? extends AbsPOSSales> klass) {
        List<?> docs = POSPersister.listAll(klass, " where replacementCode = :code", POSPersister.params("code", this.getCode()), "");
        if (ObjectChecker.isNotEmptyOrNull(docs)) {
            return (T)((AbsPOSSales)docs.get(0));
        }
        AbsPOSSales doc = (AbsPOSSales)ObjectCreatorUtil.creator(klass).create();
        String code = "";
        if (ObjectChecker.areEqual(klass, POSSalesInvoice.class)) {
            code = POSCodeGenerator.generateInvoiceCode(POSDocumentType.Invoice);
        }
        if (ObjectChecker.areEqual(klass, POSSalesReturn.class)) {
            code = POSCodeGenerator.generateInvoiceCode(POSDocumentType.Return);
        }
        doc.setCode(code);
        return (T)doc;
    }

    private void createInvoice(List<POSSalesRepalcementLine> invoiceLines, Session session) {
        POSSalesInvoice invoice = (POSSalesInvoice)this.findGeneratedDocOrCreateIt(POSSalesInvoice.class);
        invoice.setReplacementCode(this.getCode());
        invoice.setReplacementId(this.getId());
        invoice.setRegisterId(this.getRegisterId());
        this.setGenInvoiceCode(invoice.getCode());
        this.updateCommonFields(invoice);
        invoice.setTotalPaid(this.getSalesTotalPaid());
        invoice.getDetails().clear();
        invoice.getDetails().addAll(CollectionsUtility.convert(invoiceLines, object -> {
            POSSalesInvoiceLine invoiceLine = new POSSalesInvoiceLine(object.getQty(), object.getUnitPrice(), object.getTotalPrice(), object.getItem(), object.getItemCode(), object.getDiscount1(), object.getDiscount2(), object.getTax1(), object.getTax2(), object.getNetPrice(), object.getDiscount3(), object.getDiscount4(), object.getDiscount5(), object.getDiscount6(), object.getDiscount7(), object.getDiscount8());
            invoiceLine.setBox(object.getBox());
            invoiceLine.setAfterDisc1(object.getAfterDisc1());
            invoiceLine.setAfterDisc2(object.getAfterDisc2());
            invoiceLine.setAfterDisc3(object.getAfterDisc3());
            invoiceLine.setAfterDisc4(object.getAfterDisc4());
            invoiceLine.setAfterDisc5(object.getAfterDisc5());
            invoiceLine.setAfterDisc6(object.getAfterDisc6());
            invoiceLine.setAfterDisc7(object.getAfterDisc7());
            invoiceLine.setAfterDisc8(object.getAfterDisc8());
            invoiceLine.setAfterTax1(object.getAfterTax1());
            invoiceLine.setAfterTax2(object.getAfterTax2());
            invoiceLine.setCurrency(object.getCurrency());
            invoiceLine.setFreeLine(object.getFreeLine());
            invoiceLine.setHeaderDicount(object.getHeaderDicount());
            invoiceLine.setInvoice(invoice);
            invoiceLine.setItem(object.getItem());
            invoiceLine.setItemDimensions(object.getItemDimensions());
            invoiceLine.setLocation(object.getLocation());
            invoiceLine.setWarehouse(object.getWarehouse());
            invoiceLine.setRemarks(object.getRemarks());
            return invoiceLine;
        }));
        invoice.getPaymentLines().clear();
        invoice.getPaymentLines().addAll(CollectionsUtility.convert(this.getSalesPaymentLines(), object -> {
            POSSalesPaymentLine paymentLine = new POSSalesPaymentLine(object.getMethodName(), object.getMethod_id(), object.getValue(), object.getAuthorizationNumber(), object.getCash());
            paymentLine.setInvoice(invoice);
            paymentLine.setMethodName(object.getMethodName());
            paymentLine.setCurrency(object.getCurrency());
            paymentLine.setShiftCode(object.getShiftCode());
            return paymentLine;
        }));
        invoice.setNetPrice(this.calcInvNet());
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getPaidCash())) {
            invoice.setPaidCash(this.calcInvNet());
        }
        invoice.assignIds();
        if (ObjectChecker.isEmptyOrZero((BigDecimal)invoice.getPaidCash())) {
            invoice.setPaidCash(invoice.getTotalPaid().subtract(invoice.totalOtherPayments()));
        }
        invoice.updateLineAndTotalMoney(null, true);
        invoice.setRemainingChange(invoice.getNetPrice().subtract(invoice.getTotalPaid()));
        POSResult posResult = POSPersister.saveOrUpdateWithActionHistory(invoice, session);
        if (posResult.isSucceeded().booleanValue()) {
            POSDataWriterUtil.writeInvoices(POSResourcesUtil.fetchMainRegister(), Arrays.asList(invoice));
        }
    }

    private void updateCommonFields(AbsPOSSales invoice) {
        invoice.setDiscountPercent(this.getDiscountPercent());
        invoice.setValueDate(this.getValueDate());
        invoice.setValueTime(this.getValueDate());
        invoice.setCustomer(this.getCustomer());
        invoice.setCurrency(this.getCurrency());
        invoice.setShiftId(this.getShiftId());
        invoice.setShiftCode(this.getShiftCode());
        invoice.setWarehouse(this.getWarehouse());
        invoice.setLocation(this.getLocation());
        invoice.setSalesMan(this.getSalesMan());
        invoice.setTable(this.getTable());
        invoice.setRemarks(this.getRemarks());
        invoice.setN1(this.getN1());
        invoice.setN2(this.getN2());
        invoice.setN3(this.getN3());
        invoice.setN4(this.getN4());
        invoice.setN5(this.getN5());
        invoice.setDate1(this.getDate1());
        invoice.setDate2(this.getDate2());
        invoice.setDate3(this.getDate3());
        invoice.setDate4(this.getDate4());
        invoice.setDate5(this.getDate5());
        invoice.setDescription1(this.getDescription1());
        invoice.setDescription2(this.getDescription2());
        invoice.setDescription3(this.getDescription3());
        invoice.setDescription4(this.getDescription4());
        invoice.setDescription5(this.getDescription5());
        invoice.setDeliveryDate(this.getDeliveryDate());
        invoice.setStrDeliveryTime(this.getStrDeliveryTime());
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return this.getSalesPaymentLines();
    }

    @Override
    public void assignIds() {
        this.getId();
        for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
            absPOSSalesLine.getId();
            absPOSSalesLine.updateInvoice(this);
        }
        for (AbsPOSPaymentLine absPOSPaymentLine : this.getSalesPaymentLines()) {
            absPOSPaymentLine.getId();
            absPOSPaymentLine.updateInvoice(this);
            absPOSPaymentLine.setShiftCode(this.getShiftCode());
            absPOSPaymentLine.setCurrency(this.getCurrency());
        }
        for (AbsPOSPaymentLine absPOSPaymentLine : this.getReturnPaymentLines()) {
            absPOSPaymentLine.getId();
            absPOSPaymentLine.updateInvoice(this);
            absPOSPaymentLine.setShiftCode(this.getShiftCode());
            absPOSPaymentLine.setCurrency(this.getCurrency());
        }
        this.setSalesTotalPaid(this.calcInvNet());
        this.setReturnTotalPaid(this.calcReturnNet().abs());
        this.setTotalPaid(this.salesTotalPaid.add(this.returnTotalPaid));
    }

    @Override
    public void initializeLists() {
        this.fetchDetails().size();
        this.getReturnPaymentLines().size();
        this.getSalesPaymentLines().size();
    }

    public void addReturnPaymentLine(String methodName, UUID methodId, BigDecimal value, String authorizationNumber, Boolean isCash) {
        this.getReturnPaymentLines().add(new POSReplacementReturnPaymentLine(methodName, methodId, value, authorizationNumber, isCash));
    }

    @Override
    public BigDecimal calcInvNet() {
        return this.getDetails().stream().filter(l -> ObjectChecker.isFalseOrNull((Boolean)l.getReturnedLine())).map(AbsPOSSalesLine::getNetPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public BigDecimal calcReturnNet() {
        return this.getDetails().stream().filter(l -> ObjectChecker.isTrue((Boolean)l.getReturnedLine())).map(AbsPOSSalesLine::getNetPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getNewPaidCash() {
        return this.newPaidCash;
    }

    public void setNewPaidCash(BigDecimal newPaidCash) {
        this.newPaidCash = newPaidCash;
    }

    public BigDecimal getSalesTotalPaid() {
        return this.salesTotalPaid;
    }

    public void setSalesTotalPaid(BigDecimal salesTotalPaid) {
        this.salesTotalPaid = salesTotalPaid;
    }

    @Override
    public UUID getFromInvoiceId() {
        return this.fromInvoiceId;
    }

    @Override
    public void setFromInvoiceId(UUID fromInvoiceId) {
        this.fromInvoiceId = fromInvoiceId;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "customer", "netPrice", "valueDate", "fromInvCode", "shiftCode");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public Date fetchValueDate() {
        return this.getValueDate();
    }

    @Override
    public void postCommitAction(Session session) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{this.getGenReturnCode(), this.getGenInvoiceCode()})) {
            this.genDocs(session, false);
        }
        super.postCommitAction(session);
    }

    @Override
    public void addPaymentDetails(Map<POSPaymentMethod, List<PaymentInfo>> payments, POSRegistery register) {
        UUID predefinedCashMethodId;
        this.updateLinesFlagIfNoFromDoc();
        if (ObjectChecker.isNotEmptyOrNull(this.getReturnPaymentLines())) {
            this.getReturnPaymentLines().clear();
        }
        if (ObjectChecker.isNotEmptyOrNull(this.getSalesPaymentLines())) {
            this.getSalesPaymentLines().clear();
        }
        if ((predefinedCashMethodId = MultiplePaymentDialog.cashMethodID()) != null) {
            BigDecimal invoicePartTotal = this.calcInvNet();
            BigDecimal returnPartTotal = this.calcReturnNet();
            BigDecimal intersectionValue = NaMaMath.getMin((BigDecimal[])new BigDecimal[]{invoicePartTotal.abs(), returnPartTotal.abs()});
            this.addReturnPaymentLine(MultiplePaymentDialog.searchForCashMethodName(), predefinedCashMethodId, intersectionValue, "", true);
            this.addPaymentLine(MultiplePaymentDialog.searchForCashMethodName(), predefinedCashMethodId, intersectionValue, "", true);
        }
        boolean totalIsPositive = this.isTotalIsPositive();
        for (Map.Entry<POSPaymentMethod, List<PaymentInfo>> entry : payments.entrySet()) {
            if (totalIsPositive) {
                this.addPaymentLines(entry, register);
                continue;
            }
            for (int i = 0; i < entry.getValue().size(); ++i) {
                PaymentInfo info = entry.getValue().get(i);
                BigDecimal value = info.getValue();
                if (ObjectChecker.areEqual((Object)entry.getKey().getId(), (Object)predefinedCashMethodId) && i == 0) {
                    value = value.subtract(this.getRemainingChange());
                }
                this.addReturnPaymentLine(entry.getKey().nameByLanguage(), entry.getKey().getId(), value, info.getProcessNumber(), ObjectChecker.areEqual((Object)entry.getKey().getId(), (Object)predefinedCashMethodId));
            }
        }
    }

    public boolean isTotalIsPositive() {
        BigDecimal invoicePartTotal = this.calcInvNet();
        BigDecimal returnPartTotal = this.calcReturnNet();
        return invoicePartTotal.abs().compareTo(returnPartTotal.abs()) > 0;
    }

    public void updateLinesFlagIfNoFromDoc() {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getFromInvCode())) {
            return;
        }
        for (POSSalesRepalcementLine line : this.getDetails()) {
            if (line.getTotalPrice().compareTo(BigDecimal.ZERO) < 0) {
                line.setReturnedLine(true);
                continue;
            }
            line.setReturnedLine(false);
        }
    }

    @Override
    public void updateFromInvoice(Session session) {
        POSSalesInvoice invoice = (POSSalesInvoice)POSPersister.findByCode(POSSalesInvoice.class, this.getFromInvCode());
        if (ObjectChecker.isNotEmptyOrNull((Object)invoice)) {
            PosSalesUtil.updateFromInvoice(this, invoice);
            POSPersister.saveOrUpdate(invoice, session);
        }
    }

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.add("fromInvCode");
        return list;
    }

    @Override
    public POSResult writeDocToServer(POSRegistery register, List<PaymentInfo> couponsInfoInPayments, List<PaymentInfo> creditNoteInfos, Callback callback, boolean preventDraft) {
        POSResult posResult = new POSResult();
        if (this.getHold()) {
            return posResult;
        }
        this.addCouponOrNoteDetailsToGenInvoice(register, couponsInfoInPayments, creditNoteInfos);
        boolean sent = POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeReplacements(register, Arrays.asList(this), callback, preventDraft)));
        if (!sent) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    public void addCouponOrNoteDetailsToGenInvoice(POSRegistery register, List<PaymentInfo> couponsInfoInPayments, List<PaymentInfo> creditNoteInfos) {
        List<?> invoices = POSPersister.searchFor("from " + POSSalesInvoice.class.getSimpleName() + " where replacementId = :id", POSPersister.params("id", this.getId()));
        if (invoices == null || invoices.size() == 0) {
            return;
        }
        POSSalesInvoice posSalesInvoice = (POSSalesInvoice)invoices.get(0);
        posSalesInvoice.processCreditNotesAndCoupons(register, creditNoteInfos, couponsInfoInPayments);
        POSPersister.saveOrUpdate(posSalesInvoice);
    }

    @Override
    public POSResult writeDocToServerFirst(POSRegistery register, List<PaymentInfo> creditNoteInfos) {
        POSResult posResult = new POSResult();
        List<ServiceResponse> serviceResponses = POSDataWriterUtil.writeReplacementsToNamaFirst(register, Arrays.asList(this));
        if (ObjectChecker.isNotEmptyOrNull(serviceResponses) && !serviceResponses.get(0).succeded()) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    public String getGenInvoiceCode() {
        return this.genInvoiceCode;
    }

    public String getGenReturnCode() {
        return this.genReturnCode;
    }

    @Override
    public BigDecimal calcCashValue() {
        return this.calcValueFromInvoiceAndReturn(true);
    }

    public BigDecimal calcValueFromInvoiceAndReturn(boolean cash) {
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{this.getGenInvoiceCode(), this.getGenReturnCode()})) {
            return BigDecimal.ZERO;
        }
        POSSalesInvoice salesInvoice = (POSSalesInvoice)POSPersister.findByCode(POSSalesInvoice.class, this.getGenInvoiceCode());
        POSSalesReturn salesReturn = (POSSalesReturn)POSPersister.findByCode(POSSalesReturn.class, this.getGenReturnCode());
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{salesInvoice, salesReturn})) {
            return BigDecimal.ZERO;
        }
        if (cash) {
            return salesInvoice.calcCashValue().subtract(salesReturn.calcCashValue());
        }
        return salesInvoice.calcDebitValue().subtract(salesReturn.calcDebitValue());
    }

    @Override
    public BigDecimal calcDebitValue() {
        return this.calcValueFromInvoiceAndReturn(false);
    }

    @Override
    protected POSRegistery fetchOriginRegister() {
        if (ObjectChecker.isEmptyOrNull((Object)this.getSrcInvoiceRegisterId())) {
            return null;
        }
        return POSPersister.findByID(POSRegistery.class, this.getSrcInvoiceRegisterId());
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.Replacement;
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return CollectionsUtility.join((List[])new List[]{SalesDocCommonFieldIds, Arrays.asList("returnCode", "fromInvCode", "returnReason")});
    }

    @Override
    public boolean canSaveInAnotherUserShift() {
        if (POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanUseAnotherUserShift).isSucceeded().booleanValue()) {
            return true;
        }
        return POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanReplaceInAnotherUserShift).isSucceeded();
    }

    @Override
    public NaMaDTO toDTO() {
        DTONamaPOSSalesReplacement dtoReplacement = new DTONamaPOSSalesReplacement();
        POSActualDTOConverter.convertToDTO(this, (DTOAbsPOSSalesDoc)dtoReplacement);
        dtoReplacement.setPosInvoiceCode(this.getFromInvCode());
        dtoReplacement.setFromDoc(EntityReferenceData.code((String)"NamaPOSSalesInvoice", (String)ServerStringUtils.toUUIDStr((Object)this.getFromInvoiceId())));
        dtoReplacement.setSrcInvoiceFromAnotherRegistr(this.getSrcInvoiceFromRemoteRegister());
        dtoReplacement.setReturnReason(this.getReturnReason() != null ? this.getReturnReason().toEntityReferenceData() : null);
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getSrcInvoiceRegisterId())) {
            dtoReplacement.setSrcInvoiceRegister(POSMasterFile.toRef("NamaPOSRegister", this.getSrcInvoiceRegisterId()));
        }
        return dtoReplacement;
    }
}

