/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.Pair;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesReturn;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSCreditNoteAndCouponUtil;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSReturnPaymentLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.details.POSSalesPaymentLine;
import com.namasoft.pos.domain.details.POSSalesReturnLine;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoice;
import com.namasoft.pos.domain.entities.IPOSFromReplacement;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReturnReason;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSEntityUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.PosSalesUtil;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hibernate.Session;

@Entity
public class POSSalesReturn
extends AbsPOSSales
implements IPOSDocFromInvoice,
IPOSFromReplacement {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSSalesReturnLine> details;
    @Transient
    private List<POSSalesInvoiceLine> invLines;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<POSReturnPaymentLine> paymentLines;
    private String replacementCode;
    private Boolean withCreditNote;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCreditNote creditNote;
    @Column(length=16)
    private UUID replacementId;
    private Boolean srcInvoiceFromRemoteRegister = false;
    private UUID srcInvoiceRegisterId;
    @JoinColumn(name="returnReason_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSReturnReason returnReason;
    private String fromInvCode;
    private UUID fromInvoiceId;
    private Boolean fromInvoiceOnServer;
    @Transient
    private Integer extendedReturnDays;

    @Override
    public UUID getSrcInvoiceRegisterId() {
        return this.srcInvoiceRegisterId;
    }

    @Override
    public void setSrcInvoiceRegisterId(UUID srcInvoiceRegisterId) {
        this.srcInvoiceRegisterId = srcInvoiceRegisterId;
    }

    @Override
    public Boolean getSrcInvoiceFromRemoteRegister() {
        return this.srcInvoiceFromRemoteRegister;
    }

    @Override
    public void setSrcInvoiceFromRemoteRegister(Boolean srcInvoiceFromRemoteRegister) {
        this.srcInvoiceFromRemoteRegister = srcInvoiceFromRemoteRegister;
    }

    @Override
    public Boolean isFromInvoiceOnServer() {
        if (this.fromInvoiceOnServer == null) {
            this.fromInvoiceOnServer = false;
        }
        return this.fromInvoiceOnServer;
    }

    @Override
    public void setFromInvoiceOnServer(Boolean fromInvoiceOnServer) {
        this.fromInvoiceOnServer = fromInvoiceOnServer;
    }

    public POSSalesReturn() {
    }

    public POSSalesReturn(AbsPosSalesScreen screen) {
        this.setDetails(new ArrayList<POSSalesReturnLine>());
        this.setPaymentLines(new ArrayList<POSReturnPaymentLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public List<POSSalesReturnLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSSalesReturnLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSSalesReturnLine> list) {
        this.details = list;
    }

    public List<POSSalesInvoiceLine> fetchInvLines() {
        if (this.invLines == null) {
            this.invLines = new ArrayList<POSSalesInvoiceLine>();
        }
        return this.invLines;
    }

    public void setInvLines(List<POSSalesInvoiceLine> invLines) {
        this.invLines = invLines;
    }

    @Override
    public String getFromInvCode() {
        return this.fromInvCode;
    }

    @Override
    public void setFromInvCode(String fromInvCode) {
        this.fromInvCode = fromInvCode;
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public String fromInvoiceCode() {
        return this.getFromInvCode();
    }

    @Override
    public void docSelectionMoreAction(AbsPOSSales doc, AbsPosSalesScreen posSalesScreen) {
        POSSalesInvoice salesInvoice;
        POSSalesReturn returnDoc = (POSSalesReturn)doc;
        if (returnDoc.isFromInvoiceOnServer().booleanValue() && (salesInvoice = posSalesScreen.searchForInvoiceOnServer(returnDoc.getFromInvCode())) != null) {
            returnDoc.setInvLines(salesInvoice.getDetails());
        }
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return this.getPaymentLines();
    }

    public List<POSReturnPaymentLine> getPaymentLines() {
        if (this.paymentLines == null) {
            this.paymentLines = new ArrayList<POSReturnPaymentLine>();
        }
        return this.paymentLines;
    }

    public void setPaymentLines(List<POSReturnPaymentLine> paymentLines) {
        this.paymentLines = paymentLines;
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID method_id, BigDecimal value, String authorizationNumber, Boolean cash) {
        return (T)new POSReturnPaymentLine(methodName, method_id, value, authorizationNumber, cash);
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        POSSalesReturnLine posSalesReturnLine = new POSSalesReturnLine();
        posSalesReturnLine.setInvoice(this);
        return (T)posSalesReturnLine;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSSalesReturn";
    }

    @Override
    public String getReplacementCode() {
        return this.replacementCode;
    }

    public void setReplacementCode(String replacementCode) {
        this.replacementCode = replacementCode;
    }

    public Boolean getWithCreditNote() {
        return this.withCreditNote;
    }

    public void setWithCreditNote(Boolean withCreditNote) {
        this.withCreditNote = withCreditNote;
    }

    public POSCreditNote getCreditNote() {
        this.creditNote = POSPersister.materialize(POSCreditNote.class, this.creditNote);
        return this.creditNote;
    }

    public void setCreditNote(POSCreditNote creditNote) {
        this.creditNote = creditNote;
    }

    @Override
    public UUID getFromInvoiceId() {
        return this.fromInvoiceId;
    }

    @Override
    public void setFromInvoiceId(UUID fromInvoiceId) {
        this.fromInvoiceId = fromInvoiceId;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "customer", "netPrice", "valueDate", "fromInvCode", "paymentMethods", "replacementCode", "shiftCode");
        return creatorUtil.createColumns(fields);
    }

    public UUID getReplacementId() {
        return this.replacementId;
    }

    public void setReplacementId(UUID replacementId) {
        this.replacementId = replacementId;
    }

    @Override
    public POSReturnReason getReturnReason() {
        this.returnReason = POSPersister.materialize(POSReturnReason.class, this.returnReason);
        return this.returnReason;
    }

    @Override
    public void setReturnReason(POSReturnReason returnReason) {
        this.returnReason = returnReason;
    }

    public List<Pair<POSPaymentMethod, BigDecimal>> fromInvoiceRequiredMethodsWithPercents() {
        ArrayList<Pair<POSPaymentMethod, BigDecimal>> list = new ArrayList<Pair<POSPaymentMethod, BigDecimal>>();
        POSSalesInvoice fromInvoice = (POSSalesInvoice)POSPersister.findByCode(POSSalesInvoice.class, this.getFromInvCode());
        if (ObjectChecker.isEmptyOrNull((Object)fromInvoice)) {
            return list;
        }
        for (POSSalesPaymentLine payLine : fromInvoice.getPaymentLines()) {
            POSPaymentMethod method;
            if (ObjectChecker.isEmptyOrNull((Object)payLine.getMethod_id()) || !(method = POSPersister.findByID(POSPaymentMethod.class, payLine.getMethod_id())).getMustBeWithFeesPercentInReturn().booleanValue()) continue;
            list.add((Pair<POSPaymentMethod, BigDecimal>)new Pair((Object)method, (Object)NaMaMath.divide((BigDecimal)payLine.getValue(), (BigDecimal)fromInvoice.getNetPrice(), (Integer)payLine.getCurrency().getFractionDecimalPlaces()).multiply(BigDecimal.valueOf(100L))));
        }
        return list;
    }

    @Override
    public List<? extends IPOSFinancialEffect> effects() {
        ArrayList<IPOSFinancialEffect> effects = new ArrayList<IPOSFinancialEffect>();
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getPaidCash())) {
            effects.add(new ReturnCashPart());
        }
        effects.add(new ReturnDebitPart());
        effects.addAll(this.getPaymentLines());
        return effects;
    }

    @Override
    public void updateFromInvoice(Session session) {
        POSSalesInvoice invoice = (POSSalesInvoice)POSPersister.findByCode(POSSalesInvoice.class, this.getFromInvCode());
        if (ObjectChecker.isNotEmptyOrNull((Object)invoice)) {
            BigDecimal cash;
            PosSalesUtil.updateFromInvoice(this, invoice);
            String cashMethodID = POSResourcesUtil.fetchMainRegister().fetchCashMethodId();
            if (ObjectChecker.isNotEmptyOrNull((Object)cashMethodID) && ObjectChecker.isEmptyOrNull(this.getPaymentLines()) && (cash = this.getNetPrice().subtract(this.calcDebitValue())).compareTo(BigDecimal.ZERO) > 0) {
                this.setPaidCash(BigDecimal.ZERO);
                POSPaymentMethod method = POSPersister.findByID(POSPaymentMethod.class, cashMethodID);
                this.addPaymentLine(method.nameByLanguage(), ServerStringUtils.strToUUID((String)cashMethodID), cash, "", true);
            }
            POSPersister.saveOrUpdate(invoice, session);
        }
    }

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.add("fromInvCode");
        return list;
    }

    @Override
    public POSResult writeDocToServer(POSRegistery register, List<PaymentInfo> couponsInfoInPayments, List<PaymentInfo> creditNoteInfos, Callback callback, boolean preventDraft) {
        POSResult posResult = new POSResult();
        if (this.getHold()) {
            return posResult;
        }
        boolean useCreditNotes = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseCreditNotes()) && ObjectChecker.isNotEmptyOrNull(creditNoteInfos);
        boolean sentToServer = false;
        if (useCreditNotes) {
            sentToServer = this.writeReturnToServer(callback, preventDraft);
            POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSCreditNoteAndCouponUtil.genAndUpdateCreditNotes(this, creditNoteInfos)));
        } else if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
            sentToServer = this.writeReturnToServer(callback, preventDraft);
        }
        if (!sentToServer) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    public boolean writeReturnToServer(Callback callback, boolean preventDraft) {
        return POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeReturns(Arrays.asList(this), callback, preventDraft)), true);
    }

    @Override
    public POSResult writeDocToServerFirst(POSRegistery register, List<PaymentInfo> creditNoteInfos) {
        boolean useCreditNotes;
        boolean failed;
        POSResult posResult = new POSResult();
        List<ServiceResponse> serviceResponses = POSDataWriterUtil.writeReturnsToNamaFirst(register, Arrays.asList(this));
        boolean bl = failed = ObjectChecker.isNotEmptyOrNull(serviceResponses) && !serviceResponses.getFirst().succeded();
        if (failed || ObjectChecker.isFalseOrNull((Boolean)this.getSent())) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        if (posResult.isFailed().booleanValue()) {
            return posResult;
        }
        boolean bl2 = useCreditNotes = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseCreditNotes()) && ObjectChecker.isNotEmptyOrNull(creditNoteInfos);
        if (useCreditNotes) {
            POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSCreditNoteAndCouponUtil.genAndUpdateCreditNotes(this, creditNoteInfos)));
        }
        return posResult;
    }

    @Override
    public BigDecimal calcCashValue() {
        return new ReturnCashPart().getAmount().negate();
    }

    @Override
    public BigDecimal calcDebitValue() {
        return new ReturnDebitPart().getAmount().negate();
    }

    @Override
    protected POSRegistery fetchOriginRegister() {
        if (ObjectChecker.isEmptyOrNull((Object)this.getSrcInvoiceRegisterId())) {
            return null;
        }
        return POSPersister.findByID(POSRegistery.class, this.getSrcInvoiceRegisterId());
    }

    public static void validateReturnOrReplacementDays(AbsPOSSales currentDoc, POSResult result, POSSalesInvoice invoice) {
        LocalDate currentDate;
        if (invoice == null || !(currentDoc instanceof IPOSDocFromInvoice)) {
            return;
        }
        IPOSDocFromInvoice fromInvoice = (IPOSDocFromInvoice)((Object)currentDoc);
        POSRegistery registery = invoice.fetchInvoiceRegister();
        if (registery == null) {
            return;
        }
        Integer returnOrReplaceWithIn = fromInvoice.fetchInvoiceGracePeriod();
        if (ObjectChecker.isEmptyOrZero((Integer)returnOrReplaceWithIn)) {
            return;
        }
        LocalDate replacementOrReturnValueDate = POSResourcesUtil.toLocalDate(invoice.calcValueDateForReplacentAndReturn());
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{replacementOrReturnValueDate, currentDate = POSResourcesUtil.toLocalDate(currentDoc.getValueDate())})) {
            return;
        }
        long diffOfDays = ChronoUnit.DAYS.between(replacementOrReturnValueDate, currentDate);
        if (diffOfDays > (long)returnOrReplaceWithIn.intValue()) {
            boolean isReplacement = POSEntityUtil.isReplacement(currentDoc.docType());
            String errMsg = isReplacement ? "Cannot replace after {0} days" : "Cannot return after {0} days";
            result.failure(POSResourcesUtil.id(errMsg, returnOrReplaceWithIn), new Object[0]);
        }
    }

    @Override
    public Integer fetchInvoiceGracePeriod() {
        return POSResourcesUtil.fetchMainRegister().getReturnInvoicesWithIn() + this.fetchExtendedReturnDays();
    }

    public Integer fetchExtendedReturnDays() {
        return ObjectChecker.toZeroIfNull((Integer)this.extendedReturnDays);
    }

    @Override
    public void setExtendedReturnOrReplacementDays(Integer extendedReturnDays) {
        this.extendedReturnDays = extendedReturnDays;
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.Return;
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return CollectionsUtility.join((List[])new List[]{SalesDocCommonFieldIds, Arrays.asList("returnCode", "fromInvCode", "returnReason")});
    }

    @Override
    public boolean canSaveInAnotherUserShift() {
        if (POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanUseAnotherUserShift).isSucceeded().booleanValue()) {
            return true;
        }
        return POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanReturnInAnotherUserShift).isSucceeded();
    }

    @Override
    public BigDecimal calcInvNet() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal calcReturnNet() {
        return this.getDetails().stream().map(AbsPOSSalesLine::getNetPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public NaMaDTO toDTO() {
        String fromInvoiceId;
        DTONamaPOSSalesReturn salesReturn = new DTONamaPOSSalesReturn();
        POSActualDTOConverter.convertToDTO(this, (DTOAbsPOSSalesDoc)salesReturn);
        salesReturn.setPosReplacementCode(this.getReplacementCode());
        salesReturn.setPosReplacementId(ServerStringUtils.toUUIDStr((Object)this.getReplacementId()));
        salesReturn.setUseCreditNotes(this.getWithCreditNote());
        salesReturn.setFromInvoiceCode(this.getFromInvCode());
        salesReturn.setSrcInvoiceFromAnotherRegistr(this.getSrcInvoiceFromRemoteRegister());
        salesReturn.setReturnReason(this.getReturnReason() != null ? this.getReturnReason().toEntityReferenceData() : null);
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getSrcInvoiceRegisterId())) {
            salesReturn.setSrcInvoiceRegister(POSMasterFile.toRef("NamaPOSRegister", this.getSrcInvoiceRegisterId()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)(fromInvoiceId = this.getFromInvCode()))) {
            salesReturn.setFromDoc(EntityReferenceData.id((String)"NamaPOSSalesInvoice", (String)ServerStringUtils.toUUIDStr((Object)this.getFromInvoiceId())));
        }
        return salesReturn;
    }

    class ReturnCashPart
    implements IPOSFinancialEffect {
        ReturnCashPart() {
        }

        @Override
        public String getShiftCode() {
            return POSSalesReturn.this.getShiftCode();
        }

        @Override
        public BigDecimal getAmount() {
            return POSSalesReturn.this.getPaidCash().subtract(POSSalesReturn.this.getChange()).negate();
        }

        @Override
        public UUID getPaymentMethodId() {
            return MultiplePaymentDialog.cashMethodID();
        }

        @Override
        public POSCurrency fetchCurrency() {
            return POSSalesReturn.this.getCurrency();
        }

        @Override
        public Boolean isCash() {
            return true;
        }

        @Override
        public Boolean isDebit() {
            return false;
        }

        @Override
        public POSMasterFile origin() {
            return POSSalesReturn.this;
        }

        @Override
        public Date fetchValueDate() {
            return POSSalesReturn.this.getValueDate();
        }

        @Override
        public String getPaymentMethodName() {
            return MultiplePaymentDialog.searchForCashMethodName();
        }
    }

    class ReturnDebitPart
    implements IPOSFinancialEffect {
        ReturnDebitPart() {
        }

        @Override
        public String getShiftCode() {
            return POSSalesReturn.this.getShiftCode();
        }

        @Override
        public BigDecimal getAmount() {
            BigDecimal creditNoteAmount = ObjectChecker.isEmptyOrNull((Object)POSSalesReturn.this.getCreditNote()) ? BigDecimal.ZERO : POSSalesReturn.this.getCreditNote().getAmount();
            return ObjectChecker.toZeroIfNull((BigDecimal)POSSalesReturn.this.getNetPrice()).subtract(POSSalesReturn.this.getTotalPaid()).subtract(creditNoteAmount).negate();
        }

        @Override
        public UUID getPaymentMethodId() {
            return null;
        }

        @Override
        public POSCurrency fetchCurrency() {
            return POSSalesReturn.this.getCurrency();
        }

        @Override
        public Boolean isCash() {
            return false;
        }

        @Override
        public Boolean isDebit() {
            return true;
        }

        @Override
        public POSMasterFile origin() {
            return POSSalesReturn.this;
        }

        @Override
        public Date fetchValueDate() {
            return POSSalesReturn.this.getValueDate();
        }

        @Override
        public String getPaymentMethodName() {
            return POSResourcesUtil.id("debitValue", new Object[0]);
        }
    }
}

