/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSInvSavingSettingsLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSInvSavingSettings;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSSavingSettingsLine;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Entity
public class POSSavingSettings
extends POSMasterFile<DTONamaPOSInvSavingSettings> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="settings")
    @OrderColumn(name="lineNumber")
    private List<POSSavingSettingsLine> lines;

    public List<POSSavingSettingsLine> getLines() {
        if (this.lines == null) {
            this.lines = new ArrayList<POSSavingSettingsLine>();
        }
        return this.lines;
    }

    public void setLines(List<POSSavingSettingsLine> lines) {
        this.lines = lines;
    }

    @Override
    public void updateData(DTONamaPOSInvSavingSettings object) {
        super.updateData(object);
        if (this.getLines() == null) {
            this.setLines(new ArrayList<POSSavingSettingsLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)object.getDetails(), this.getLines(), POSSavingSettingsLine::new);
        for (int i = 0; i < object.getDetails().size(); ++i) {
            DTONamaPOSInvSavingSettingsLine line = (DTONamaPOSInvSavingSettingsLine)object.getDetails().get(i);
            POSSavingSettingsLine detail = this.getLines().get(i);
            detail.setDocumentType(line.getPosDocumentType());
            detail.setPosInvoiceClassification((POSInvoiceClassification)POSSavable.staticFromReference(line.getInvoiceClassification()));
            detail.setSettings(this);
            detail.setSubsidiaryType(line.getSubsidiaryType());
            detail.setCustomer((POSCustomer)POSSavable.staticFromReference(line.getCustomer()));
            if (line.getSubsidiary() == null) continue;
            detail.setSubsidiaryID(ServerStringUtils.strToUUID((String)line.getSubsidiary().getId()));
            detail.setSubsidiaryNamaType(line.getSubsidiary().getEntityType());
        }
    }

    @Override
    public void initializeLists() {
        this.getLines().size();
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSInvSavingSettings";
    }

    @Override
    public void assignIds() {
        this.getId();
        for (POSSavingSettingsLine line : this.lines) {
            line.getId();
        }
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }
}

