/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSScrapDoc;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSScrapDocLine;
import com.namasoft.pos.domain.details.POSScrapDocRemovedLine;
import com.namasoft.pos.domain.entities.IHasReservationAmount;
import com.namasoft.pos.domain.entities.IPOSFromReplacement;
import com.namasoft.pos.domain.entities.IPosDocWithoutPayment;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSScrapDoc
extends AbsPOSSales
implements IPOSFromReplacement,
IHasReservationAmount,
IPosDocWithoutPayment {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="scrap")
    @OrderColumn(name="lineNumber")
    private List<POSScrapDocLine> details;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="scrap")
    @OrderColumn(name="lineNumber")
    private List<POSScrapDocRemovedLine> removedLines;
    private String scrapSrcDocType;
    @Column(length=16)
    private UUID scrapSrcDocId;
    private Boolean fromCaptainOrder = false;
    private Boolean returnBefore = false;

    public POSScrapDoc() {
    }

    public Boolean getFromCaptainOrder() {
        if (this.fromCaptainOrder == null) {
            this.fromCaptainOrder = false;
        }
        return this.fromCaptainOrder;
    }

    public String getScrapSrcDocType() {
        return this.scrapSrcDocType;
    }

    public void setScrapSrcDocType(String scrapSrcDocType) {
        this.scrapSrcDocType = scrapSrcDocType;
    }

    public UUID getScrapSrcDocId() {
        return this.scrapSrcDocId;
    }

    public void setScrapSrcDocId(UUID scrapSrcDocId) {
        this.scrapSrcDocId = scrapSrcDocId;
    }

    public void setFromCaptainOrder(Boolean fromCaptainOrder) {
        this.fromCaptainOrder = fromCaptainOrder;
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return null;
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchRemovedLines() {
        return this.getRemovedLines();
    }

    @Override
    public String fromInvoiceCode() {
        return "";
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID methodId, BigDecimal value, String authorizationNumber, Boolean cash) {
        return null;
    }

    public Boolean getReturnBefore() {
        return this.returnBefore;
    }

    public void setReturnBefore(Boolean returnBefore) {
        this.returnBefore = returnBefore;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSScrapDoc";
    }

    @Override
    public BigDecimal calcCashValue() {
        return null;
    }

    @Override
    public BigDecimal calcDebitValue() {
        return null;
    }

    public boolean totalyReturned() {
        for (POSScrapDocLine posScrapDocLine : this.getDetails()) {
            if (!ObjectChecker.areNotEqual((Object)posScrapDocLine.getQty().getValue(), (Object)posScrapDocLine.getReturnedQty())) continue;
            return false;
        }
        return true;
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.ScrapDoc;
    }

    @Override
    public void initializeLists() {
        this.fetchDetails().size();
        this.fetchDetails().forEach(l -> {
            if (l.getLocation() != null) {
                l.getLocation().getCode();
            }
            if (l.getWarehouse() != null) {
                l.getWarehouse().getCode();
            }
            if (l.getSalesman() != null) {
                l.getSalesman().getCode();
            }
        });
        this.getRemovedLines().size();
    }

    public POSRegistery fetchScrapDocRegister() {
        UUID srcScrapDocRegisterId = this.getRegisterId();
        if (srcScrapDocRegisterId == null) {
            return null;
        }
        return POSPersister.findByID(POSRegistery.class, srcScrapDocRegisterId);
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return CollectionsUtility.join((List[])new List[]{SalesDocCommonFieldIds, Arrays.asList("ScrapDocCode")});
    }

    @Override
    public BigDecimal getReservationAmount() {
        return null;
    }

    @Override
    public String getReplacementCode() {
        return null;
    }

    public List<POSScrapDocLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSScrapDocLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSScrapDocLine> details_) {
        if (ObjectChecker.isEmptyOrNull(this.details)) {
            this.details = new ArrayList<POSScrapDocLine>();
        }
        this.details.clear();
        this.details.addAll(details_);
    }

    public List<POSScrapDocRemovedLine> getRemovedLines() {
        if (this.removedLines == null) {
            this.removedLines = new ArrayList<POSScrapDocRemovedLine>();
        }
        return this.removedLines;
    }

    public POSScrapDoc(AbsPosSalesScreen screen) {
        this.setDetails(new ArrayList<POSScrapDocLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.add("fromCaptainOrder");
        return list;
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        POSScrapDocLine posScrapDocLine = new POSScrapDocLine();
        posScrapDocLine.setScrap(this);
        return (T)posScrapDocLine;
    }

    @Override
    public void updateFieldsAndSave(String code, String warehouse, String location, String receiptSrcType, UUID receiptSrcId) {
        this.setCode(code);
        this.setWarehouse(POSPersister.findByID(POSWarehouse.class, warehouse));
        this.setLocation(POSPersister.findByID(POSLocation.class, location));
        this.assignIds();
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        this.updateShiftData(register);
        this.setValueDate(new Date());
        this.setValueTime(new Date());
        POSPersister.saveOrUpdateWithActionHistory(this, null);
        if (POSResourcesUtil.currentSetting != null) {
            if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
                POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeScrapDocs(register, Arrays.asList(this))));
            }
        }
        this.setCurrentUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "customer", "salesMan", "netPrice", "valueDate", "shiftCode");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public NaMaDTO toDTO() {
        DTONamaPOSScrapDoc dtoNamaPOSScrapDoc = new DTONamaPOSScrapDoc();
        POSActualDTOConverter.convertToDTO(this, (DTOAbsPOSSalesDoc)dtoNamaPOSScrapDoc);
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{this.getScrapSrcDocType(), this.getScrapSrcDocId()})) {
            dtoNamaPOSScrapDoc.setFromDoc(new EntityReferenceData(POSScrapDoc.scrapSourceToDocumentType(this.getScrapSrcDocType()), ServerStringUtils.toUUIDStr((Object)this.getScrapSrcDocId())));
        }
        return dtoNamaPOSScrapDoc;
    }

    private static String scrapSourceToDocumentType(String scrapSrcDocType) {
        if (scrapSrcDocType.equals("FromPurchaseInvoice")) {
            return "PurchaseInvoice";
        }
        return null;
    }
}

