/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.details.DTOPOSServiceChargeLine;
import com.namasoft.modules.namapos.contracts.entities.DTOPOSServiceChargeSettings;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSServiceChargeLine;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity
public class POSServiceChargeSettings
extends POSMasterFile<DTOPOSServiceChargeSettings> {
    @Temporal(value=TemporalType.DATE)
    private Date fromDate;
    @Temporal(value=TemporalType.DATE)
    private Date toDate;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="serviceChargeSettings")
    @OrderColumn(name="lineNumber")
    private List<POSServiceChargeLine> details;

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public List<POSServiceChargeLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSServiceChargeLine>();
        }
        return this.details;
    }

    public void setDetails(List<POSServiceChargeLine> details) {
        this.details = details;
    }

    @Override
    public void assignIds() {
        super.assignIds();
        for (POSServiceChargeLine detail : this.getDetails()) {
            detail.assignIds();
        }
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    public void updateData(DTOPOSServiceChargeSettings object) {
        super.updateData(object);
        this.setFromDate(object.getFromDate());
        this.setToDate(object.getToDate());
        CollectionsUtility.makeSecondSameSize((List)object.getDetails(), this.getDetails(), POSServiceChargeLine::new);
        for (int i = 0; i < object.getDetails().size(); ++i) {
            DTOPOSServiceChargeLine dtoLine = (DTOPOSServiceChargeLine)object.getDetails().get(i);
            POSServiceChargeLine line = this.getDetails().get(i);
            line.setServiceChargeSettings(this);
            line.setFromDate(dtoLine.getFromDate());
            line.setToDate(dtoLine.getToDate());
            line.setInvoiceClassification((POSInvoiceClassification)POSSavable.staticFromReference(dtoLine.getInvoiceClassification()));
        }
    }

    @Override
    public String calcNamaEntityType() {
        return "POSServiceChargeSettings";
    }
}

