/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.entities.DTOConfigEntry;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSUser;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSSettingsInfo
extends POSMasterFile {
    private String fontName;
    @Transient
    private POSUser currentUser;
    private Integer currentDBVersion;
    private Date lastReadDate;
    private String localPOSPaymentSoundPath;
    @Lob
    private String globalConfigXML;
    @Lob
    private String posConfigXML;
    @Lob
    private String scConfigXML;

    public POSSettingsInfo() {
    }

    public POSSettingsInfo(String code) {
        this.setCode(code);
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public static POSSettingsInfo fetchConfiguration() {
        if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.currentSetting)) {
            return POSResourcesUtil.currentSetting;
        }
        POSResourcesUtil.currentSetting = null;
        List<POSSettingsInfo> settings = POSPersister.listAll(POSSettingsInfo.class);
        if (ObjectChecker.isNotEmptyOrNull(settings)) {
            POSResourcesUtil.currentSetting = settings.get(0);
        }
        return POSResourcesUtil.currentSetting;
    }

    @Override
    public String calcNamaEntityType() {
        return "";
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public static Boolean mustTransferWithSave(String type) {
        List transferWithSaveDocs = POSResourcesUtil.fetchPOSConfig().getTransferWithSaveDocs();
        if (ObjectChecker.isEmptyOrNull((Object)transferWithSaveDocs)) {
            return false;
        }
        return CollectionsUtility.filter((List)transferWithSaveDocs, object -> object.getType().equalsIgnoreCase(type)).size() > 0;
    }

    public POSUser getCurrentUser() {
        this.currentUser = POSPersister.materialize(POSUser.class, this.currentUser);
        return this.currentUser;
    }

    public void setCurrentUser(POSUser currentUser) {
        this.currentUser = currentUser;
    }

    public Integer getCurrentDBVersion() {
        if (ObjectChecker.isEmptyOrZero((Integer)this.currentDBVersion)) {
            return 0;
        }
        return this.currentDBVersion;
    }

    public void setCurrentDBVersion(Integer currentDBVersion) {
        this.currentDBVersion = currentDBVersion;
    }

    public Date getLastReadDate() {
        return this.lastReadDate;
    }

    public void setLastReadDate(Date lastReadDate) {
        this.lastReadDate = lastReadDate;
    }

    public String getGlobalConfigXML() {
        return this.globalConfigXML;
    }

    public void setGlobalConfigXML(String globalConfigXML) {
        this.globalConfigXML = globalConfigXML;
    }

    public String getPosConfigXML() {
        return this.posConfigXML;
    }

    public void setPosConfigXML(String posConfigXML) {
        this.posConfigXML = posConfigXML;
    }

    public String getLocalPOSPaymentSoundPath() {
        return this.localPOSPaymentSoundPath;
    }

    public void setLocalPOSPaymentSoundPath(String localPOSPaymentSoundPath) {
        this.localPOSPaymentSoundPath = localPOSPaymentSoundPath;
    }

    public String getScConfigXML() {
        return this.scConfigXML;
    }

    public void setScConfigXML(String scConfigXML) {
        this.scConfigXML = scConfigXML;
    }

    public void updateConfigurations(DTOConfigEntry dtoConfigEntry) {
        String moduleId = dtoConfigEntry.getModuleId();
        if (ObjectChecker.areEqual((Object)moduleId, (Object)"namapos")) {
            POSResourcesUtil.updatePOSConfig(dtoConfigEntry.getValue());
        } else if (ObjectChecker.areEqual((Object)moduleId, (Object)"supplychain")) {
            POSResourcesUtil.updateSupplyChainConfig(dtoConfigEntry.getValue());
        } else {
            POSResourcesUtil.updateGlobalConfig(dtoConfigEntry.getValue());
        }
    }
}

