/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.common.IDTOPosWithAttachments;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSStockReceipt;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.PosStockReceiptLine;
import com.namasoft.pos.domain.entities.IPosDocWithoutPayment;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSStockReceipt
extends AbsPOSSales
implements IPosDocWithoutPayment {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<PosStockReceiptLine> details;
    private String receiptSrcDocType;
    @Column(length=16)
    private UUID receiptSrcDocId;

    public POSStockReceipt() {
        if (POSResourcesUtil.generatingDataModel) {
            return;
        }
        this.setDetails(new ArrayList<PosStockReceiptLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public String getReceiptSrcDocType() {
        return this.receiptSrcDocType;
    }

    public void setReceiptSrcDocType(String receiptSrcDocType) {
        this.receiptSrcDocType = receiptSrcDocType;
    }

    public UUID getReceiptSrcDocId() {
        return this.receiptSrcDocId;
    }

    public void setReceiptSrcDocId(UUID receiptSrcDocId) {
        this.receiptSrcDocId = receiptSrcDocId;
    }

    public List<PosStockReceiptLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<PosStockReceiptLine>();
        }
        return this.details;
    }

    public void setDetails(List<PosStockReceiptLine> details) {
        this.details = details;
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return new ArrayList();
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSStockReceipt";
    }

    @Override
    public String fromInvoiceCode() {
        return "";
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID methodId, BigDecimal value, String authorizationNumber, Boolean cash) {
        return null;
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        PosStockReceiptLine line = new PosStockReceiptLine();
        line.setInvoice(this);
        return (T)line;
    }

    @Override
    public BigDecimal calcCashValue() {
        return new POSSalesInvoice.InvoiceCashPart(this).getAmount();
    }

    @Override
    public BigDecimal calcDebitValue() {
        return BigDecimal.ZERO;
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.POSStockReceipt;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "valueDate", "shiftCode");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return SalesDocCommonFieldIds;
    }

    @Override
    public void initializeLists() {
        super.initializeLists();
        this.getDetails().size();
    }

    @Override
    public void updateFieldsAndSave(String code, String warehouse, String location, String receiptSrcType, UUID receiptSrcId) {
        this.setCode(code);
        this.setWarehouse(POSPersister.findByID(POSWarehouse.class, warehouse));
        this.setLocation(POSPersister.findByID(POSLocation.class, location));
        this.assignIds();
        POSShiftOpen fetchLastShift = POSResourcesUtil.fetchLastOpenShift();
        this.setShiftCode(fetchLastShift.getCode());
        this.setValueDate(new Date());
        this.setValueTime(new Date());
        this.setReceiptSrcDocType(ObjectChecker.toStringOrEmpty((Object)receiptSrcType));
        this.setReceiptSrcDocId(receiptSrcId);
        POSPersister.saveOrUpdateWithActionHistory(this, null);
        if (POSResourcesUtil.currentSetting != null) {
            if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
                POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeStockReceipts(POSResourcesUtil.fetchMainRegister(), Arrays.asList(this))));
            }
        }
        this.setCurrentUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
    }

    @Override
    public POSResult writeDocToServerFirst(POSRegistery register, List<PaymentInfo> creditNoteInfos) {
        POSResult posResult = new POSResult();
        List<ServiceResponse> serviceResponses = POSDataWriterUtil.writeStockReceiptsToNamaFirst(register, Arrays.asList(this));
        if (ObjectChecker.isNotEmptyOrNull(serviceResponses) && !serviceResponses.get(0).succeded()) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    @Override
    public NaMaDTO toDTO() {
        DTONamaPOSStockReceipt dtoNamaPOSStockReceipt = new DTONamaPOSStockReceipt();
        dtoNamaPOSStockReceipt.setId(this.getId().toString());
        dtoNamaPOSStockReceipt.setValueDate(this.getValueDate());
        dtoNamaPOSStockReceipt.setIssueDate(dtoNamaPOSStockReceipt.getValueDate());
        dtoNamaPOSStockReceipt.setShiftCode(this.getShiftCode());
        dtoNamaPOSStockReceipt.setRegister(POSMasterFile.toRef(this.register()));
        dtoNamaPOSStockReceipt.setDetails(CollectionsUtility.convert(this.getDetails(), PosStockReceiptLine::convertToDTO));
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{this.getReceiptSrcDocType(), this.getReceiptSrcDocId()})) {
            dtoNamaPOSStockReceipt.setFromDoc(new EntityReferenceData(POSStockReceipt.receiptSourceToDocumentType(this.getReceiptSrcDocType()), ServerStringUtils.toUUIDStr((Object)this.getReceiptSrcDocId())));
        }
        dtoNamaPOSStockReceipt.setWarehouse(POSMasterFile.toRef(this.getWarehouse()));
        dtoNamaPOSStockReceipt.setLocator(POSMasterFile.toRef(this.getLocation()));
        dtoNamaPOSStockReceipt.setPosStockReceiptCode(this.getCode());
        dtoNamaPOSStockReceipt.setFirstAuthor(POSMasterFile.toRef((POSMasterFile)ObjectChecker.getFirstNotNullObj((Object[])new POSUser[]{this.getCurrentUser(), POSSettingsInfo.fetchConfiguration().getCurrentUser()})));
        POSActualDTOConverter.updateDocAttachments(this, (IDTOPosWithAttachments)dtoNamaPOSStockReceipt);
        return dtoNamaPOSStockReceipt;
    }

    private static String receiptSourceToDocumentType(String receiptSrcDocType) {
        if (receiptSrcDocType.equals("FromStockTransfer")) {
            return "StockTransfer";
        }
        if (receiptSrcDocType.equals("FromPurchaseInvoice")) {
            return "PurchaseInvoice";
        }
        return "WithoutOriginDoc";
    }
}

