/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.common.IDTOPosWithAttachments;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSStockTakingDetails;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSStockTakingDetailsDocLine;
import com.namasoft.pos.domain.entities.IPosDocWithoutPayment;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
public class POSStockTakingDetailsDoc
extends AbsPOSSales
implements IPosDocWithoutPayment {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="doc")
    @OrderColumn(name="lineNumber")
    private List<POSStockTakingDetailsDocLine> details;

    public List<POSStockTakingDetailsDocLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<POSStockTakingDetailsDocLine>();
        }
        return this.details;
    }

    public POSStockTakingDetailsDoc() {
    }

    public POSStockTakingDetailsDoc(AbsPosSalesScreen screen) {
        this.setDetails(new ArrayList<POSStockTakingDetailsDocLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public void setDetails(List<POSStockTakingDetailsDocLine> details) {
        this.details = details;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSStockTakingDetails";
    }

    @Override
    public void assignIds() {
        this.getId();
        if (ObjectChecker.isNotEmptyOrNull(this.getDetails())) {
            for (POSStockTakingDetailsDocLine l : this.getDetails()) {
                l.getId();
                l.setDoc(this);
            }
        }
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    public BigDecimal calcCashValue() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal calcDebitValue() {
        return BigDecimal.ZERO;
    }

    @Override
    public String fromInvoiceCode() {
        return null;
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return null;
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        POSStockTakingDetailsDocLine t = new POSStockTakingDetailsDocLine();
        ((AbsPOSSalesLine)t).updateInvoice(this);
        return (T)t;
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID method_id, BigDecimal value, String authorizationNumber, Boolean cash) {
        return null;
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.StockTakingDetails;
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return CollectionsUtility.join((List[])new List[]{allDocsCommonFields, Arrays.asList("invoiceCode", "warehouse", "location")});
    }

    @Override
    public void updateFieldsAndSave(String code, String warehouse, String location, String receiptSrcType, UUID receiptSrcId) {
        this.setCode(code);
        this.setWarehouse(POSPersister.findByID(POSWarehouse.class, warehouse));
        this.setLocation(POSPersister.findByID(POSLocation.class, location));
        this.assignIds();
        POSShiftOpen fetchLastShift = POSResourcesUtil.fetchLastOpenShift();
        this.setShiftCode(fetchLastShift.getCode());
        this.setValueDate(new Date());
        this.setValueTime(new Date());
        POSPersister.saveOrUpdateWithActionHistory(this, null);
        if (POSResourcesUtil.currentSetting != null) {
            if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
                POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeStockTakingDocs(POSResourcesUtil.fetchMainRegister(), Arrays.asList(this))));
            }
        }
        this.setCurrentUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "warehouse", "location", "shiftCode");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public NaMaDTO toDTO() {
        DTONamaPOSStockTakingDetails dtoReq = new DTONamaPOSStockTakingDetails();
        dtoReq.setId(this.getId().toString());
        dtoReq.setValueDate(this.getValueDate());
        dtoReq.setIssueDate(dtoReq.getValueDate());
        dtoReq.setShiftCode(this.getShiftCode());
        dtoReq.setRegister(POSSavable.staticToReference(this.register()));
        dtoReq.setDetails(CollectionsUtility.convert(this.getDetails(), POSStockTakingDetailsDocLine::convertToDTO));
        dtoReq.setWarehouse(POSMasterFile.toRef(this.getWarehouse()));
        dtoReq.setLocator(POSMasterFile.toRef(this.getLocation()));
        dtoReq.setPosStockTakingCode(this.getCode());
        dtoReq.setFirstAuthor(POSMasterFile.toRef((POSMasterFile)ObjectChecker.getFirstNotNullObj((Object[])new POSUser[]{this.getCurrentUser(), POSSettingsInfo.fetchConfiguration().getCurrentUser()})));
        POSActualDTOConverter.updateDocAttachments(this, (IDTOPosWithAttachments)dtoReq);
        return dtoReq;
    }
}

