/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.common.IDTOPosWithAttachments;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSStockTransferReq;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSStockTransferReqLine;
import com.namasoft.pos.domain.entities.IPosDocWithoutPayment;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Entity
public class POSStockTransferReq
extends AbsPOSSales
implements IPosDocWithoutPayment {
    @ManyToOne(fetch=FetchType.LAZY)
    private POSWarehouse toWarehouse;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSLocation toLocation;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="request")
    @OrderColumn(name="lineNumber")
    private List<POSStockTransferReqLine> details;

    public POSStockTransferReq() {
    }

    public POSStockTransferReq(AbsPosSalesScreen screen) {
        this.setDetails(new ArrayList<POSStockTransferReqLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSStockTransferReq";
    }

    public POSWarehouse getToWarehouse() {
        this.toWarehouse = POSPersister.materialize(POSWarehouse.class, this.toWarehouse);
        return this.toWarehouse;
    }

    public void setToWarehouse(POSWarehouse toWarehouse) {
        this.toWarehouse = toWarehouse;
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return null;
    }

    @Override
    public String fromInvoiceCode() {
        return null;
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID method_id, BigDecimal value, String authorizationNumber, Boolean cash) {
        return null;
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        POSStockTransferReqLine t = new POSStockTransferReqLine();
        ((AbsPOSSalesLine)t).updateInvoice(this);
        return (T)t;
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    public List<POSStockTransferReqLine> getDetails() {
        return this.details;
    }

    public void setDetails(List<POSStockTransferReqLine> details) {
        this.details = details;
    }

    @Override
    public void updateFieldsAndSave(String code, String fromWare, String toWare, String receiptSrcType, UUID receiptSrcId) {
        this.setCode(code);
        this.setWarehouse(POSPersister.findByID(POSWarehouse.class, fromWare));
        this.setToWarehouse(POSPersister.findByID(POSWarehouse.class, toWare));
        this.assignIds();
        POSShiftOpen fetchLastShift = POSResourcesUtil.fetchLastOpenShift();
        this.setShiftCode(fetchLastShift.getCode());
        POSPersister.saveOrUpdateWithActionHistory(this, null);
        if (POSResourcesUtil.currentSetting != null) {
            if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
                POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeStockTransferReqs(POSResourcesUtil.fetchMainRegister(), Arrays.asList(this))));
            }
        }
        this.setCurrentUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("code", "warehouse", "valueDate", "shiftCode");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public void addPaymentDetails(Map<POSPaymentMethod, List<PaymentInfo>> payments, POSRegistery register) {
    }

    @Override
    public void initializeSearchLevelLists() {
    }

    @Override
    public BigDecimal calcCashValue() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal calcDebitValue() {
        return BigDecimal.ZERO;
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.StockTransferReq;
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return CollectionsUtility.join((List[])new List[]{allDocsCommonFields, Arrays.asList("invoiceCode", "fromWarehouse", "toWarehouse")});
    }

    @Override
    public void updateToWarehouse(String toWarehouseId) {
        if (ObjectChecker.isNotEmptyOrNull((Object)toWarehouseId)) {
            this.setToWarehouse(POSPersister.findByID(POSWarehouse.class, toWarehouseId));
        } else {
            this.setToWarehouse(null);
        }
    }

    @Override
    public void updateToLocator(String toLocatorId, AbsPosSalesScreen posSalesScreen) {
        if (ObjectChecker.isNotEmptyOrNull((Object)toLocatorId)) {
            this.setToLocation(POSPersister.findByID(POSLocation.class, toLocatorId));
        } else {
            this.setToLocation(null);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getToLocation())) {
            for (AbsPOSSalesLine absPOSSalesLine : this.fetchDetails()) {
                absPOSSalesLine.setLocation(this.getToLocation());
                posSalesScreen.getSalesTable().getItems().set(posSalesScreen.getSalesTable().getItems().indexOf((Object)absPOSSalesLine), (Object)absPOSSalesLine);
            }
        }
    }

    public void setToLocation(POSLocation toLocation) {
        this.toLocation = toLocation;
    }

    public POSLocation getToLocation() {
        this.toLocation = POSPersister.materialize(POSLocation.class, this.toLocation);
        return this.toLocation;
    }

    @Override
    public void updateWarehouseFromRegister(POSWarehouse warehouse) {
        this.setToWarehouse(warehouse);
    }

    @Override
    public POSResult writeDocToServerFirst(POSRegistery register, List<PaymentInfo> creditNoteInfos) {
        POSResult posResult = new POSResult();
        List<ServiceResponse> serviceResponses = POSDataWriterUtil.writeStockTransferReqToNamaFirst(register, Arrays.asList(this));
        if (ObjectChecker.isNotEmptyOrNull(serviceResponses) && !serviceResponses.get(0).succeded()) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    @Override
    public NaMaDTO toDTO() {
        DTONamaPOSStockTransferReq dtoReq = new DTONamaPOSStockTransferReq();
        dtoReq.setId(this.getId().toString());
        dtoReq.setDocCategory(POSMasterFile.toRef(this.getDocCategory()));
        dtoReq.setPosCreationTime(this.convertDateToDateTimeString(this.getValueTime()));
        dtoReq.setValueDate(this.getValueDate());
        dtoReq.setIssueDate(dtoReq.getValueDate());
        dtoReq.setShiftCode(this.getShiftCode());
        dtoReq.setRegister(POSMasterFile.toRef(this.register()));
        dtoReq.setDetails(CollectionsUtility.convert(this.getDetails(), POSStockTransferReqLine::convertToDTO));
        dtoReq.setWarehouse(POSMasterFile.toRef(this.getWarehouse()));
        dtoReq.setToWarehouse(POSMasterFile.toRef(this.getToWarehouse()));
        dtoReq.setToLocator(POSMasterFile.toRef(this.getToLocation()));
        dtoReq.setLocator(POSMasterFile.toRef(this.getLocation()));
        dtoReq.setPosStockTransferReq(this.getCode());
        dtoReq.setFirstAuthor(POSMasterFile.toRef((POSMasterFile)ObjectChecker.getFirstNotNullObj((Object[])new POSUser[]{this.getCurrentUser(), POSSettingsInfo.fetchConfiguration().getCurrentUser()})));
        POSActualDTOConverter.updateDocAttachments(this, (IDTOPosWithAttachments)dtoReq);
        return dtoReq;
    }
}

