/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.IHasFont;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.pos.util.POSScreenSettings;
import com.namasoft.pos.util.POSSecurityUtil;
import java.util.Arrays;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Screen;

public class POSTableColumn<S, T>
extends TableColumn<S, T>
implements IHasFont {
    private String idForWidthProp;
    private String labelId;
    private static double colWidthDivisionFactor = 5.0;
    private static double smallColWidthDivisionFactor = 15.0;
    private static List SMALL_COLS_Titles = Arrays.asList("#", "");
    private Class<?> forKlass;

    public POSTableColumn() {
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanResizeSalesColumns).isFailed().booleanValue()) {
            this.setResizable(false);
        }
    }

    public POSTableColumn(String title, Class<?> klass) {
        this();
        this.labelId = title;
        this.forKlass = klass;
        this.updateLabel(title);
    }

    public POSTableColumn(String title, String colIdForWidth, Class<?> klass) {
        this(title, klass);
        this.labelId = title;
        this.forKlass = klass;
        this.idForWidthProp = colIdForWidth;
        this.addWidthListener();
    }

    public POSTableColumn(String title) {
        this(title, null);
    }

    private void addWidthListener() {
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        double tableWidth = 0.0;
        tableWidth = primaryScreenBounds.getWidth() / 1.2;
        String colWidthProp = POSScreenSettings.getProperty(this.idForWidthProp);
        double divisionFactor = colWidthDivisionFactor;
        if (SMALL_COLS_Titles.contains(this.idForWidthProp)) {
            divisionFactor = smallColWidthDivisionFactor;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)colWidthProp) && Double.valueOf(colWidthProp) > 30.0 && Double.valueOf(colWidthProp) < 500.0) {
            this.setPrefWidth(Double.valueOf(colWidthProp));
        } else {
            this.setPrefWidth(tableWidth / divisionFactor);
        }
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanResizeSalesColumns).isFailed().booleanValue()) {
            this.setResizable(false);
            return;
        }
        this.widthProperty().addListener((observable, oldValue, newValue) -> {
            if (ObjectChecker.areNotEqual((Object)newValue, (Object)oldValue)) {
                POSScreenSettings.getProperties().setProperty(this.idForWidthProp, newValue.toString());
            }
            POSScreenSettings.saveSetting(POSScreenSettings.getProperties());
        });
    }

    public void updateLabel(String title) {
        NamaLabel label = new NamaLabel(title);
        label.setStyle("-fx-padding: 8px;");
        label.setWrapText(true);
        label.setAlignment(Pos.CENTER);
        label.setTextAlignment(TextAlignment.CENTER);
        StackPane stack = new StackPane();
        stack.getChildren().add((Object)label);
        stack.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(5));
        label.prefWidthProperty().bind((ObservableValue)stack.prefWidthProperty());
        this.setGraphic((Node)stack);
    }

    public POSTableColumn(Double defaultCellWidth, Rectangle2D primaryScreenBounds, Double divisor, String title) {
        this(title);
        if (defaultCellWidth != 0.0) {
            this.setPrefWidth(defaultCellWidth);
            return;
        }
        if (divisor != 0.0) {
            this.setPrefWidth(primaryScreenBounds.getWidth() / divisor);
        }
    }

    public String getLabelId() {
        return this.labelId;
    }

    @Override
    public void refreshContent() {
        this.updateLabel(this.getLabelId());
    }
}

