/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.commonbasic.contracts.details.DTOLegalEntityTax;
import com.namasoft.modules.commonbasic.contracts.entities.DTOTaxPlan;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSLegalEntityTax;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.util.POSXMLSerializer;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

@Entity
public class POSTaxPlan
extends POSMasterFile<DTOTaxPlan> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posTax")
    @OrderColumn(name="lineNumber")
    private List<POSLegalEntityTax> taxes;
    @Lob
    private String fullDtoXml;
    private static final ConcurrentHashMap<UUID, Optional<DTOTaxPlan>> fullDTOCache = new ConcurrentHashMap();

    public List<POSLegalEntityTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<POSLegalEntityTax>();
        }
        return this.taxes;
    }

    public void setTaxes(List<POSLegalEntityTax> taxes) {
        this.taxes = taxes;
    }

    public String getFullDtoXml() {
        return this.fullDtoXml;
    }

    public void setFullDtoXml(String fullDtoXml) {
        this.fullDtoXml = fullDtoXml;
    }

    @Override
    public void initializeLists() {
        this.getTaxes().size();
    }

    @Override
    public String calcNamaEntityType() {
        return "TaxPlan";
    }

    @Override
    public void updateData(DTOTaxPlan object) {
        super.updateData(object);
        List legalEntityTaxes = object.getLegalEntityTaxes();
        CollectionsUtility.makeSecondSameSize((List)legalEntityTaxes, this.getTaxes(), POSLegalEntityTax::new);
        for (int i = 0; i < legalEntityTaxes.size(); ++i) {
            DTOLegalEntityTax tax = (DTOLegalEntityTax)legalEntityTaxes.get(i);
            POSLegalEntityTax itemTax = this.getTaxes().get(i);
            itemTax.setEffectiveFrom(tax.getEffectiveFrom());
            itemTax.setEffectiveTo(tax.getEffectiveTo());
            itemTax.setTax1(tax.getTax1());
            itemTax.setTax2(tax.getTax2());
            itemTax.setEntityType(tax.getEntityType());
            if (tax.getEntityTypeList() != null) {
                itemTax.setEntityTypeList((String)tax.getEntityTypeList().get("lines.entityType"));
            }
            if (!ObjectChecker.isNotEmptyOrNull((Object)tax.getLegalEntity())) continue;
            POSDimInfo legalEntity = new POSDimInfo();
            legalEntity.setCode(tax.getLegalEntity().getCode());
            legalEntity.setId(ServerStringUtils.strToUUID((String)tax.getLegalEntity().getId()));
            itemTax.setLegalEntity(legalEntity);
        }
        this.setFullDtoXml(POSXMLSerializer.instance().objectToXml(object));
        fullDTOCache.clear();
        POSResourcesUtil.clearPosConfigTaxPlan();
    }

    @Override
    public void assignIds() {
        if (this.getTaxes() != null) {
            for (POSLegalEntityTax tax : this.getTaxes()) {
                tax.setPosTax(this);
                tax.getId();
            }
        }
        super.assignIds();
    }

    public static DTOTaxPlan fetchFullDTOById(UUID taxPlanId) {
        if (taxPlanId == null) {
            return null;
        }
        if (fullDTOCache.containsKey(taxPlanId)) {
            return fullDTOCache.get(taxPlanId).orElse(null);
        }
        POSTaxPlan taxPlan = POSPersister.findByID(POSTaxPlan.class, taxPlanId);
        if (taxPlan == null) {
            fullDTOCache.put(taxPlanId, Optional.empty());
            return null;
        }
        return taxPlan.fetchFullDTO();
    }

    public DTOTaxPlan fetchFullDTO() {
        if (fullDTOCache.get(this.getId()) != null) {
            return fullDTOCache.get(this.getId()).orElse(null);
        }
        DTOTaxPlan taxPlan = POSXMLSerializer.instance().xmlToObject(this.fullDtoXml, DTOTaxPlan.class);
        fullDTOCache.put(this.getId(), Optional.ofNullable(taxPlan));
        return taxPlan;
    }
}

