/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.supplychain.contracts.entities.DTOWarehouse;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSLocation;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Entity
public class POSWarehouse
extends POSMasterFile<DTOWarehouse> {
    @ManyToOne(fetch=FetchType.LAZY)
    private POSLocation defaultLocator;
    private Long priority;
    private String locatorPolicy;

    public POSWarehouse() {
    }

    public POSWarehouse(String code, String name1, String name2) {
        super(code, name1, name2);
    }

    public POSLocation getDefaultLocator() {
        this.defaultLocator = POSPersister.materialize(POSLocation.class, this.defaultLocator);
        return this.defaultLocator;
    }

    public void setDefaultLocator(POSLocation defaultLocator) {
        this.defaultLocator = defaultLocator;
    }

    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Override
    public void initializeLists() {
    }

    @Override
    public void assignIds() {
        super.assignIds();
    }

    @Override
    public void updateData(DTOWarehouse dtoWarehouse) {
        super.updateData(dtoWarehouse);
        this.setPriority(dtoWarehouse.getPriority());
        this.setDefaultLocator((POSLocation)this.fromReference(dtoWarehouse.getDefaultLocator()));
        this.setLocatorPolicy(dtoWarehouse.getLocatorPolicy());
    }

    @Override
    public String calcNamaEntityType() {
        return "Warehouse";
    }

    public String getLocatorPolicy() {
        return this.locatorPolicy;
    }

    public void setLocatorPolicy(String locatorPolicy) {
        this.locatorPolicy = locatorPolicy;
    }

    public Map<String, String> getLocatorsCodes() {
        List<?> locators = POSPersister.searchFor("from " + POSLocation.class.getSimpleName() + " where warehouse = :warehouse", POSPersister.params("warehouse", this));
        if (ObjectChecker.isEmptyOrNull(locators)) {
            return new HashMap<String, String>();
        }
        return locators.stream().collect(Collectors.toMap(POSMasterFile::getCode, POSMasterFile::nameByLanguage));
    }
}

