/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSCancelReservation;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSCancelReservationPayLine;
import com.namasoft.pos.domain.details.PosCancelReservTableLine;
import com.namasoft.pos.domain.details.PosCancelReservationLine;
import com.namasoft.pos.domain.entities.IPosDocWithoutPayment;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hibernate.Session;

@Entity
public class PosCancelReservation
extends AbsPOSSales
implements IPosDocWithoutPayment {
    @Temporal(value=TemporalType.DATE)
    private Date reservationDate;
    @Temporal(value=TemporalType.TIME)
    private Date fromTime;
    @Temporal(value=TemporalType.TIME)
    private Date toTime;
    private BigDecimal reservationAmount;
    private BigDecimal deductionPercentage;
    private BigDecimal deductionValue;
    private BigDecimal netValue;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invoice")
    @OrderColumn(name="lineNumber")
    private List<PosCancelReservTableLine> tableLines;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="cancelReservation")
    @OrderColumn(name="lineNumber")
    private List<PosCancelReservationLine> details;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="cancelReservation")
    @OrderColumn(name="lineNumber")
    private List<POSCancelReservationPayLine> paymentLines;
    private Boolean paid;

    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public PosCancelReservation() {
    }

    public PosCancelReservation(AbsPosSalesScreen screen) {
        this.setDetails(new ArrayList<PosCancelReservationLine>());
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public List<POSCancelReservationPayLine> getPaymentLines() {
        if (this.paymentLines == null) {
            this.paymentLines = new ArrayList<POSCancelReservationPayLine>();
        }
        return this.paymentLines;
    }

    public void setPaymentLines(List<POSCancelReservationPayLine> paymentLines) {
        this.paymentLines = paymentLines;
    }

    public Date getReservationDate() {
        return this.reservationDate;
    }

    public void setReservationDate(Date reservationDate) {
        this.reservationDate = reservationDate;
    }

    public Date getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(Date fromTime) {
        this.fromTime = fromTime;
    }

    public Date getToTime() {
        return this.toTime;
    }

    public void setToTime(Date toTime) {
        this.toTime = toTime;
    }

    public BigDecimal getReservationAmount() {
        return this.reservationAmount;
    }

    public void setReservationAmount(BigDecimal reservationAmount) {
        this.reservationAmount = reservationAmount;
    }

    public BigDecimal getDeductionPercentage() {
        return this.deductionPercentage;
    }

    public void setDeductionPercentage(BigDecimal deductionPercentage) {
        this.deductionPercentage = deductionPercentage;
    }

    public BigDecimal getDeductionValue() {
        return this.deductionValue;
    }

    public void setDeductionValue(BigDecimal deductionValue) {
        this.deductionValue = deductionValue;
    }

    public BigDecimal getNetValue() {
        return this.netValue;
    }

    public void setNetValue(BigDecimal netValue) {
        this.netValue = netValue;
    }

    public List<PosCancelReservTableLine> getTableLines() {
        if (this.tableLines == null) {
            this.tableLines = new ArrayList<PosCancelReservTableLine>();
        }
        return this.tableLines;
    }

    public void setTableLines(List<PosCancelReservTableLine> tableLines) {
        this.tableLines = tableLines;
    }

    public List<PosCancelReservationLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<PosCancelReservationLine>();
        }
        return this.details;
    }

    public void setDetails(List<PosCancelReservationLine> details) {
        this.details = details;
    }

    @Override
    public List<? extends AbsPOSSalesLine> fetchDetails() {
        return this.getDetails();
    }

    @Override
    public List<? extends AbsPOSPaymentLine> fetchPayments() {
        return this.getPaymentLines();
    }

    @Override
    public List<? extends IPOSFinancialEffect> effects() {
        ArrayList<IPOSFinancialEffect> effects = new ArrayList<IPOSFinancialEffect>();
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getPaidCash())) {
            effects.add(new POSSalesInvoice.InvoiceCashPart(this));
        }
        effects.addAll(this.getPaymentLines());
        return effects;
    }

    @Override
    public String fromInvoiceCode() {
        return "";
    }

    @Override
    public void updateDetails(List<? extends AbsPOSSalesLine> list) {
        this.setDetails(list);
    }

    @Override
    public <T extends AbsPOSPaymentLine> T createPaymentLine(String methodName, UUID methodId, BigDecimal value, String authorizationNumber, Boolean cash) {
        return (T)new POSCancelReservationPayLine(methodName, methodId, value, authorizationNumber, cash);
    }

    @Override
    public <T extends AbsPOSSalesLine> T createBasicLine() {
        PosCancelReservationLine line = new PosCancelReservationLine();
        line.setCancelReservation(this);
        return (T)line;
    }

    @Override
    public BigDecimal calcCashValue() {
        return new POSSalesInvoice.InvoiceCashPart(this).getAmount();
    }

    @Override
    public BigDecimal calcDebitValue() {
        return BigDecimal.ZERO;
    }

    @Override
    public POSDocumentType docType() {
        return POSDocumentType.POSCancelReservation;
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        List<String> fields = Arrays.asList("reservation", "code", "customer", "reservationAmount", "netValue", "valueDate", "paymentMethods", "shiftCode");
        return creatorUtil.createColumns(fields);
    }

    @Override
    public List<String> screenFieldsToUpdate() {
        return CollectionsUtility.join((List[])new List[]{SalesDocCommonFieldIds, Arrays.asList("invoiceCode", "times", "reservationAmount")});
    }

    @Override
    public void initializeLists() {
        super.initializeLists();
        this.getTableLines().size();
    }

    @Override
    public void updateFieldsAndSave(String code, String warehouse, String location, String receiptSrcType, UUID receiptSrcId) {
        this.setCode(code);
        this.setWarehouse(POSPersister.findByID(POSWarehouse.class, warehouse));
        this.setLocation(POSPersister.findByID(POSLocation.class, location));
        this.assignIds();
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        this.updateShiftData(register);
        this.setValueDate(new Date());
        this.setValueTime(new Date());
        POSPersister.saveOrUpdateWithActionHistory(this, null);
        if (POSResourcesUtil.currentSetting != null) {
            if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) {
                POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeCancelReservations(register, Arrays.asList(this))));
            }
        }
        this.setCurrentUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSCancelReservation";
    }

    @Override
    public void postCommitAction(Session session) {
        super.postCommitAction(session);
        POSOrderReservation reservation = POSPersister.findByID(POSOrderReservation.class, this.getReservation().getId());
        reservation.setCanceled(true);
        POSPersister.saveOrUpdate(reservation, session);
    }

    @Override
    public POSResult writeDocToServer(POSRegistery register, List<PaymentInfo> couponsInfoInPayments, List<PaymentInfo> creditNoteInfos, Callback callback, boolean preventDraft) {
        boolean sent;
        POSResult posResult = new POSResult();
        if (this.getHold()) {
            return posResult;
        }
        if (POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue() && !(sent = POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writeCancelReservations(register, Arrays.asList(this)))))) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    @Override
    public POSResult writeDocToServerFirst(POSRegistery register, List<PaymentInfo> creditNoteInfos) {
        POSResult posResult = new POSResult();
        List<ServiceResponse> serviceResponses = POSDataWriterUtil.writeCancelReservationToNamaFirst(register, List.of(this));
        if (ObjectChecker.isNotEmptyOrNull(serviceResponses) && !serviceResponses.getFirst().succeded()) {
            posResult.failure(POSResourcesUtil.id("Not sent, review send errors", new Object[0]), new Object[0]);
        }
        return posResult;
    }

    @Override
    public NaMaDTO toDTO() {
        DTONamaPOSCancelReservation dto = new DTONamaPOSCancelReservation();
        POSActualDTOConverter.convertToDTO(this, (DTOAbsPOSSalesDoc)dto);
        dto.setOrderReservation(POSMasterFile.toRef(this.getReservation()));
        dto.setDeductionPercentage(this.getDeductionPercentage());
        dto.setDeductionValue(this.getDeductionValue());
        dto.setDeliveryDate(this.getDeliveryDate());
        dto.setDeliveryTime(new Date(this.calcMilliSecFromString(this.getStrDeliveryTime())));
        dto.setFromTime(this.getFromTime());
        dto.setToTime(this.getToTime());
        dto.setReservationDate(this.getReservationDate());
        dto.setReservationAmount(this.getReservationAmount());
        return dto;
    }
}

