/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSDeliveryCostLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSDeliveryCost;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.PosDeliveryCostLine;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.PosAddressRegion;
import com.namasoft.pos.domain.valueobjects.POSEntityRefData;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity
public class PosDeliveryCost
extends POSMasterFile<DTONamaPOSDeliveryCost> {
    @Temporal(value=TemporalType.DATE)
    private Date fromDate;
    @Temporal(value=TemporalType.DATE)
    private Date toDate;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posDeliveryCost")
    @OrderColumn(name="lineNumber")
    private List<PosDeliveryCostLine> details;

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public List<PosDeliveryCostLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<PosDeliveryCostLine>();
        }
        return this.details;
    }

    public void setDetails(List<PosDeliveryCostLine> details) {
        this.details = details;
    }

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    public void assignIds() {
        super.assignIds();
        for (PosDeliveryCostLine line : this.getDetails()) {
            line.getId();
            line.setPosDeliveryCost(this);
        }
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSDeliveryCost";
    }

    @Override
    public void updateData(DTONamaPOSDeliveryCost object) {
        super.updateData(object);
        this.setFromDate(object.getFromDate());
        this.setToDate(object.getToDate());
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<PosDeliveryCostLine>());
        }
        CollectionsUtility.makeSecondSameSize((List)object.getDetails(), this.getDetails(), PosDeliveryCostLine::new);
        for (int i = 0; i < object.getDetails().size(); ++i) {
            DTONamaPOSDeliveryCostLine dtoLine = (DTONamaPOSDeliveryCostLine)object.getDetails().get(i);
            PosDeliveryCostLine line = this.getDetails().get(i);
            line.setPosDeliveryCost(this);
            line.setFromDate(dtoLine.getFromDate());
            line.setToDate(dtoLine.getToDate());
            line.setDeliveryCost(dtoLine.getDeliveryCost());
            line.setAddressRegion((PosAddressRegion)this.fromReference(dtoLine.getRegion()));
            line.setCustomerRef(POSEntityRefData.fromEntityRefData(dtoLine.getCustomer()));
            line.setInvoiceClassification((POSInvoiceClassification)this.fromReference(dtoLine.getInvoiceClassification()));
        }
    }
}

