/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.basic.contracts.entities.DTOPGWMethodGroup;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.PosMethodGroupLine;
import com.namasoft.pos.domain.entities.POSRegistery;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;

@Entity
public class PosPGWMethodGroup
extends POSMasterFile<DTOPGWMethodGroup> {
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="methodGroup")
    private List<PosMethodGroupLine> details;

    @Override
    public String calcNamaEntityType() {
        return "PGWMethodGroup";
    }

    @Override
    public void updateData(DTOPGWMethodGroup object) {
        super.updateData(object);
        this.getDetails().clear();
        this.getDetails().addAll(CollectionsUtility.convert((Collection)object.getDetails(), PosMethodGroupLine::new));
        this.getDetails().forEach(l -> {
            l.assignIds();
            l.setMethodGroup(this);
        });
    }

    public List<PosMethodGroupLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<PosMethodGroupLine>();
        }
        return this.details;
    }

    public void setDetails(List<PosMethodGroupLine> details) {
        this.details = details;
    }

    @Override
    public void initializeLists() {
        super.initializeLists();
        this.getDetails().size();
    }

    @Override
    public void postCommitAction(Session session) {
        POSRegistery registery = POSResourcesUtil.fetchMainRegister();
        if (registery != null) {
            registery.postCommitAction(session);
        }
    }
}

