/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.entities.DTOPaymentTerminal;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.PosPGWMethodGroup;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;

@Entity
public class PosPaymentTerminal
extends POSMasterFile<DTOPaymentTerminal> {
    @ManyToOne(fetch=FetchType.LAZY)
    private PosPGWMethodGroup methodGroup;
    private String pgwProvider;

    @Override
    public String calcNamaEntityType() {
        return "PaymentTerminal";
    }

    public PosPGWMethodGroup getMethodGroup() {
        this.methodGroup = POSPersister.materialize(PosPGWMethodGroup.class, this.methodGroup);
        return this.methodGroup;
    }

    public void setMethodGroup(PosPGWMethodGroup methodGroup) {
        this.methodGroup = methodGroup;
    }

    public String getPgwProvider() {
        return this.pgwProvider;
    }

    public void setPgwProvider(String pgwProvider) {
        this.pgwProvider = pgwProvider;
    }

    @Override
    public void updateData(DTOPaymentTerminal object) {
        super.updateData(object);
        this.setMethodGroup((PosPGWMethodGroup)this.fromReference(object.getMethodGroup()));
        this.setPgwProvider(object.getPgwProvider());
    }

    @Override
    public void initializeLists() {
        PosPGWMethodGroup methodGroup = this.getMethodGroup();
        if (ObjectChecker.isNotEmptyOrNull((Object)methodGroup)) {
            methodGroup.initializeLists();
        }
    }
}

