/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSTable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.util.Date;
import java.util.UUID;

@Entity
public class PosTableEntry
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    public UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSTable posTable;
    private Date reservationFrom;
    private Date reservationTo;
    private Boolean busyTable;
    @Column(length=16)
    public UUID documentId;
    public String documentCode;
    private Date valueDate;

    public String getDocumentCode() {
        return this.documentCode;
    }

    public void setDocumentCode(String documentCode) {
        this.documentCode = documentCode;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    public UUID getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(UUID documentId) {
        this.documentId = documentId;
    }

    public POSTable getPosTable() {
        this.posTable = POSPersister.materialize(POSTable.class, this.posTable);
        return this.posTable;
    }

    public void setPosTable(POSTable posTable) {
        this.posTable = posTable;
    }

    public Date getReservationFrom() {
        return this.reservationFrom;
    }

    public void setReservationFrom(Date reservationFrom) {
        this.reservationFrom = reservationFrom;
    }

    public Date getReservationTo() {
        return this.reservationTo;
    }

    public void setReservationTo(Date reservationTo) {
        this.reservationTo = reservationTo;
    }

    public Boolean getBusyTable() {
        if (this.busyTable == null) {
            this.busyTable = false;
        }
        return this.busyTable;
    }

    public void setBusyTable(Boolean busyTable) {
        this.busyTable = busyTable;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }
}

