/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.entities;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSShortcutLine;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSShortcuts;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.application.PosShortcutsUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.ShortcutLine;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Entity
public class Shortcuts
extends POSMasterFile<DTONamaPOSShortcuts> {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    @JoinColumn(name="shortcuts_id")
    List<ShortcutLine> details;

    @Override
    public void initializeLists() {
        this.getDetails().size();
    }

    @Override
    public void assignIds() {
        this.getId();
        this.getDetails().forEach(ShortcutLine::assignIds);
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void updateData(DTONamaPOSShortcuts shortcuts) {
        super.updateData(shortcuts);
        CollectionsUtility.makeSecondSameSize((List)shortcuts.getShortcuts(), this.getDetails(), ShortcutLine::new);
        for (int i = 0; i < shortcuts.getShortcuts().size(); ++i) {
            ShortcutLine line = this.getDetails().get(i);
            DTONamaPOSShortcutLine shortcut = (DTONamaPOSShortcutLine)shortcuts.getShortcuts().get(i);
            line.setBusinessFunction(shortcut.getBizFunction());
            line.setScreenFieldID(shortcut.getPosScreenFieldID());
            line.setTheKey(shortcut.getShortCut().getTheKey());
            line.setUseAlt(shortcut.getShortCut().getUseAlt());
            line.setUseCtrl(shortcut.getShortCut().getUseCtrl());
            line.setUseShift(shortcut.getShortCut().getUseShift());
        }
    }

    @Override
    public void afterCommitSuccessfully() {
        PosShortcutsUtil.resetShortCuts();
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPOSShortcuts";
    }

    public List<ShortcutLine> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<ShortcutLine>();
        }
        return this.details;
    }

    public void setDetails(List<ShortcutLine> details) {
        this.details = details;
    }
}

