/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.reporting;

import com.namasoft.common.utilities.ObjectChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static String readFile(String fileName, String ls) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String line = null;
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            reader.close();
            return stringBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readStream(InputStream stream) {
        try {
            String string = IOUtils.toString((InputStream)stream);
            stream.close();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFile(String fileName, String data, boolean override) {
        File file;
        if (!override && (file = new File(fileName)).exists()) {
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(fileName));
            writer.write(data);
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void deleteFolder(String path) {
        File file = new File(path);
        String[] list = file.list();
        if (ObjectChecker.isNotEmptyOrNull((Object)list)) {
            for (int i = 0; i < list.length; ++i) {
                FileUtils.deleteFolder(path + "/" + list[i]);
            }
        }
        file.delete();
    }

    public static String getWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getWebInfoPath() {
        File myClass = new File(FileUtils.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        for (int i = 0; i < 2; ++i) {
            myClass = myClass.getParentFile();
        }
        return myClass.getAbsolutePath().replaceAll("%20", " ") + File.separator;
    }

    public static boolean isZipFile(String fileName) {
        return FileUtils.isFileExtension(fileName, ".zip");
    }

    public static boolean isJRXMLFile(String fileName) {
        return FileUtils.isFileExtension(fileName, ".jrxml");
    }

    public static boolean isFileExtension(String fileName, String extension) {
        String fileNameLowerCase = fileName.toLowerCase();
        boolean isFileOfExtension = fileNameLowerCase.endsWith(extension.toLowerCase());
        return isFileOfExtension;
    }
}

