/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOMoneyEffectDetails;
import com.namasoft.pos.util.POSMoneyUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Transient;
import java.math.BigDecimal;

@Embeddable
public class POSDiscountTax {
    @Column(precision=20, scale=10)
    private BigDecimal percentage;
    @Column(precision=20, scale=10)
    private BigDecimal value;

    public POSDiscountTax() {
    }

    public POSDiscountTax(BigDecimal percent, BigDecimal val) {
        this.percentage = percent;
        this.value = val;
    }

    public BigDecimal getPercentage() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.percentage)) {
            return BigDecimal.ZERO;
        }
        return this.percentage;
    }

    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    public BigDecimal getValue() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.value)) {
            return BigDecimal.ZERO;
        }
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public static POSDiscountTax fromDiscountEffect(DTOMoneyEffectDetails effect) {
        Integer fractionDecimalPlaces = POSMoneyUtils.fractionalDecimalPlaces;
        POSDiscountTax discountTax = new POSDiscountTax();
        if (ObjectChecker.isNotEmptyOrNull((Object)effect)) {
            if (ObjectChecker.isAnyNotEmptyOrZero((BigDecimal[])new BigDecimal[]{effect.getPercentage(), effect.getMaxNormalPercent()})) {
                discountTax.setPercentage(NaMaMath.round((BigDecimal)ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{effect.getPercentage(), effect.getMaxNormalPercent()}), (Integer)POSMoneyUtils.getPercentageScale()));
            }
            if (ObjectChecker.isNotEmptyOrZero((BigDecimal)effect.getValue())) {
                discountTax.setValue(NaMaMath.round((BigDecimal)effect.getValue(), (Integer)fractionDecimalPlaces));
            }
        }
        return discountTax;
    }

    public void updateNulls() {
        this.setPercentage(ObjectChecker.toZeroIfNull((BigDecimal)this.getPercentage()));
        this.setValue(ObjectChecker.toZeroIfNull((BigDecimal)this.getValue()));
    }

    @Transient
    public boolean isEmptyOrZero() {
        return ObjectChecker.isEmptyOrZero((BigDecimal)this.percentage) && ObjectChecker.isEmptyOrZero((BigDecimal)this.value);
    }
}

