/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.modules.namapos.contracts.valueobjects.DTONamaPOSItemQtyUpdater;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemQtyUpdateConfig;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
public class POSItemCurrentQuantitySysEntry
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    POSItemQtyUpdateConfig config;
    @ManyToOne(fetch=FetchType.LAZY)
    POSWarehouse warehouse;
    @ManyToOne(fetch=FetchType.LAZY)
    POSLocation location;
    Date lastUpdateTime;
    BigDecimal currentQty;
    @ManyToOne(fetch=FetchType.LAZY)
    POSItem item;
    @Embedded
    POSItemSpecificDimensions specificDimensions;
    String dimensionIdx;

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public POSItemQtyUpdateConfig getConfig() {
        this.config = POSPersister.materialize(POSItemQtyUpdateConfig.class, this.config);
        return this.config;
    }

    public void setConfig(POSItemQtyUpdateConfig config) {
        this.config = config;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public BigDecimal getCurrentQty() {
        return this.currentQty;
    }

    public void setCurrentQty(BigDecimal currentQty) {
        this.currentQty = currentQty;
    }

    public POSItem getItem() {
        this.item = POSPersister.materialize(POSItem.class, this.item);
        return this.item;
    }

    public void setItem(POSItem item) {
        this.item = item;
    }

    public POSItemSpecificDimensions getSpecificDimensions() {
        if (this.specificDimensions == null) {
            this.specificDimensions = new POSItemSpecificDimensions();
        }
        return this.specificDimensions;
    }

    public void setSpecificDimensions(POSItemSpecificDimensions specificDimensions) {
        this.specificDimensions = specificDimensions;
    }

    public POSWarehouse getWarehouse() {
        this.warehouse = POSPersister.materialize(POSWarehouse.class, this.warehouse);
        return this.warehouse;
    }

    public void setWarehouse(POSWarehouse warehouse) {
        this.warehouse = warehouse;
    }

    public POSLocation getLocation() {
        this.location = POSPersister.materialize(POSLocation.class, this.location);
        return this.location;
    }

    public void setLocation(POSLocation location) {
        this.location = location;
    }

    public String getDimensionIdx() {
        return this.dimensionIdx;
    }

    public void setDimensionIdx(String dimensionIdx) {
        this.dimensionIdx = dimensionIdx;
    }

    public void updateFrom(DTONamaPOSItemQtyUpdater updater) {
        this.setConfig((POSItemQtyUpdateConfig)POSSavable.staticFromReference(updater.getConfig()));
        this.setCurrentQty(updater.getCurrentQty());
        this.setLastUpdateTime(updater.getLastUpdateTime());
        this.setItem((POSItem)POSSavable.staticFromReference(updater.getItem()));
        this.setWarehouse((POSWarehouse)POSSavable.staticFromReference(updater.getSpecificDimensions().getWarehouse()));
        this.setLocation((POSLocation)POSSavable.staticFromReference(updater.getSpecificDimensions().getLocator()));
        this.setSpecificDimensions(POSItemSpecificDimensions.fromDTOItemSpecificDimensions(updater.getSpecificDimensions()));
        this.setDimensionIdx(updater.getDimensionsIdx());
    }
}

