/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.basic.enums.PriceListDefaultPrice;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceReqDetail;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceReqType;
import jakarta.persistence.Column;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class POSItemSalesPriceReq {
    private List<POSSalesPriceReqDetail> details;
    private List<UUID> items;
    private List<BigDecimal> qtys;
    private List<BigDecimal> netValues;
    private Boolean findRelatedItems;
    private POSSalesPriceReqType requestType;
    private Date valueDate;
    private Date valueDateTime;
    private POSCustomer customer;
    private BigDecimal headerPercent;
    private BigDecimal headerTax3Percent;
    private BigDecimal headerTax4Percent;
    private BigDecimal totalValue;
    private BigDecimal afterDiscount1;
    private BigDecimal afterDiscount2;
    private BigDecimal afterDiscount3;
    private BigDecimal afterDiscount4;
    private BigDecimal afterDiscount5;
    private BigDecimal afterDiscount6;
    private BigDecimal afterDiscount7;
    private BigDecimal netValue;
    private Boolean forcePriceList;
    private POSInvoiceClassification invoiceClassification;
    private POSUser employee;
    private POSSalesPriceClassifier1 priceClassifier1;
    private POSSalesPriceClassifier2 priceClassifier2;
    private POSSalesPriceClassifier3 priceClassifier3;
    private POSSalesPriceClassifier4 priceClassifier4;
    private POSSalesPriceClassifier5 priceClassifier5;
    private boolean priceOnly;
    private Integer fractionalDecimalPlaces;
    private String entityType;
    private BigDecimal invoiceTotal;
    @Column(length=16)
    private UUID subsidiaryId;
    private String subsidiaryType;
    private PriceListDefaultPrice priceListDefaultPrice;
    private POSGenericDims genericDims;

    public POSGenericDims getGenericDims() {
        return this.genericDims;
    }

    public void setGenericDims(POSGenericDims genericDims) {
        this.genericDims = genericDims;
    }

    public PriceListDefaultPrice getPriceListDefaultPrice() {
        return this.priceListDefaultPrice;
    }

    public void setPriceListDefaultPrice(PriceListDefaultPrice priceListDefaultPrice) {
        this.priceListDefaultPrice = priceListDefaultPrice;
    }

    public UUID getSubsidiaryId() {
        return this.subsidiaryId;
    }

    public void setSubsidiaryId(UUID subsidiaryId) {
        this.subsidiaryId = subsidiaryId;
    }

    public String getSubsidiaryType() {
        return this.subsidiaryType;
    }

    public void setSubsidiaryType(String subsidiaryType) {
        this.subsidiaryType = subsidiaryType;
    }

    public Date getValueDateTime() {
        return this.valueDateTime;
    }

    public void setValueDateTime(Date valueDateTime) {
        this.valueDateTime = valueDateTime;
    }

    public BigDecimal getInvoiceTotal() {
        return this.invoiceTotal;
    }

    public void setInvoiceTotal(BigDecimal invoiceTotal) {
        this.invoiceTotal = invoiceTotal;
    }

    public Integer getFractionalDecimalPlaces() {
        return this.fractionalDecimalPlaces;
    }

    public void setFractionalDecimalPlaces(Integer fractionalDecimalPlaces) {
        this.fractionalDecimalPlaces = fractionalDecimalPlaces;
    }

    public POSSalesPriceClassifier1 getPriceClassifier1() {
        return this.priceClassifier1;
    }

    public void setPriceClassifier1(POSSalesPriceClassifier1 priceClassifier1) {
        this.priceClassifier1 = priceClassifier1;
    }

    public POSSalesPriceClassifier2 getPriceClassifier2() {
        return this.priceClassifier2;
    }

    public void setPriceClassifier2(POSSalesPriceClassifier2 priceClassifier2) {
        this.priceClassifier2 = priceClassifier2;
    }

    public POSSalesPriceClassifier3 getPriceClassifier3() {
        return this.priceClassifier3;
    }

    public void setPriceClassifier3(POSSalesPriceClassifier3 priceClassifier3) {
        this.priceClassifier3 = priceClassifier3;
    }

    public POSSalesPriceClassifier4 getPriceClassifier4() {
        return this.priceClassifier4;
    }

    public void setPriceClassifier4(POSSalesPriceClassifier4 priceClassifier4) {
        this.priceClassifier4 = priceClassifier4;
    }

    public POSSalesPriceClassifier5 getPriceClassifier5() {
        return this.priceClassifier5;
    }

    public void setPriceClassifier5(POSSalesPriceClassifier5 priceClassifier5) {
        this.priceClassifier5 = priceClassifier5;
    }

    public List<POSSalesPriceReqDetail> getDetails() {
        return this.details;
    }

    public void setDetails(List<POSSalesPriceReqDetail> details) {
        this.details = details;
    }

    public List<UUID> getItems() {
        return this.items;
    }

    public void setItems(List<UUID> items) {
        this.items = items;
    }

    public List<BigDecimal> getQtys() {
        return this.qtys;
    }

    public void setQtys(List<BigDecimal> qtys) {
        this.qtys = qtys;
    }

    public List<BigDecimal> getNetValues() {
        return this.netValues;
    }

    public void setNetValues(List<BigDecimal> netValues) {
        this.netValues = netValues;
    }

    public Boolean getFindRelatedItems() {
        return this.findRelatedItems;
    }

    public void setFindRelatedItems(Boolean findRelatedItems) {
        this.findRelatedItems = findRelatedItems;
    }

    public POSSalesPriceReqType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(POSSalesPriceReqType requestType) {
        this.requestType = requestType;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        if (valueDate != null) {
            valueDate = POSItemSalesPriceReq.removeTimeAndGetDateOnly(valueDate);
        }
        this.valueDate = valueDate;
    }

    public static Date removeTimeAndGetDateOnly(Date date) {
        ZonedDateTime zdt = date.toInstant().atZone(ZoneId.systemDefault());
        LocalDate localDate = zdt.toLocalDate();
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public POSCustomer getCustomer() {
        return this.customer;
    }

    public void setCustomer(POSCustomer customer) {
        this.customer = customer;
    }

    public BigDecimal getHeaderPercent() {
        return this.headerPercent;
    }

    public void setHeaderPercent(BigDecimal headerPercent) {
        this.headerPercent = headerPercent;
    }

    public BigDecimal getHeaderTax3Percent() {
        return this.headerTax3Percent;
    }

    public void setHeaderTax3Percent(BigDecimal headerTax3Percent) {
        this.headerTax3Percent = headerTax3Percent;
    }

    public BigDecimal getHeaderTax4Percent() {
        return this.headerTax4Percent;
    }

    public void setHeaderTax4Percent(BigDecimal headerTax4Percent) {
        this.headerTax4Percent = headerTax4Percent;
    }

    public BigDecimal getTotalValue() {
        return this.totalValue;
    }

    public void setTotalValue(BigDecimal totalValue) {
        this.totalValue = totalValue;
    }

    public BigDecimal getAfterDiscount1() {
        return this.afterDiscount1;
    }

    public void setAfterDiscount1(BigDecimal afterDiscount1) {
        this.afterDiscount1 = afterDiscount1;
    }

    public BigDecimal getAfterDiscount2() {
        return this.afterDiscount2;
    }

    public void setAfterDiscount2(BigDecimal afterDiscount2) {
        this.afterDiscount2 = afterDiscount2;
    }

    public BigDecimal getAfterDiscount3() {
        return this.afterDiscount3;
    }

    public void setAfterDiscount3(BigDecimal afterDiscount3) {
        this.afterDiscount3 = afterDiscount3;
    }

    public BigDecimal getAfterDiscount4() {
        return this.afterDiscount4;
    }

    public void setAfterDiscount4(BigDecimal afterDiscount4) {
        this.afterDiscount4 = afterDiscount4;
    }

    public BigDecimal getAfterDiscount5() {
        return this.afterDiscount5;
    }

    public void setAfterDiscount5(BigDecimal afterDiscount5) {
        this.afterDiscount5 = afterDiscount5;
    }

    public BigDecimal getAfterDiscount6() {
        return this.afterDiscount6;
    }

    public void setAfterDiscount6(BigDecimal afterDiscount6) {
        this.afterDiscount6 = afterDiscount6;
    }

    public BigDecimal getAfterDiscount7() {
        return this.afterDiscount7;
    }

    public void setAfterDiscount7(BigDecimal afterDiscount7) {
        this.afterDiscount7 = afterDiscount7;
    }

    public BigDecimal getNetValue() {
        return this.netValue;
    }

    public void setNetValue(BigDecimal netValue) {
        this.netValue = netValue;
    }

    public Boolean getForcePriceList() {
        return this.forcePriceList;
    }

    public void setForcePriceList(Boolean forcePriceList) {
        this.forcePriceList = forcePriceList;
    }

    public POSInvoiceClassification getInvoiceClassification() {
        return this.invoiceClassification;
    }

    public void setInvoiceClassification(POSInvoiceClassification invoiceClassification) {
        this.invoiceClassification = invoiceClassification;
    }

    public POSUser getEmployee() {
        return this.employee;
    }

    public void setEmployee(POSUser employee) {
        this.employee = employee;
    }

    public POSItemSalesPriceReq cloneHeader() {
        POSItemSalesPriceReq itemSalesPriceReq = new POSItemSalesPriceReq();
        itemSalesPriceReq.setItems(this.getItems());
        itemSalesPriceReq.setQtys(this.getQtys());
        itemSalesPriceReq.setDetails(this.getDetails());
        itemSalesPriceReq.setNetValues(this.getNetValues());
        return itemSalesPriceReq;
    }

    public UUID customerCategoryId() {
        if (ObjectChecker.isEmptyOrNull((Object)this.getCustomer())) {
            return null;
        }
        if (ObjectChecker.isEmptyOrNull((Object)this.getCustomer().getCustomerCategory())) {
            return null;
        }
        return this.getCustomer().getCustomerCategory().getId();
    }

    public boolean isPriceOnly() {
        return this.priceOnly;
    }

    public void setPriceOnly(boolean priceOnly) {
        this.priceOnly = priceOnly;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }
}

