/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTORawQuantity;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.domain.entities.POSUnit;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;

@Embeddable
public class POSQuantity {
    @Column(precision=20, scale=10)
    private BigDecimal value;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUnit uom;

    public POSQuantity() {
    }

    public POSQuantity(BigDecimal val, POSUnit uom) {
        this.setValue(val);
        this.setUom(uom);
    }

    public POSQuantity(BigDecimal val, String uomCode) {
        this.setValue(val);
        this.setUom((POSUnit)POSPersister.findByCode(POSUnit.class, uomCode));
    }

    public BigDecimal getValue() {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)this.value)) {
            return BigDecimal.ZERO;
        }
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public POSUnit getUom() {
        this.uom = POSPersister.materialize(POSUnit.class, this.uom);
        return this.uom;
    }

    public void setUom(POSUnit uom) {
        this.uom = uom;
    }

    public static POSQuantity fromDTORawQuantity(DTORawQuantity dtoQty, POSSavable requester) {
        POSQuantity qty = new POSQuantity();
        qty.setUom((POSUnit)requester.fromReference(dtoQty.getUom()));
        qty.setValue(dtoQty.getValue());
        return qty;
    }

    public static DTORawQuantity toDTORawQuantity(POSQuantity qty) {
        DTORawQuantity rawQty = new DTORawQuantity();
        rawQty.setUom(POSSavable.staticToReference(qty.getUom()));
        rawQty.setValue(qty.getValue());
        return rawQty;
    }

    public POSQuantity cloneData() {
        POSQuantity rawQuantity = new POSQuantity();
        rawQuantity.setUom(this.getUom());
        rawQuantity.setValue(this.getValue());
        return rawQuantity;
    }
}

