/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.valueobjects;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import java.util.UUID;

@Entity
public class PosFieldAllowedValues
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    private String entityType;
    private String fieldId;
    private String allowedValues;

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(String allowedValues) {
        this.allowedValues = allowedValues;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public boolean matches(String forType, String fieldId) {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getEntityType()) && ObjectChecker.areNotEqual((Object)this.getEntityType(), (Object)forType)) {
            return false;
        }
        return ObjectChecker.areEqual((Object)this.getFieldId(), (Object)fieldId);
    }
}

