/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.factories;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesInvoice;
import com.namasoft.pos.domain.details.POSSalesInvoiceCouponLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceCreditNoteLine;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.factories.AbsPOSSalesInvoiceFactory;
import com.namasoft.pos.factories.POSSalesInvoiceLineFactory;
import com.namasoft.pos.factories.POSSalesPaymentLineFactory;
import java.math.BigDecimal;

public class POSSalesInvoiceFactory {
    public static POSSalesInvoice createPOSInvoiceFromDTO(DTONamaPOSSalesInvoice dtoNamaPOSSalesInvoice) {
        POSSalesInvoice invoice = new POSSalesInvoice();
        AbsPOSSalesInvoiceFactory.updatePOSDataFromDTO(invoice, (DTOAbsPOSSalesDoc)dtoNamaPOSSalesInvoice);
        invoice.setReplacementCode(dtoNamaPOSSalesInvoice.getPosReplacementCode());
        invoice.setReplacementId(ServerStringUtils.strToUUID((String)dtoNamaPOSSalesInvoice.getPosReplacementId()));
        dtoNamaPOSSalesInvoice.getDetails().forEach(l -> invoice.getDetails().add(POSSalesInvoiceLineFactory.createPOSInvoiceLineFromDTO(invoice, l)));
        dtoNamaPOSSalesInvoice.getPayments().forEach(l -> invoice.getPaymentLines().add(POSSalesPaymentLineFactory.createPOSPaymentLineFromDTO(l, invoice)));
        dtoNamaPOSSalesInvoice.getExternalPaymentLines().forEach(l -> {
            BigDecimal paymentValue = l.getPaymentValue();
            String paymentDocCode = l.getPaymentDocument().getCode();
            if (ObjectChecker.areEqual((Object)l.getPaymentDocument().getEntityType(), (Object)"NamaPOSCreditNote")) {
                POSSalesInvoiceCreditNoteLine creditNoteLine = new POSSalesInvoiceCreditNoteLine();
                creditNoteLine.setCreditNoteCode(paymentDocCode);
                creditNoteLine.setCreditNoteValue(paymentValue);
                creditNoteLine.setInvoice(invoice);
                invoice.getCreditNotes().add(creditNoteLine);
            }
            if (ObjectChecker.areEqual((Object)l.getPaymentDocument().getEntityType(), (Object)"DiscountCoupon")) {
                POSSalesInvoiceCouponLine line = new POSSalesInvoiceCouponLine();
                line.setInvoice(invoice);
                line.setCouponCode(paymentDocCode);
                line.setCouponValue(paymentValue);
                invoice.getCoupons().add(line);
            }
        });
        return invoice;
    }
}

